/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.context.ChainedTilesContextFactory;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesContainerFactory {
    public static final String CONTAINER_FACTORY_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory";
    public static final String CONTAINER_FACTORY_MUTABLE_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory.MUTABLE";
    public static final String CONTEXT_FACTORY_INIT_PARAM = "org.apache.tiles.context.TilesContextFactory";
    public static final String DEFINITIONS_FACTORY_INIT_PARAM = "org.apache.tiles.definition.DefinitionsFactory";
    public static final String PREPARER_FACTORY_INIT_PARAM = "org.apache.tiles.preparer.PreparerFactory";
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    protected Map<String, String> defaultConfiguration = new HashMap<String, String>(DEFAULTS);

    public static TilesContainerFactory getFactory(Object context) throws TilesException {
        return TilesContainerFactory.getFactory(context, DEFAULTS);
    }

    public static TilesContainerFactory getFactory(Object context, Map<String, String> defaults) throws TilesException {
        HashMap<String, String> configuration = new HashMap<String, String>(defaults);
        configuration.putAll(TilesContainerFactory.getInitParameterMap(context));
        TilesContainerFactory factory = (TilesContainerFactory)TilesContainerFactory.createFactory(configuration, CONTAINER_FACTORY_INIT_PARAM);
        factory.setDefaultConfiguration(defaults);
        return factory;
    }

    public TilesContainer createContainer(Object context) throws TilesException {
        String value = TilesContainerFactory.getInitParameter(context, CONTAINER_FACTORY_MUTABLE_INIT_PARAM);
        if (Boolean.parseBoolean(value)) {
            return this.createMutableTilesContainer(context);
        }
        return this.createTilesContainer(context);
    }

    public void setDefaultConfiguration(Map<String, String> defaultConfiguration) {
        if (defaultConfiguration != null) {
            this.defaultConfiguration.putAll(defaultConfiguration);
        }
    }

    public void setDefaultValue(String key, String value) {
        this.defaultConfiguration.put(key, value);
    }

    public TilesContainer createTilesContainer(Object context) throws TilesException {
        BasicTilesContainer container = new BasicTilesContainer();
        this.initializeContainer(context, container);
        return container;
    }

    public MutableTilesContainer createMutableTilesContainer(Object context) throws TilesException {
        CachingTilesContainer container = new CachingTilesContainer();
        this.initializeContainer(context, container);
        return container;
    }

    protected void initializeContainer(Object context, BasicTilesContainer container) throws TilesException {
        Map<String, String> initParameterMap = TilesContainerFactory.getInitParameterMap(context);
        HashMap<String, String> configuration = new HashMap<String, String>(this.defaultConfiguration);
        configuration.putAll(initParameterMap);
        this.storeContainerDependencies(context, initParameterMap, configuration, container);
        container.init(initParameterMap);
    }

    protected void storeContainerDependencies(Object context, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) throws TilesException {
        TilesContextFactory contextFactory = (TilesContextFactory)TilesContainerFactory.createFactory(configuration, CONTEXT_FACTORY_INIT_PARAM);
        DefinitionsFactory defsFactory = (DefinitionsFactory)TilesContainerFactory.createFactory(configuration, DEFINITIONS_FACTORY_INIT_PARAM);
        PreparerFactory prepFactory = (PreparerFactory)TilesContainerFactory.createFactory(configuration, PREPARER_FACTORY_INIT_PARAM);
        contextFactory.init(configuration);
        TilesApplicationContext tilesContext = contextFactory.createApplicationContext(context);
        container.setDefinitionsFactory(defsFactory);
        container.setContextFactory(contextFactory);
        container.setPreparerFactory(prepFactory);
        container.setApplicationContext(tilesContext);
    }

    protected static Object createFactory(Map<String, String> configuration, String initParameterName) throws TilesException {
        String factoryName = TilesContainerFactory.resolveFactoryName(configuration, initParameterName);
        return ClassUtil.instantiate(factoryName);
    }

    protected static String resolveFactoryName(Map<String, String> configuration, String parameterName) throws TilesException {
        String factoryName = configuration.get(parameterName);
        return factoryName == null ? DEFAULTS.get(parameterName) : factoryName.toString();
    }

    protected static String getInitParameter(Object context, String parameterName) throws TilesException {
        Object value;
        try {
            Class<?> contextClass = context.getClass();
            Method getInitParameterMethod = contextClass.getMethod("getInitParameter", String.class);
            value = getInitParameterMethod.invoke(context, parameterName);
        }
        catch (Exception e) {
            throw new TilesException("Unrecognized context.  Is this context a ServletContext, PortletContext, or similar?", e);
        }
        return value == null ? null : value.toString();
    }

    protected static Map<String, String> getInitParameterMap(Object context) throws TilesException {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        Class<?> contextClass = context.getClass();
        try {
            Method method = contextClass.getMethod("getInitParameterNames", new Class[0]);
            Enumeration e = (Enumeration)method.invoke(context, new Object[0]);
            method = contextClass.getMethod("getInitParameter", String.class);
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                initParameters.put(key, (String)method.invoke(context, key));
            }
        }
        catch (Exception e) {
            throw new TilesException("Unable to retrieve init parameters. Is this context a ServletContext, PortletContext, or similar object?", e);
        }
        return initParameters;
    }

    static {
        DEFAULTS.put(CONTAINER_FACTORY_INIT_PARAM, TilesContainerFactory.class.getName());
        DEFAULTS.put(CONTEXT_FACTORY_INIT_PARAM, ChainedTilesContextFactory.class.getName());
        DEFAULTS.put(DEFINITIONS_FACTORY_INIT_PARAM, UrlDefinitionsFactory.class.getName());
        DEFAULTS.put(PREPARER_FACTORY_INIT_PARAM, BasicPreparerFactory.class.getName());
    }
}

