/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.util;

import org.apache.tiles.TilesException;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Object instantiate(String className) throws TilesException {
        return ClassUtil.instantiate(className, false);
    }

    public static Object instantiate(String className, boolean returnNull) throws TilesException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (original == null) {
            Thread.currentThread().setContextClassLoader(ClassUtil.class.getClassLoader());
        }
        try {
            Class<?> namedClass = Class.forName(className);
            Object obj = namedClass.newInstance();
            return obj;
        }
        catch (ClassNotFoundException e) {
            if (returnNull) {
                Object var4_8 = null;
                return var4_8;
            }
            throw new TilesException("Unable to resolve factory class: '" + className + "'");
        }
        catch (IllegalAccessException e) {
            throw new TilesException("Unable to access factory class: '" + className + "'");
        }
        catch (InstantiationException e) {
            throw new TilesException("Unable to instantiate factory class: '" + className + "'. Make sure that this class has a default constructor");
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

