/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.opt.security.SASLInputStream;
import com.sun.jmx.remote.opt.security.SASLOutputStream;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.SASLMessage;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

public class SASLClientHandler
implements ProfileClient {
    private SaslClient saslClnt = null;
    private boolean completed = false;
    private boolean initialResponse = true;
    private byte[] blob = null;
    private Map env = null;
    private MessageConnection mc = null;
    private Socket socket = null;
    private String mechanism = null;
    private String profile = null;
    private static final byte[] EMPTY = new byte[0];
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLClientHandler");

    public SASLClientHandler(String string, Map map) {
        this.env = map;
        this.profile = string;
    }

    public void initialize(MessageConnection messageConnection) throws IOException {
        Object object;
        logger.trace("initialize", "starts");
        this.mc = messageConnection;
        if (!(messageConnection instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        this.socket = ((SocketConnectionIf)((Object)messageConnection)).getSocket();
        String string = this.profile.substring(this.profile.indexOf("SASL/") + 5);
        String[] stringArray = SASLClientHandler.getSaslMechanismNames(string);
        String string2 = (String)this.env.get("jmx.remote.sasl.authorization.id");
        String string3 = (String)this.env.get("jmx.remote.x.sasl.server.name");
        if (string3 == null) {
            string3 = this.socket.getInetAddress().getHostName();
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "mech=" + string + "; mechs=" + Arrays.asList(stringArray) + "; authzId=" + string2 + "; server=" + string3);
        }
        CallbackHandler callbackHandler = null;
        if (this.env.containsKey("jmx.remote.sasl.callback.handler")) {
            callbackHandler = (CallbackHandler)this.env.get("jmx.remote.sasl.callback.handler");
            if (logger.traceOn()) {
                logger.trace("initialize", "found callback.handler property: " + callbackHandler);
            }
        } else if (this.env.containsKey("jmx.remote.credentials")) {
            logger.trace("initialize", "found jmx.remote.credentials property");
            object = this.env.get("jmx.remote.credentials");
            if (!(object instanceof String[])) {
                if (logger.traceOn()) {
                    logger.trace("initialize", "...but it is not a String[]: " + object);
                }
            } else {
                String[] stringArray2 = (String[])object;
                if (stringArray2.length != 2) {
                    if (logger.traceOn()) {
                        logger.trace("initialize", "...but it does not have 2 elements: " + Arrays.asList(stringArray2));
                    }
                } else {
                    callbackHandler = new UserPasswordCallbackHandler(stringArray2[0], stringArray2[1]);
                }
            }
        }
        this.saslClnt = Sasl.createSaslClient(stringArray, string2, "jmxmp", string3, this.env, callbackHandler);
        if (this.saslClnt == null) {
            object = "Unable to create SASL client connection for authentication mechanism [" + string + "]";
            throw new IOException((String)object);
        }
        this.mechanism = this.saslClnt.getMechanismName();
    }

    public ProfileMessage produceMessage() throws IOException {
        if (this.initialResponse) {
            this.blob = this.saslClnt.hasInitialResponse() ? this.saslClnt.evaluateChallenge(EMPTY) : EMPTY;
            this.initialResponse = false;
        }
        SASLMessage sASLMessage = new SASLMessage(this.mechanism, 1, this.blob);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> SASL client message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + sASLMessage.getProfileName());
            logger.trace("produceMessage", "Status : " + sASLMessage.getStatus());
        }
        return sASLMessage;
    }

    public void consumeMessage(ProfileMessage profileMessage) throws IOException {
        if (!(profileMessage instanceof SASLMessage)) {
            throw new IOException("Unexpected profile message type: " + profileMessage.getClass().getName());
        }
        SASLMessage sASLMessage = (SASLMessage)profileMessage;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> SASL server message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + sASLMessage.getProfileName());
            logger.trace("consumeMessage", "Status : " + sASLMessage.getStatus());
        }
        if (sASLMessage.getStatus() != 1 && sASLMessage.getStatus() != 2) {
            throw new IOException("Unexpected SASL status [" + sASLMessage.getStatus() + "]");
        }
        if (this.saslClnt.isComplete() && sASLMessage.getStatus() == 2) {
            this.completed = true;
            return;
        }
        if (this.saslClnt.isComplete() && sASLMessage.getStatus() != 2) {
            throw new IOException("SASL authentication complete despite the server claim for non-completion");
        }
        if (!this.saslClnt.isComplete() && sASLMessage.getStatus() == 2) {
            this.blob = this.saslClnt.evaluateChallenge(sASLMessage.getBlob());
            if (this.saslClnt.isComplete()) {
                this.completed = true;
                return;
            }
            throw new IOException("SASL authentication not complete despite the server claim for completion");
        }
        if (!this.saslClnt.isComplete() && sASLMessage.getStatus() != 2) {
            this.blob = this.saslClnt.evaluateChallenge(sASLMessage.getBlob());
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void activate() throws IOException {
        String string = (String)this.saslClnt.getNegotiatedProperty("javax.security.sasl.qop");
        if (string != null && (string.equalsIgnoreCase("auth-int") || string.equalsIgnoreCase("auth-conf"))) {
            SASLInputStream sASLInputStream = new SASLInputStream(this.saslClnt, this.socket.getInputStream());
            SASLOutputStream sASLOutputStream = new SASLOutputStream(this.saslClnt, this.socket.getOutputStream());
            ((SocketConnectionIf)((Object)this.mc)).replaceStreams(sASLInputStream, sASLOutputStream);
        }
    }

    public void terminate() throws IOException {
        this.saslClnt.dispose();
    }

    public String getName() {
        return this.profile;
    }

    private static String[] getSaslMechanismNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static class UserPasswordCallbackHandler
    implements CallbackHandler {
        private String user;
        private char[] pwchars;

        UserPasswordCallbackHandler(String string, String string2) {
            this.user = string;
            this.pwchars = string2.toCharArray();
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.user);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    ((PasswordCallback)callback).setPassword(this.pwchars);
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i]);
            }
        }

        private void clearPassword() {
            if (this.pwchars != null) {
                for (int i = 0; i < this.pwchars.length; ++i) {
                    this.pwchars[i] = '\u0000';
                }
                this.pwchars = null;
            }
        }

        protected void finalize() {
            this.clearPassword();
        }
    }
}

