/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.MonInternals;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.RangeHolder;
import com.jamonapi.RangeImp;
import com.jamonapi.RowData;
import java.util.List;

class MonitorImp
extends Monitor
implements RowData {
    private static final MonKey NULL_MON_KEY = new NullMonKey();

    MonitorImp(MonInternals monData) {
        super(monData);
    }

    MonitorImp() {
        this(NULL_MON_KEY, null, null, false);
    }

    MonitorImp(MonKey key, RangeImp range, ActivityStats activityStats, boolean isTimeMonitor) {
        this.monData.key = key;
        this.monData.range = range;
        this.monData.activityStats = activityStats;
        this.monData.isTimeMonitor = isTimeMonitor;
    }

    public List getBasicHeader(List header) {
        this.monData.key.getBasicHeader(header);
        this.getThisData(header);
        return header;
    }

    private List getThisData(List header) {
        header.add(this.monData.name + "Hits");
        header.add(this.monData.name + "Avg");
        header.add(this.monData.name + "Total");
        header.add(this.monData.name + "StdDev");
        header.add(this.monData.name + "LastValue");
        header.add(this.monData.name + "Min");
        header.add(this.monData.name + "Max");
        header.add(this.monData.name + "Active");
        header.add(this.monData.name + "AvgActive");
        header.add(this.monData.name + "MaxActive");
        header.add(this.monData.name + "FirstAccess");
        header.add(this.monData.name + "LastAccess");
        header.add(this.monData.name + "Enabled");
        header.add(this.monData.name + "Primary");
        header.add(this.monData.name + "HasListeners");
        return header;
    }

    public List getHeader(List header) {
        this.monData.key.getHeader(header);
        this.getThisData(header);
        if (this.monData.range != null) {
            this.monData.range.getHeader(header);
        }
        return header;
    }

    public List getDisplayHeader(List header) {
        this.monData.key.getDisplayHeader(header);
        this.getThisData(header);
        if (this.monData.range != null) {
            this.monData.range.getDisplayHeader(header);
        }
        return header;
    }

    public List getBasicRowData(List rowData) {
        this.monData.key.getBasicRowData(rowData);
        return this.getThisRowData(rowData);
    }

    private List getThisRowData(List rowData) {
        rowData.add(new Double(this.getHits()));
        rowData.add(new Double(this.getAvg()));
        rowData.add(new Double(this.getTotal()));
        rowData.add(new Double(this.getStdDev()));
        rowData.add(new Double(this.getLastValue()));
        rowData.add(new Double(this.getMin()));
        rowData.add(new Double(this.getMax()));
        rowData.add(new Double(this.getActive()));
        rowData.add(new Double(this.getAvgActive()));
        rowData.add(new Double(this.getMaxActive()));
        rowData.add(this.getFirstAccess());
        rowData.add(this.getLastAccess());
        rowData.add(new Boolean(this.isEnabled()));
        rowData.add(new Boolean(this.isPrimary()));
        rowData.add(new Boolean(this.hasListeners()));
        return rowData;
    }

    public List getRowData(List rowData) {
        this.monData.key.getRowData(rowData);
        this.getThisRowData(rowData);
        if (this.monData.range != null) {
            this.monData.range.getRowData(rowData);
        }
        return rowData;
    }

    public List getRowDisplayData(List rowData) {
        this.monData.key.getRowDisplayData(rowData);
        this.getThisRowData(rowData);
        if (this.monData.range != null) {
            this.monData.range.getRowDisplayData(rowData);
        }
        return rowData;
    }

    public RangeHolder getRangeHolder() {
        RangeImp r = (RangeImp)this.getRange();
        if (r != null) {
            return r.getRangeHolder();
        }
        return null;
    }

    void setActivityStats(ActivityStats activityStats) {
        this.monData.activityStats = activityStats;
    }

    private static class NullMonKey
    implements MonKey {
        private NullMonKey() {
        }

        public Object getDetails() {
            return "";
        }

        public String getRangeKey() {
            return "";
        }

        public Object getValue(String primaryKey) {
            return "";
        }

        public List getBasicHeader(List header) {
            return header;
        }

        public List getBasicRowData(List rowData) {
            return rowData;
        }

        public List getDisplayHeader(List header) {
            return header;
        }

        public List getHeader(List header) {
            return header;
        }

        public List getRowData(List rowData) {
            return rowData;
        }

        public List getRowDisplayData(List rowData) {
            return rowData;
        }

        public void setDetails(Object details) {
        }
    }
}

