/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import org.jruby.RubyNumeric;
import org.jruby.util.ByteList;

public class Convert {
    private static final long[] LONG_10_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L};
    private static final BigInteger BIG_INT_ZERO = BigInteger.valueOf(0L);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] MIN_INT_BYTE_ARRAY = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    private static final byte[] MIN_LONG_BYTE_ARRAY = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    private static final char[] MIN_LONG_CHAR_ARRAY = new char[]{'-', '9', '2', '2', '3', '3', '7', '2', '0', '3', '6', '8', '5', '4', '7', '7', '5', '8', '0', '8'};
    private static final int[] SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] UCDIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final char[] CDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] CDIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] CDIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final double[] SMALL_10_POWERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final int MAX_SMALL_10 = SMALL_10_POWERS.length - 1;
    private static final int MAX_DECIMAL_DIGITS = 15;

    public static final ByteList intToByteList(int i) {
        if (i == Integer.MIN_VALUE) {
            return new ByteList((byte[])MIN_INT_BYTE_ARRAY.clone(), false);
        }
        int size = i < 0 ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return new ByteList(buf, false);
    }

    public static final byte[] intToByteArray(int i) {
        if (i == Integer.MIN_VALUE) {
            return (byte[])MIN_INT_BYTE_ARRAY.clone();
        }
        int size = i < 0 ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return buf;
    }

    public static final ByteList intToByteList(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Convert.intToByteList(i);
        }
        byte[] buf = new byte[33];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            buf[charPos--] = DIGITS[-(i % radix)];
            i /= radix;
        }
        buf[charPos] = DIGITS[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new ByteList(buf, charPos, 33 - charPos);
    }

    public static final byte[] intToByteArray(int i, int radix, boolean upper) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Convert.intToByteArray(i);
        }
        byte[] buf = new byte[33];
        byte[] digits = upper ? UCDIGITS : DIGITS;
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            buf[charPos--] = digits[-(i % radix)];
            i /= radix;
        }
        buf[charPos] = digits[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        int len = 33 - charPos;
        byte[] out = new byte[len];
        System.arraycopy(buf, charPos, out, 0, len);
        return out;
    }

    public static final ByteList longToByteList(long i) {
        if (i == Long.MIN_VALUE) {
            return new ByteList((byte[])MIN_LONG_BYTE_ARRAY.clone(), false);
        }
        if (i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
            return Convert.intToByteList((int)i);
        }
        int size = i < 0L ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return new ByteList(buf, false);
    }

    public static final byte[] longToByteArray(long i) {
        if (i == Long.MIN_VALUE) {
            return (byte[])MIN_LONG_BYTE_ARRAY.clone();
        }
        if (i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
            return Convert.intToByteArray((int)i);
        }
        int size = i < 0L ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return buf;
    }

    public static final ByteList longToByteList(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Convert.longToByteList(i);
        }
        byte[] buf = new byte[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = DIGITS[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new ByteList(buf, charPos, 65 - charPos);
    }

    public static final byte[] longToByteArray(long i, int radix, boolean upper) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Convert.longToByteArray(i);
        }
        byte[] buf = new byte[65];
        byte[] digits = upper ? UCDIGITS : DIGITS;
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = digits[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        int len = 65 - charPos;
        byte[] out = new byte[len];
        System.arraycopy(buf, charPos, out, 0, len);
        return out;
    }

    public static final byte[] intToCharBytes(int i) {
        if (i == Integer.MIN_VALUE) {
            return (byte[])MIN_INT_BYTE_ARRAY.clone();
        }
        int size = i < 0 ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return buf;
    }

    public static final byte[] longToCharBytes(long i) {
        if (i == Long.MIN_VALUE) {
            return (byte[])MIN_LONG_BYTE_ARRAY.clone();
        }
        int size = i < 0L ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        byte[] buf = new byte[size];
        Convert.getCharBytes(i, size, buf);
        return buf;
    }

    public static final char[] longToChars(long i) {
        if (i == Long.MIN_VALUE) {
            return (char[])MIN_LONG_CHAR_ARRAY.clone();
        }
        int size = i < 0L ? Convert.arraySize(-i) + 1 : Convert.arraySize(i);
        char[] buf = new char[size];
        Convert.getChars(i, size, buf);
        return buf;
    }

    public static final void getCharBytes(int i, int index, byte[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = DIGITS[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static final void getCharBytes(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = DIGITS[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static final void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = CDIGIT_ONES[r];
            buf[--charPos] = CDIGIT_TENS[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = CDIGIT_ONES[r];
            buf[--charPos] = CDIGIT_TENS[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = CDIGITS[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static final int arraySize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static final int arraySize(int x) {
        int i = 0;
        while (x > SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static final byte[] intToBinaryBytes(int i) {
        return Convert.intToUnsignedBytes(i, 1, false);
    }

    public static final byte[] intToOctalBytes(int i) {
        return Convert.intToUnsignedBytes(i, 3, false);
    }

    public static final byte[] intToHexBytes(int i) {
        return Convert.intToUnsignedBytes(i, 4, false);
    }

    public static final byte[] intToHexBytes(int i, boolean upper) {
        return Convert.intToUnsignedBytes(i, 4, upper);
    }

    public static final ByteList intToBinaryByteList(int i) {
        return new ByteList(Convert.intToUnsignedBytes(i, 1, false));
    }

    public static final ByteList intToOctalByteList(int i) {
        return new ByteList(Convert.intToUnsignedBytes(i, 3, false));
    }

    public static final ByteList intToHexByteList(int i) {
        return new ByteList(Convert.intToUnsignedBytes(i, 4, false));
    }

    public static final ByteList intToHexByteList(int i, boolean upper) {
        return new ByteList(Convert.intToUnsignedBytes(i, 4, upper));
    }

    public static final byte[] longToBinaryBytes(long i) {
        return Convert.longToUnsignedBytes(i, 1, false);
    }

    public static final byte[] longToOctalBytes(long i) {
        return Convert.longToUnsignedBytes(i, 3, false);
    }

    public static final byte[] longToHexBytes(long i) {
        return Convert.longToUnsignedBytes(i, 4, false);
    }

    public static final byte[] longToHexBytes(long i, boolean upper) {
        return Convert.longToUnsignedBytes(i, 4, true);
    }

    public static final ByteList longToBinaryByteList(long i) {
        return new ByteList(Convert.longToUnsignedBytes(i, 1, false));
    }

    public static final ByteList longToOctalByteList(long i) {
        return new ByteList(Convert.longToUnsignedBytes(i, 3, false));
    }

    public static final ByteList longToHexByteList(long i) {
        return new ByteList(Convert.longToUnsignedBytes(i, 4, false));
    }

    public static final ByteList longToHexByteList(long i, boolean upper) {
        return new ByteList(Convert.longToUnsignedBytes(i, 4, upper));
    }

    public static final byte[] intToRawUnsignedBytes(int i, int shift) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[i & mask];
        } while ((i >>>= shift) != 0);
        return buf;
    }

    public static final byte[] intToUnsignedBytes(int i, int shift, boolean upper) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 1 << shift;
        int mask = radix - 1;
        byte[] digits = upper ? UCDIGITS : DIGITS;
        do {
            buf[--charPos] = digits[i & mask];
        } while ((i >>>= shift) != 0);
        int length = 32 - charPos;
        byte[] result = new byte[length];
        System.arraycopy(buf, charPos, result, 0, length);
        return result;
    }

    public static final byte[] longToRawUnsignedBytes(long i, int shift) {
        byte[] buf = new byte[64];
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        return buf;
    }

    public static final byte[] longToUnsignedBytes(long i, int shift, boolean upper) {
        byte[] buf = new byte[64];
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        byte[] digits = upper ? UCDIGITS : DIGITS;
        do {
            buf[--charPos] = digits[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int length = 64 - charPos;
        byte[] result = new byte[length];
        System.arraycopy(buf, charPos, result, 0, length);
        return result;
    }

    public static final long byteListToLong(ByteList bytes, int base, boolean raise) {
        return Convert.byteArrayToLong(bytes.unsafeBytes(), bytes.begin(), bytes.length(), base, raise);
    }

    public static final long byteListToLong(ByteList bytes, int base) {
        return Convert.byteArrayToLong(bytes.unsafeBytes(), bytes.begin(), bytes.length(), base, false);
    }

    public static final long byteListToLong(ByteList bytes) {
        return Convert.byteArrayToLong(bytes.unsafeBytes(), bytes.begin(), bytes.length(), 10, false);
    }

    public static final BigInteger byteListToBigInteger(ByteList bytes, int base, boolean raise) {
        return Convert.byteArrayToBigInteger(bytes.unsafeBytes(), bytes.begin(), bytes.length(), base, raise);
    }

    public static final BigInteger byteListToBigInteger(ByteList bytes, int base) {
        return Convert.byteArrayToBigInteger(bytes.unsafeBytes(), bytes.begin(), bytes.length(), base, false);
    }

    public static final BigInteger byteListToBigInteger(ByteList bytes) {
        return Convert.byteArrayToBigInteger(bytes.unsafeBytes(), bytes.begin(), bytes.length(), 10, false);
    }

    public static final long byteArrayToLong(byte[] bytes, int begin, int buflen, int base, boolean strict) {
        int radix;
        boolean SCOMPLETE = false;
        boolean SBEGIN = true;
        int SSIGN = 2;
        int SZERO = 3;
        int SPOST_SIGN = 4;
        int SDIGITS = 5;
        int SDIGIT = 6;
        int SDIGIT_STRICT = 7;
        int SDIGIT_USC = 8;
        int SEOD_STRICT = 13;
        int SEOF = 14;
        int SERR_NOT_STRICT = 17;
        int SERR_TOO_BIG = 18;
        boolean FLAG_NEGATIVE = true;
        int FLAG_DIGIT = 2;
        int FLAG_UNDERSCORE = 4;
        int FLAG_WHITESPACE = 8;
        if (bytes == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (buflen < 0 || buflen > bytes.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        int n = radix = base == 0 ? 10 : base;
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("illegal radix " + radix);
        }
        if (buflen == 0) {
            throw new RubyNumeric.InvalidIntegerException();
        }
        int i = begin;
        buflen += begin;
        int flags = 0;
        long limit = -9223372036854775807L;
        long result = 0L;
        long multmin = 0L;
        int state = 1;
        while (state != 0) {
            block0 : switch (state) {
                case 1: {
                    byte ival;
                    if (strict) {
                        while (i < buflen && bytes[i] <= 32) {
                            ++i;
                        }
                    } else {
                        while (i < buflen && ((ival = bytes[i]) <= 32 || ival == 95)) {
                            ++i;
                        }
                    }
                    state = i < buflen ? 2 : 14;
                    break;
                }
                case 2: {
                    switch (bytes[i]) {
                        case 45: {
                            flags |= 1;
                            limit = Long.MIN_VALUE;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = 14;
                                break;
                            }
                            if (bytes[i] == 48) {
                                state = 3;
                                break;
                            }
                            state = 4;
                            break;
                        }
                        case 48: {
                            state = 3;
                            break;
                        }
                        default: {
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (++i >= buflen) {
                        state = 0;
                        break;
                    }
                    switch (bytes[i]) {
                        case 88: 
                        case 120: {
                            if (base == 0 || base == 16) {
                                radix = 16;
                                state = ++i >= buflen ? 14 : 4;
                                break;
                            }
                            state = 5;
                            break;
                        }
                        case 66: 
                        case 98: {
                            if (base == 0 || base == 2) {
                                radix = 2;
                                state = ++i >= buflen ? 14 : 4;
                                break;
                            }
                            state = 5;
                            break;
                        }
                        default: {
                            if (base == 0 || base == 8) {
                                radix = 8;
                            }
                            flags |= 2;
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    byte ival;
                    if (strict) {
                        int ibefore = i;
                        while (i < buflen && bytes[i] <= 32) {
                            ++i;
                        }
                        if (ibefore != i) {
                            flags |= 8;
                        }
                    } else {
                        while (i < buflen && ((ival = bytes[i]) <= 32 || ival == 95)) {
                            if (ival == 95) {
                                if ((flags & 8) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                flags |= 4;
                            } else {
                                if ((flags & 4) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                flags |= 8;
                            }
                            ++i;
                        }
                    }
                    state = i < buflen ? 5 : 14;
                    break;
                }
                case 5: {
                    int digit = Character.digit((char)bytes[i], radix);
                    if (digit < 0) {
                        state = strict ? 13 : 14;
                        break;
                    }
                    result = -digit;
                    if (++i >= buflen) {
                        state = 0;
                        break;
                    }
                    multmin = limit / (long)radix;
                    flags = (flags | 2) & 0xFFFFFFFB;
                    state = strict ? 7 : 6;
                    break;
                }
                case 6: {
                    int digit;
                    while ((digit = Character.digit((char)bytes[i], radix)) >= 0) {
                        if (result < multmin || (result *= (long)radix) < limit + (long)digit) {
                            state = 18;
                            break block0;
                        }
                        result -= (long)digit;
                        if (++i < buflen) continue;
                        state = 0;
                        break block0;
                    }
                    state = bytes[i++] == 95 ? 8 : 14;
                    break;
                }
                case 8: {
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    state = i < buflen ? 6 : 14;
                    break;
                }
                case 7: {
                    int digit;
                    while ((digit = Character.digit((char)bytes[i], radix)) >= 0) {
                        if (result < multmin || (result *= (long)radix) < limit + (long)digit) {
                            state = 18;
                            break block0;
                        }
                        result -= (long)digit;
                        if (++i >= buflen) {
                            state = 0;
                            break block0;
                        }
                        flags &= 0xFFFFFFFB;
                    }
                    if (bytes[i] == 95) {
                        if ((flags & 0xC) != 0) {
                            state = 17;
                            break;
                        }
                        flags |= 4;
                        state = ++i >= buflen ? 13 : 7;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 13: {
                    if ((flags & 4) != 0) {
                        state = 17;
                        break;
                    }
                    while (i < buflen && bytes[i] <= 32) {
                        ++i;
                    }
                    state = i < buflen ? 17 : 0;
                    break;
                }
                case 14: {
                    if ((flags & 2) == 0) {
                        throw new RubyNumeric.InvalidIntegerException("no digits supplied");
                    }
                    state = 0;
                    break;
                }
                case 18: {
                    throw new RubyNumeric.NumberTooLargeException("can't convert to long");
                }
                case 17: {
                    throw new RubyNumeric.InvalidIntegerException("does not meet strict criteria");
                }
            }
        }
        if (!(flags & true)) {
            return -result;
        }
        return result;
    }

    public static final BigInteger byteArrayToBigInteger(byte[] bytes, int begin, int buflen, int base, boolean strict) {
        int radix;
        boolean SCOMPLETE = false;
        boolean SBEGIN = true;
        int SSIGN = 2;
        int SZERO = 3;
        int SPOST_SIGN = 4;
        int SDIGITS = 5;
        int SDIGIT = 6;
        int SDIGIT_STRICT = 7;
        int SDIGIT_USC = 8;
        int SEOD_STRICT = 13;
        int SEOF = 14;
        int SERR_NOT_STRICT = 17;
        boolean FLAG_NEGATIVE = true;
        int FLAG_DIGIT = 2;
        int FLAG_UNDERSCORE = 4;
        int FLAG_WHITESPACE = 8;
        if (bytes == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (buflen < 0 || buflen > bytes.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        int n = radix = base == 0 ? 10 : base;
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("illegal radix " + radix);
        }
        if (buflen == 0) {
            throw new RubyNumeric.InvalidIntegerException();
        }
        int i = begin;
        buflen += begin;
        int flags = 0;
        int offset = 0;
        char[] chars = null;
        int state = 1;
        while (state != 0) {
            block0 : switch (state) {
                case 1: {
                    byte ival;
                    if (strict) {
                        while (i < buflen && bytes[i] <= 32) {
                            ++i;
                        }
                    } else {
                        while (i < buflen && ((ival = bytes[i]) <= 32 || ival == 95)) {
                            ++i;
                        }
                    }
                    state = i < buflen ? 2 : 14;
                    break;
                }
                case 2: {
                    switch (bytes[i]) {
                        case 45: {
                            flags |= 1;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = 14;
                                break;
                            }
                            if (bytes[i] == 48) {
                                state = 3;
                                break;
                            }
                            state = 4;
                            break;
                        }
                        case 48: {
                            state = 3;
                            break;
                        }
                        default: {
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (++i >= buflen) {
                        state = 0;
                        break;
                    }
                    switch (bytes[i]) {
                        case 88: 
                        case 120: {
                            if (base == 0 || base == 16) {
                                radix = 16;
                                state = ++i >= buflen ? 14 : 4;
                                break;
                            }
                            state = 5;
                            break;
                        }
                        case 66: 
                        case 98: {
                            if (base == 0 || base == 2) {
                                radix = 2;
                                state = ++i >= buflen ? 14 : 4;
                                break;
                            }
                            state = 5;
                            break;
                        }
                        default: {
                            if (base == 0 || base == 8) {
                                radix = 8;
                            }
                            flags |= 2;
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    byte ival;
                    if (strict) {
                        int ibefore = i;
                        while (i < buflen && bytes[i] <= 32) {
                            ++i;
                        }
                        if (ibefore != i) {
                            flags |= 8;
                        }
                    } else {
                        while (i < buflen && ((ival = bytes[i]) <= 32 || ival == 95)) {
                            if (ival == 95) {
                                if ((flags & 8) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                flags |= 4;
                            } else {
                                if ((flags & 4) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                flags |= 8;
                            }
                            ++i;
                        }
                    }
                    state = i < buflen ? 5 : 14;
                    break;
                }
                case 5: {
                    int digit = Character.digit((char)bytes[i], radix);
                    if (digit < 0) {
                        state = strict ? 13 : 14;
                        break;
                    }
                    if ((flags & 1) == 0) {
                        chars = new char[buflen - i];
                        chars[0] = (char)bytes[i];
                        offset = 1;
                    } else {
                        chars = new char[buflen - i + 1];
                        chars[0] = 45;
                        chars[1] = (char)bytes[i];
                        offset = 2;
                    }
                    if (++i >= buflen) {
                        state = 0;
                        break;
                    }
                    flags = (flags | 2) & 0xFFFFFFFB;
                    state = strict ? 7 : 6;
                    break;
                }
                case 6: {
                    int digit;
                    while ((digit = Character.digit((char)bytes[i], radix)) >= 0) {
                        chars[offset++] = (char)bytes[i];
                        if (++i < buflen) continue;
                        state = 0;
                        break block0;
                    }
                    state = bytes[i++] == 95 ? 8 : 14;
                    break;
                }
                case 8: {
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    state = i < buflen ? 6 : 14;
                    break;
                }
                case 7: {
                    int digit;
                    while ((digit = Character.digit((char)bytes[i], radix)) >= 0) {
                        chars[offset++] = (char)bytes[i];
                        if (++i >= buflen) {
                            state = 0;
                            break block0;
                        }
                        flags &= 0xFFFFFFFB;
                    }
                    if (bytes[i] == 95) {
                        if ((flags & 0xC) != 0) {
                            state = 17;
                            break;
                        }
                        flags |= 4;
                        state = ++i >= buflen ? 13 : 7;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 13: {
                    if ((flags & 4) != 0) {
                        state = 17;
                        break;
                    }
                    while (i < buflen && bytes[i] <= 32) {
                        ++i;
                    }
                    state = i < buflen ? 17 : 0;
                    break;
                }
                case 14: {
                    if ((flags & 2) == 0) {
                        throw new RubyNumeric.InvalidIntegerException("no digits supplied");
                    }
                    state = 0;
                    break;
                }
                case 17: {
                    throw new RubyNumeric.InvalidIntegerException("does not meet strict criteria");
                }
            }
        }
        if (chars == null) {
            return BIG_INT_ZERO;
        }
        return new BigInteger(new String(chars, 0, offset), radix);
    }

    public static final double byteListToDouble(ByteList bytes, boolean strict) {
        return Convert.byteArrayToDouble(bytes.unsafeBytes(), bytes.begin(), bytes.length(), strict);
    }

    public static final double byteListToDouble(ByteList bytes) {
        return Convert.byteArrayToDouble(bytes.unsafeBytes(), bytes.begin(), bytes.length(), false);
    }

    /*
     * Unable to fully structure code
     */
    public static final double byteArrayToDouble(byte[] bytes, int begin, int buflen, boolean strict) {
        SCOMPLETE = false;
        SBEGIN = true;
        SSIGN = 2;
        SOPTDIGIT = 3;
        SOPTDECDIGIT = 4;
        SOPTEXP = 9;
        SOPTDIGIT_STRICT = 6;
        SOPTDECDIGIT_STRICT = 7;
        SOPTEXP_STRICT = 8;
        SOPTCALC = 5;
        SDIGIT = 10;
        SDECDIGIT = 11;
        SEXP = 12;
        SDIGIT_STRICT = 13;
        SDECDIGIT_STRICT = 14;
        SEXP_STRICT = 15;
        SERR_NOT_STRICT = 16;
        MAX_EXP = 15 + Convert.MAX_SMALL_10;
        if (bytes == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (buflen < 0 || buflen > bytes.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        if (buflen == 0) {
            throw new NumberFormatException();
        }
        i = begin;
        buflen += begin;
        ival = -1;
        negative = false;
        nDigits = 0;
        nTrailingZeroes = 0;
        decPos = -1;
        significand = 0L;
        exponent = 0;
        startPos = 0;
        chars = null;
        offset = 0;
        lastValidOffset = 0;
        state = 1;
        while (state != 0) {
            block0 : switch (state) {
                case 1: {
                    if (strict) {
                        while (i < buflen && bytes[i] <= 32) {
                            ++i;
                        }
                    } else {
                        while (i < buflen && ((ival = bytes[i]) <= 32 || ival == 95)) {
                            ++i;
                        }
                    }
                    if (i >= buflen) {
                        state = strict != false ? 16 : 0;
                        break;
                    }
                }
                case 2: {
                    switch (bytes[i]) {
                        case 45: {
                            negative = true;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = strict != false ? 16 : 0;
                                break;
                            }
                        }
                        default: {
                            startPos = i;
                            if (strict) {
                                state = 6;
                                break;
                            }
                            ** GOTO lbl68
                        }
                    }
                    break;
                }
lbl68:
                // 2 sources

                case 3: {
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            significand = ival - 48;
                            nDigits = 1;
                            break;
                        }
                        case 46: {
                            state = 4;
                            break block0;
                        }
                        default: {
                            state = 5;
                            break block0;
                        }
                    }
                    block143: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits <= 0) continue block143;
                                ++nTrailingZeroes;
                                continue block143;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block143;
                                }
                                state = 10;
                                break;
                            }
                            case 46: {
                                state = 4;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 9;
                                break;
                            }
                            case 95: {
                                continue block143;
                            }
                            default: {
                                state = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 4: {
                    decPos = nDigits + nTrailingZeroes;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    break;
                                }
                                --exponent;
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    break;
                                }
                                state = 10;
                                break block0;
                            }
                            default: {
                                state = 5;
                                break block0;
                            }
                        }
                    }
                    block145: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    continue block145;
                                }
                                --exponent;
                                continue block145;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block145;
                                }
                                state = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 9;
                                break;
                            }
                            case 95: {
                                continue block145;
                            }
                            default: {
                                state = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                }
                case 5: {
                    if (!(nDigits != 0 || i + 1 >= buflen || ival != 110 && ival != 78 || bytes[i] != 97 && bytes[i] != 65 || bytes[i + 1] != 110 && bytes[i + 1] != 78)) {
                        return NaN;
                    }
                    if (!(nDigits != 0 || i + 1 >= buflen || ival != 105 && ival != 73 || bytes[i] != 110 && bytes[i] != 78 || bytes[i + 1] != 102 && bytes[i + 1] != 70)) {
                        return negative != false ? -Infinity : Infinity;
                    }
                    if (nDigits == 0) {
                        return negative != false ? -0.0 : 0.0;
                    }
                    exponent = decPos < 0 ? (exponent += nTrailingZeroes) : (exponent += decPos - nDigits);
                    dValue = significand;
                    if (exponent == 0 || dValue == 0.0) {
                        return negative != false ? -dValue : dValue;
                    }
                    if (exponent >= 0) {
                        if (exponent <= Convert.MAX_SMALL_10) {
                            return negative != false ? -dValue : (dValue *= Convert.SMALL_10_POWERS[exponent]);
                        }
                        slop = 15 - nDigits;
                        if (exponent <= Convert.MAX_SMALL_10 + slop) {
                            dValue = dValue * Convert.SMALL_10_POWERS[slop] * Convert.SMALL_10_POWERS[exponent - slop];
                            return negative != false ? -dValue : dValue;
                        }
                    } else if (exponent >= -Convert.MAX_SMALL_10) {
                        return negative != false ? -dValue : (dValue /= Convert.SMALL_10_POWERS[-exponent]);
                    }
                    state = 10;
                    break;
                }
                case 9: {
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i >= buflen) {
                        state = 5;
                        break;
                    }
                    expSign = 1;
                    expSpec = 0;
                    block44 : switch (bytes[i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = 5;
                                break;
                            }
                        }
                        default: {
                            block147: while (i < buflen) {
                                ival = bytes[i++];
                                switch (ival) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        if ((expSpec = expSpec * 10 + (ival - 48)) < MAX_EXP) continue block147;
                                        state = 10;
                                        break block44;
                                    }
                                    case 95: {
                                        continue block147;
                                    }
                                }
                                exponent += expSign * expSpec;
                                state = 5;
                                break block44;
                            }
                            exponent += expSign * expSpec;
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            significand = ival - 48;
                            nDigits = 1;
                            break;
                        }
                        case 46: {
                            state = 7;
                            break block0;
                        }
                        default: {
                            state = 16;
                            break block0;
                        }
                    }
                    block148: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits <= 0) continue block148;
                                ++nTrailingZeroes;
                                continue block148;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block148;
                                }
                                state = 10;
                                break;
                            }
                            case 46: {
                                state = 7;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 8;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block148;
                                state = 16;
                                break;
                            }
                            default: {
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 7: {
                    decPos = nDigits + nTrailingZeroes;
                    if (i >= buflen) ** GOTO lbl296
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            if (nDigits > 0) {
                                ++nTrailingZeroes;
                            } else {
                                --exponent;
                            }
                            ** GOTO lbl298
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                nTrailingZeroes = 0;
                            }
                            if (nDigits++ >= 15) ** GOTO lbl290
                            significand = significand * 10L + (long)(ival - 48);
                            ** GOTO lbl298
lbl290:
                            // 1 sources

                            state = 10;
                            break;
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl296:
                    // 1 sources

                    state = 16;
                    break;
lbl298:
                    // 7 sources

                    block150: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    continue block150;
                                }
                                --exponent;
                                continue block150;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= Convert.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block150;
                                }
                                state = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 8;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block150;
                                state = 16;
                                break;
                            }
                            default: {
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 8: {
                    expSign = 1;
                    expSpec = 0;
                    if (i < buflen) {
                        switch (bytes[i]) {
                            case 45: {
                                expSign = -1;
                            }
                            case 43: {
                                if (++i >= buflen) {
                                    state = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        state = 16;
                        break;
                    }
                    if (i >= buflen) ** GOTO lbl356
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            expSpec = ival - 48;
                            ** GOTO lbl358
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl356:
                    // 1 sources

                    state = 16;
                    break;
lbl358:
                    // 3 sources

                    block152: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if ((expSpec = expSpec * 10 + (ival - 48)) < MAX_EXP) continue block152;
                                state = 10;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block152;
                                state = 16;
                                break;
                            }
                            default: {
                                exponent += expSign * expSpec;
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    exponent += expSign * expSpec;
                    state = 5;
                    break;
                }
                case 10: {
                    i = startPos;
                    if (negative) {
                        chars = new char[buflen - i + 1];
                        chars[0] = 45;
                        offset = 1;
                    } else {
                        chars = new char[buflen - i];
                    }
                    if (strict) {
                        state = 13;
                        break;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                break;
                            }
                            case 46: {
                                state = 11;
                                break block0;
                            }
                            default: {
                                state = 0;
                                break block0;
                            }
                        }
                    }
                    block154: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block154;
                            }
                            case 46: {
                                state = 11;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 12;
                                break;
                            }
                            case 95: {
                                continue block154;
                            }
                            default: {
                                state = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 11: {
                    chars[offset++] = 46;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                break;
                            }
                            default: {
                                state = 0;
                                break block0;
                            }
                        }
                    }
                    block156: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block156;
                            }
                            case 69: 
                            case 101: {
                                state = 12;
                                break;
                            }
                            case 95: {
                                continue block156;
                            }
                            default: {
                                state = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    chars[offset++] = 69;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i >= buflen) {
                        state = 0;
                        break;
                    }
                    block104 : switch (bytes[i]) {
                        case 43: 
                        case 45: {
                            chars[offset++] = (char)bytes[i];
                            if (++i >= buflen) {
                                state = 0;
                                break;
                            }
                        }
                        default: {
                            block158: while (i < buflen) {
                                ival = bytes[i++];
                                switch (ival) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        chars[offset++] = (char)ival;
                                        lastValidOffset = offset;
                                        continue block158;
                                    }
                                    case 95: {
                                        continue block158;
                                    }
                                }
                                state = 0;
                                break block104;
                            }
                            state = 0;
                            break;
                        }
                    }
                    break;
                }
                case 13: {
                    if (i >= buflen) ** GOTO lbl506
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            ** GOTO lbl508
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl508
                        }
                        case 46: {
                            state = 14;
                            break;
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl506:
                    // 1 sources

                    state = 16;
                    break;
lbl508:
                    // 4 sources

                    block159: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block159;
                            }
                            case 46: {
                                state = 14;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 15;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block159;
                                state = 16;
                                break;
                            }
                            default: {
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 14: {
                    chars[offset++] = 46;
                    if (i >= buflen) ** GOTO lbl547
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl549
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl547:
                    // 1 sources

                    state = 16;
                    break;
lbl549:
                    // 3 sources

                    block161: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block161;
                            }
                            case 69: 
                            case 101: {
                                state = 15;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block161;
                                state = 16;
                                break;
                            }
                            default: {
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 15: {
                    chars[offset++] = 69;
                    if (i < buflen) {
                        switch (bytes[i]) {
                            case 43: 
                            case 45: {
                                chars[offset++] = (char)bytes[i];
                                if (++i >= buflen) {
                                    state = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        state = 16;
                        break;
                    }
                    if (i >= buflen) ** GOTO lbl595
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl597
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl595:
                    // 1 sources

                    state = 16;
                    break;
lbl597:
                    // 3 sources

                    block163: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block163;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block163;
                                state = 16;
                                break;
                            }
                            default: {
                                while (i < buflen && bytes[i] <= 32) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 16: {
                    throw new NumberFormatException("does not meet strict criteria");
                }
            }
        }
        if (chars == null || lastValidOffset == 0) {
            return 0.0;
        }
        return Double.parseDouble(new String(chars, 0, lastValidOffset));
    }

    public static final byte[] doubleToByteArray(double d) {
        return ByteList.plain(Double.toString(d));
    }

    public static final byte[] twosComplementToBinaryBytes(byte[] in) {
        return Convert.twosComplementToUnsignedBytes(in, 1, false);
    }

    public static final byte[] twosComplementToOctalBytes(byte[] in) {
        return Convert.twosComplementToUnsignedBytes(in, 3, false);
    }

    public static final byte[] twosComplementToHexBytes(byte[] in, boolean upper) {
        return Convert.twosComplementToUnsignedBytes(in, 4, upper);
    }

    public static final byte[] twosComplementToUnsignedBytes(byte[] in, int shift, boolean upper) {
        if (shift < 1 || shift > 4) {
            throw new IllegalArgumentException("shift value must be 1-4");
        }
        int ilen = in.length;
        int olen = (ilen * 8 + shift - 1) / shift;
        byte[] out = new byte[olen];
        int mask = (1 << shift) - 1;
        byte[] digits = upper ? UCDIGITS : DIGITS;
        int bitbuf = 0;
        int bitcnt = 0;
        int i = ilen;
        int o = olen;
        while (--o >= 0) {
            if (bitcnt < shift) {
                bitbuf |= (in[--i] & 0xFF) << bitcnt;
                bitcnt += 8;
            }
            out[o] = digits[bitbuf & mask];
            bitbuf >>= shift;
            bitcnt -= shift;
        }
        return out;
    }

    public static final int skipLeadingWhitespace(byte[] bytes) {
        int start;
        int length = bytes.length;
        for (start = 0; start < length && bytes[start] <= 32; ++start) {
        }
        return start;
    }

    public static final int skipTrailingWhitespace(byte[] bytes) {
        int stop;
        for (stop = bytes.length - 1; stop >= 0 && bytes[stop] <= 32; --stop) {
        }
        return stop + 1;
    }

    public static final byte[] trim(byte[] bytes) {
        if (bytes.length == 0) {
            return bytes;
        }
        int start = Convert.skipLeadingWhitespace(bytes);
        if (start >= bytes.length) {
            return EMPTY_BYTES;
        }
        int stop = Convert.skipTrailingWhitespace(bytes);
        int length = stop - start;
        if (length == bytes.length) {
            return bytes;
        }
        byte[] trimmed = new byte[length];
        System.arraycopy(bytes, 0, trimmed, 0, length);
        return trimmed;
    }

    public static final byte[] delete(byte[] bytes, int pos, boolean copy) {
        int buflen = bytes.length;
        int newlen = buflen - 1;
        if (pos < 0 || pos > newlen) {
            throw new IllegalArgumentException("illegal position for delete");
        }
        int src = pos + 1;
        if (copy) {
            if (newlen == 0) {
                return EMPTY_BYTES;
            }
            byte[] newbytes = new byte[newlen];
            if (pos == 0) {
                System.arraycopy(bytes, 1, newbytes, 0, newlen);
            } else {
                System.arraycopy(bytes, 0, newbytes, 0, pos);
                System.arraycopy(bytes, src, newbytes, pos, newlen - pos);
            }
            return newbytes;
        }
        if (newlen > 0) {
            System.arraycopy(bytes, src, bytes, pos, buflen - src);
            bytes[newlen] = 0;
        } else {
            bytes[newlen - 1] = 0;
        }
        return bytes;
    }

    public static final byte[] delete(byte[] bytes, int pos, int length, boolean copy) {
        if (length < 0) {
            throw new IllegalArgumentException("illegal length for delete");
        }
        int buflen = bytes.length;
        if (length == 0 || buflen == 0) {
            return bytes;
        }
        int newlen = buflen - length;
        int newpos = pos + length;
        if (pos < 0 || newpos > buflen) {
            throw new IllegalArgumentException("illegal position for delete");
        }
        if (copy) {
            if (newlen == 0) {
                return EMPTY_BYTES;
            }
            byte[] newbytes = new byte[newlen];
            if (pos == 0) {
                System.arraycopy(bytes, length, newbytes, 0, newlen);
            } else if (pos == newlen) {
                System.arraycopy(bytes, 0, newbytes, 0, newlen);
            } else {
                System.arraycopy(bytes, 0, newbytes, 0, pos);
                System.arraycopy(bytes, newpos, newbytes, pos, buflen - newpos);
            }
            return newbytes;
        }
        if (newlen > 0) {
            System.arraycopy(bytes, newpos, bytes, pos, buflen - newpos);
        }
        Convert.fill(bytes, newlen, buflen - newlen, (byte)0);
        return bytes;
    }

    public static final byte[] insert(byte[] bytes, int pos, byte value, boolean copy) {
        int buflen = bytes.length;
        if (pos < 0 || pos > buflen) {
            throw new IllegalArgumentException("illegal position for insert");
        }
        if (copy) {
            byte[] newbytes = new byte[buflen + 1];
            if (pos == 0) {
                System.arraycopy(bytes, 0, newbytes, 1, buflen);
                newbytes[0] = value;
            } else if (pos == buflen) {
                System.arraycopy(bytes, 0, newbytes, 0, buflen);
                newbytes[buflen] = value;
            } else {
                System.arraycopy(bytes, 0, newbytes, 0, pos);
                System.arraycopy(bytes, pos, newbytes, pos + 1, buflen - pos);
                newbytes[pos] = value;
            }
            return newbytes;
        }
        if (pos == buflen) {
            throw new IllegalArgumentException("illegal position for insert with no copy");
        }
        if (pos > buflen - 1) {
            System.arraycopy(bytes, pos, bytes, pos + 1, buflen - pos - 1);
        }
        bytes[pos] = value;
        return bytes;
    }

    public static final byte[] insert(byte[] bytes, int pos, byte[] value, boolean copy) {
        int buflen = bytes.length;
        if (pos < 0 || pos > buflen) {
            throw new IllegalArgumentException("illegal position for insert");
        }
        int vlen = value.length;
        if (copy) {
            int newlen = buflen + vlen;
            byte[] newbytes = new byte[newlen];
            if (pos == 0) {
                System.arraycopy(value, 0, newbytes, 0, vlen);
                System.arraycopy(bytes, 0, newbytes, vlen, buflen);
            } else if (pos == buflen) {
                System.arraycopy(bytes, 0, newbytes, 0, buflen);
                System.arraycopy(value, 0, newbytes, buflen, vlen);
            } else {
                System.arraycopy(bytes, 0, newbytes, 0, pos);
                System.arraycopy(value, 0, newbytes, pos, vlen);
                System.arraycopy(bytes, pos, newbytes, pos + vlen, buflen - pos);
            }
            return newbytes;
        }
        int displace = pos + vlen;
        if (displace > buflen) {
            throw new IllegalArgumentException("inserted array won't fit in target array");
        }
        if (pos == 0) {
            System.arraycopy(bytes, 0, bytes, vlen, buflen - vlen);
            System.arraycopy(value, 0, bytes, 0, vlen);
        } else if (displace == buflen) {
            System.arraycopy(value, 0, bytes, pos, vlen);
        } else {
            System.arraycopy(bytes, pos, bytes, displace, buflen - displace);
            System.arraycopy(value, 0, bytes, pos, vlen);
        }
        return bytes;
    }

    public static final byte[] append(byte[] bytes, byte value) {
        int buflen = bytes.length;
        byte[] newbytes = new byte[buflen + 1];
        System.arraycopy(bytes, 0, newbytes, 0, buflen);
        bytes[buflen] = value;
        return bytes;
    }

    public static final byte[] fill(byte[] bytes, int pos, int length, byte value) {
        if (length < 0) {
            throw new IllegalArgumentException("illegal length for fill");
        }
        int stop = pos + length;
        int buflen = bytes.length;
        if (stop > buflen) {
            stop = buflen;
        }
        while (pos < stop) {
            bytes[pos] = value;
            ++pos;
        }
        return bytes;
    }

    public static final byte[] copy(byte[] bytes) {
        int buflen = bytes.length;
        if (buflen == 0) {
            return bytes;
        }
        byte[] newbytes = new byte[buflen];
        System.arraycopy(bytes, 0, newbytes, 0, buflen);
        return newbytes;
    }
}

