
/* Tests DTF creation and garbage collection of two tables for
different predicates. */

:- import abolish_table_pred/1, get_residual/2 from tables.

:- table tpred/1.
tpred(X):- p(X).

:- table upred/1.
upred(X):- p(X).

p(f(1)).
p(f(2)).
p(f(3)).
p(g(1)).
p(g(2)).
p(g(3)).

%------------------
:- dynamic tr/1.
:- index(tr/1,trie).

test:- assert(tr(a)),assert(tr(b)),assert(tr(c)),fail.

test:- tpred(_X),fail.
test:-  tpred(X),tr(Y),
	abolish_table_pred(tpred/1),
	writeln((X,Y)),fail.

test:- upred(_X),fail.
test:-  upred(_X),tr(_Y),
	abolish_table_pred(upred/1),
	fail.

test:- get_residual(tpred(X),_),writeln(first(X)),fail.
test:- get_residual(upred(X),_),writeln(first(X)),fail.
test:- gc_tables(N),writeln(remaining(N)).
