
#ifndef _TCPPROXY_INCLUDED
#define	_TCPPROXY_INCLUDED


#include <stdarg.h>


#define	PROXYNAME		"tcpproxy"
#define PIDFILE                 "/var/run/tcpproxy.pid"
#define ERROR_LOG               "/tmp/tcpproxy-error.log"
#define MAX_PORT                80


typedef struct _port {
    unsigned int port;
    int		count;
    char	ip[40];
    int		sock;
    } port_t;


#define	PROXY_DEFAULT		0
#define	PROXY_SERVER		1
#define	PROXY_PROGRAM		2

#define	REDIR_NONE		0
#define	REDIR_ACCEPT		1
#define	REDIR_FORWARD		2
#define	REDIR_FORWARD_ONLY	3

#define	ERRMODE_NONE		0
#define	ERRMODE_KEEP		1
#define	ERRMODE_HANDLER		2

#define	ERR_EXITCODEMASK	15

#define	ERR_STDERR		0x000080

#define	ERR_ACCESS		0x000100
#define	ERR_CONNECT		0x000200
#define	ERR_TIMEOUT		0x000400
#define	ERR_SERVER		0x000800
#define	ERR_CLIENT		0x001000
#define	ERR_PROXY		0x002000
#define	ERR_INFO		0x004000
#define	ERR_OK			0x008000
#define	ERR_ANY			0xFFFFFF

/* #define	MAX_ARGS		32 */


typedef struct _config {
    char	interface[300];
    unsigned int port;
    
    unsigned int uid;
    unsigned int gid;
    char	logname[80];
    char	writefile[200];
    int		timeout;
    int		cleanenv;
    int		extendedinfo;
    int		redirmode;
    char	acp[200];
    char	ctp[200];
    char	name[80];

    string_t	acl;

    int		proxytype;
    char	server[200];	/* Pointer to program or server list. */

    struct {
	int	count, max;	/* Array of source IP numbers. */
	char	**srcip;

	char	interface[40];	/* Selected outgoing interface ... */
	unsigned int port;	/* ... and port. */
	} srcip;

    peer_t	sock;
    peer_t	client;
    peer_t	origdst;	/* Original server from redirect */
    peer_t	s;		/* Remote server */

    long	bytes_send;
    long	bytes_received;
    unsigned long started;

    struct _config *next;
    } proxy_t;


typedef struct {
    int		standalone;

    char	logname[200];

    proxy_t	*def;

    int		binds;
    port_t	*bindport;

    proxy_t	*first;
    proxy_t	*last;
    int		proxy_count;
    } config_t;


extern char *program;
extern int debug;
extern int onlynumbers;
extern char varname[40];

extern char statdir[200];
extern char sessiondir[200];


extern int geterrcode(char *name);
extern int printerror(int rc, char *type, char *format, ...);

extern int cleanenv(char **envp);
extern int setvar(char *prefix, char *var, char *value);
extern int setnumvar(char *prefix, char *var, unsigned long value);
extern int set_variables(proxy_t *proxy);
extern int run_acp(proxy_t *proxy);
extern int run_ctp(proxy_t *proxy);

extern proxy_t *new_configuration(config_t *config, proxy_t *def);
extern proxy_t *find_configuration(config_t *config, char *interface, unsigned int port);

extern int addsrcip(proxy_t *x, char *par);
extern int addsrc(proxy_t *x, char *par, char *filename, int lineno);

extern int set_redirmode(proxy_t *x, char *word, char *filename, int lineno);
extern int get_sessionmode(proxy_t *x, char *word, char *filename, int lineno);
extern int set_username(proxy_t *x, char *username, char *filename, int lineno);
extern int read_configuration(config_t *config, char *filename);

#endif

