-- PostGIS setup script for wfs 1.1 sf0 cite dataset
-- 
-- From OGC CITE: http://cite.opengeospatial.org/te2/wfs-1.1.0-r0/data/data-wfs-1.1.0.zip
-- With several modifications
--
-- NOTA: Datas are based on a PostGIS 2.0 dump.
--
SET client_encoding = 'UTF8';

delete from geometry_columns where f_table_name = 'PrimitiveGeoFeature' ;
delete from geometry_columns where f_table_name = 'AggregateGeoFeature' ;
delete from geometry_columns where f_table_name = 'EntitéGénérique' ;

drop table "PrimitiveGeoFeature";
create table "PrimitiveGeoFeature" ( description varchar, name varchar );

select addgeometrycolumn( 'public', 'PrimitiveGeoFeature', 'surfaceProperty', 4326, 'POLYGON', 2 );
select addgeometrycolumn( 'public', 'PrimitiveGeoFeature', 'pointProperty', 4326, 'POINT', 2 );
select addgeometrycolumn( 'public', 'PrimitiveGeoFeature', 'curveProperty', 4326, 'LINESTRING', 2 );

alter table "PrimitiveGeoFeature" add "intProperty" int8 not null;
alter table "PrimitiveGeoFeature" add "uriProperty" varchar;
alter table "PrimitiveGeoFeature" add measurand float not null;
alter table "PrimitiveGeoFeature" add "dateTimeProperty" timestamp with time zone;
alter table "PrimitiveGeoFeature" add "dateProperty" date;
alter table "PrimitiveGeoFeature" add "decimalProperty" float not null;
alter table "PrimitiveGeoFeature" add id varchar; 
alter table "PrimitiveGeoFeature" add primary key ( id );

drop table "AggregateGeoFeature";
create table "AggregateGeoFeature" ( description varchar, name varchar );

select addgeometrycolumn( 'public', 'AggregateGeoFeature', 'multiPointProperty', 4326, 'MULTIPOINT', 2 );
select addgeometrycolumn( 'public', 'AggregateGeoFeature', 'multiCurveProperty', 4326, 'MULTILINESTRING', 2 );
select addgeometrycolumn( 'public', 'AggregateGeoFeature', 'multiSurfaceProperty', 4326, 'MULTIPOLYGON', 2 );

alter table "AggregateGeoFeature" add "doubleProperty" float not null;
alter table "AggregateGeoFeature" add "intRangeProperty" varchar;
alter table "AggregateGeoFeature" add "strProperty" varchar not null;
alter table "AggregateGeoFeature" add "featureCode" varchar not null;
alter table "AggregateGeoFeature" add id varchar; 
alter table "AggregateGeoFeature" add primary key ( id );

drop table "EntitéGénérique";
create table "EntitéGénérique" ( description varchar, name varchar );

select addgeometrycolumn( 'public', 'EntitéGénérique', 'attribut.Géométrie', 4326, 'GEOMETRY', 2 );

alter table "EntitéGénérique" add "boolProperty" boolean not null;
alter table "EntitéGénérique" add "str4Property" varchar not null;
alter table "EntitéGénérique" add "featureRef" varchar;
alter table "EntitéGénérique" add id varchar; 
alter table "EntitéGénérique" add primary key ( id );
INSERT INTO "AggregateGeoFeature" VALUES ('description-f005', 'name-f005', '0104000020E61000000300000001010000005C8FC2F528DC3D4085EB51B81EB55140010100000014AE47E17A143F4048E17A14AE3751400101000000B81E85EB511840403D0AD7A370FD5140', NULL, NULL, 2012.78, NULL, '
      Ma quande lingues coalesce, li grammatica del resultant lingue es plu
      simplic e regulari quam ti del coalescent lingues. Li nov lingua franca
      va esser plu simplic e regulari quam li existent Europan lingues.
      ', 'BK030', '230090203010106029');
INSERT INTO "AggregateGeoFeature" VALUES ('description-f009', 'name-f009', NULL, '0105000020E6100000020000000102000000060000007F6ABC74939817C083C0CAA145964B4077BE9F1A2FDD15C0FA7E6ABC74D34B407F6ABC74939817C0355EBA490CF24B407F6ABC74939817C083C0CAA145164D4077BE9F1A2FDD15C0FA7E6ABC74534D407F6ABC74939817C0355EBA490C724D400102000000050000008D976E1283C014C052B81E85EBA14A409A999999991913C05A643BDF4F2D4B40F4FDD478E92611C060E5D022DB594A4021B07268916D10C091ED7C3F35CE4A400AD7A3703D0A10C0D34D621058E94B40', NULL, 20.010000000000002, NULL, 'Ma quande lingues coalesce, li grammatica del resultant.', 'GB007', '190242240091040133');
INSERT INTO "AggregateGeoFeature" VALUES ('description-f010', 'name-f010', NULL, NULL, '0106000020E610000002000000010300000002000000090000000000000000003440000000000000494000000000000033400000000000004B4000000000000034400000000000804B400000000000003E400000000000004E400000000000003C400000000000004A400000000000003B4000000000008049400000000000003D4000000000008048400000000000003B400000000000804740000000000000344000000000000049400400000000000000000039400000000000804B4033333333333339400000000000004C409A999999991939400000000000004C4000000000000039400000000000804B400103000000020000000600000000000000000034400000000000C04140000000000000384000000000008041400000000000003C4000000000008041400000000000803B4000000000008043400000000000003640000000000080424000000000000034400000000000C04140040000000000000000003A400000000000004240000000000000394000000000008042400000000000003B4066666666666642400000000000003A400000000000004240', 24510, NULL, '
      Ma quande lingues coalesce, li grammatica del resultant lingue es plu
      simplic e regulari quam ti del coalescent lingues. Li nov lingua franca
      va esser plu simplic e regulari quam li existent Europan lingues.
      ', 'AK020', '038127144100188054');
INSERT INTO "AggregateGeoFeature" VALUES (NULL, 'name-f016', NULL, NULL, '0106000020E6100000010000000103000000020000000700000000000000000018400000000000C04C4000000000000020400000000000C04C4000000000000020400000000000004E4000000000000022400000000000404F4000000000000014400000000000404F4000000000000018400000000000004E4000000000000018400000000000C04C40040000000000000000001A400000000000004D400000000000001A400000000000804D400000000000001C400000000000804D400000000000001A400000000000004D40', -182.90000000000001, NULL, 'In rhoncus nisl sit amet sem.', 'EE010', '079157247148122182');


--
-- Data for Name: EntitéGénérique;
--

INSERT INTO "EntitéGénérique" VALUES ('description-f004', 'name-f004', '0103000020E6100000020000000500000000000000000000000000000000404E40000000000000000000000000000050400000000000001940000000000000504000000000000019400000000000404E4000000000000000000000000000404E400400000000000000000000400000000000C04E4000000000000000400000000000404F4000000000000010400000000000004F4000000000000000400000000000C04E40', true, 'abc3', 'name-f003', '093138158062077244');
INSERT INTO "EntitéGénérique" VALUES ('description-f007', 'name-f007', '0103000020E610000002000000060000000000000000002E400000000000804140000000000000304000000000000044400000000000003440000000000080434000000000008036400000000000804240000000000000324000000000000042400000000000002E400000000000804140070000000000000000803140CDCCCCCCCC8C42409A999999999931409A999999999942403333333333B331406666666666A64240CDCCCCCCCCCC31403333333333B342406666666666E631400000000000C042406666666666E6314000000000008042400000000000803140CDCCCCCCCC8C4240', false, 'def4', NULL, '217192121132088252');
INSERT INTO "EntitéGénérique" VALUES (NULL, 'name-f017', '0102000020E6100000050000007F6ABC749398134083C0CAA14516494077BE9F1A2FDD1540FA7E6ABC74534A407F6ABC7493981B40355EBA490CF24A401F85EB51B81E1F4037894160E5304B40355EBA490CC2214004560E2DB27D4B40', false, 'qrst', 'name-f015', '192212031198038040');


--
-- Data for Name: PrimitiveGeoFeature;
--

INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f001', 'name-f001', NULL, '0101000020E6100000F437A1100107004044FAEDEBC0DD4340', NULL, 155, 'http://www.opengeospatial.org/', 12765, NULL, '2006-10-25', 5.0300000000000002, '212029115029082236');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f002', 'name-f002', NULL, '0101000020E6100000AED3484BE5EDCC3F698CD651D5B44D40', NULL, 154, 'http://www.opengeospatial.org/', 12769, NULL, '2006-10-23', 4.0199999999999996, '208038231224202073');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f003', 'name-f003', NULL, NULL, '0102000020E6100000030000000C022B8716992340B6F3FDD4780947403BDF4F8D97EE2440FA7E6ABC74534740986E1283C00A26403BDF4F8D978E4740', 180, NULL, 672.10000000000002, '2006-06-28 07:08:00+02', '2006-09-01', 12.92, '193012100059243077');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f008', 'name-f008', '0103000020E61000000100000004000000A01A2FDD24E63E4083C0CAA1459646409EEFA7C64B773E40FA7E6ABC74D346409EEFA7C64B773E40355EBA490CF24640A01A2FDD24E63E4083C0CAA145964640', NULL, NULL, 300, NULL, 783.5, '2006-06-28 07:08:00+02', '2006-12-12', 18.920000000000002, '200082145220236058');
INSERT INTO "PrimitiveGeoFeature" VALUES (NULL, 'name-f015', NULL, '0101000020E61000000AD7A3703D0A25C0B81E85EB51784140', NULL, -900, NULL, -2.3999999999999999, NULL, NULL, 7.9000000000000004, '129016253004006188');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f091', 'name-f091', NULL, '0101000020E6100000AB21718FA58F01C02B306475ABEB4840', NULL, -12678967543233, NULL, -0.1278, NULL, NULL, 80.019999999999996, '129174084193117250');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f092', 'name-f092', NULL, NULL, NULL, 4567, NULL, 1445.5699999999999, '2007-08-21 15:47:24+02', NULL, 3.1400000000000001, '120248019163004005');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f093', 'name-f093', NULL, NULL, '0102000020E6100000040000000C022B8716992140B6F3FDD4780942403BDF4F8D97EE2240FA7E6ABC74534240986E1283C00A24403BDF4F8D978E4240E9263108AC1C2340FA7E6ABC74534240', -1234, NULL, 1594.01, NULL, NULL, 9.8599999999999994, '116045136153137254');
INSERT INTO "PrimitiveGeoFeature" VALUES ('description-f094', 'name-f094', NULL, NULL, NULL, 882, NULL, 26.329999999999998, NULL, NULL, 1000, '126186161011180117');
