/* sendme.h -- generated by Trunnel v1.5.2.
 * https://gitweb.torproject.org/trunnel.git
 * You probably shouldn't edit this file.
 */
#ifndef TRUNNEL_SENDME_H
#define TRUNNEL_SENDME_H

#include <stdint.h>
#include "trunnel.h"

#define TRUNNEL_SENDME_V1_DIGEST_LEN 20
#if !defined(TRUNNEL_OPAQUE) && !defined(TRUNNEL_OPAQUE_SENDME_CELL)
struct sendme_cell_st {
  uint8_t version;
  uint16_t data_len;
  uint8_t data_v1_digest[TRUNNEL_SENDME_V1_DIGEST_LEN];
  uint8_t trunnel_error_code_;
};
#endif
typedef struct sendme_cell_st sendme_cell_t;
/** Return a newly allocated sendme_cell with all elements set to
 * zero.
 */
sendme_cell_t *sendme_cell_new(void);
/** Release all storage held by the sendme_cell in 'victim'. (Do
 * nothing if 'victim' is NULL.)
 */
void sendme_cell_free(sendme_cell_t *victim);
/** Try to parse a sendme_cell from the buffer in 'input', using up to
 * 'len_in' bytes from the input buffer. On success, return the number
 * of bytes consumed and set *output to the newly allocated
 * sendme_cell_t. On failure, return -2 if the input appears
 * truncated, and -1 if the input is otherwise invalid.
 */
ssize_t sendme_cell_parse(sendme_cell_t **output, const uint8_t *input, const size_t len_in);
/** Return the number of bytes we expect to need to encode the
 * sendme_cell in 'obj'. On failure, return a negative value. Note
 * that this value may be an overestimate, and can even be an
 * underestimate for certain unencodeable objects.
 */
ssize_t sendme_cell_encoded_len(const sendme_cell_t *obj);
/** Try to encode the sendme_cell from 'input' into the buffer at
 * 'output', using up to 'avail' bytes of the output buffer. On
 * success, return the number of bytes used. On failure, return -2 if
 * the buffer was not long enough, and -1 if the input was invalid.
 */
ssize_t sendme_cell_encode(uint8_t *output, size_t avail, const sendme_cell_t *input);
/** Check whether the internal state of the sendme_cell in 'obj' is
 * consistent. Return NULL if it is, and a short message if it is not.
 */
const char *sendme_cell_check(const sendme_cell_t *obj);
/** Clear any errors that were set on the object 'obj' by its setter
 * functions. Return true iff errors were cleared.
 */
int sendme_cell_clear_errors(sendme_cell_t *obj);
/** Return the value of the version field of the sendme_cell_t in
 * 'inp'
 */
uint8_t sendme_cell_get_version(const sendme_cell_t *inp);
/** Set the value of the version field of the sendme_cell_t in 'inp'
 * to 'val'. Return 0 on success; return -1 and set the error code on
 * 'inp' on failure.
 */
int sendme_cell_set_version(sendme_cell_t *inp, uint8_t val);
/** Return the value of the data_len field of the sendme_cell_t in
 * 'inp'
 */
uint16_t sendme_cell_get_data_len(const sendme_cell_t *inp);
/** Set the value of the data_len field of the sendme_cell_t in 'inp'
 * to 'val'. Return 0 on success; return -1 and set the error code on
 * 'inp' on failure.
 */
int sendme_cell_set_data_len(sendme_cell_t *inp, uint16_t val);
/** Return the (constant) length of the array holding the
 * data_v1_digest field of the sendme_cell_t in 'inp'.
 */
size_t sendme_cell_getlen_data_v1_digest(const sendme_cell_t *inp);
/** Return the element at position 'idx' of the fixed array field
 * data_v1_digest of the sendme_cell_t in 'inp'.
 */
uint8_t sendme_cell_get_data_v1_digest(sendme_cell_t *inp, size_t idx);
/** As sendme_cell_get_data_v1_digest, but take and return a const
 * pointer
 */
uint8_t sendme_cell_getconst_data_v1_digest(const sendme_cell_t *inp, size_t idx);
/** Change the element at position 'idx' of the fixed array field
 * data_v1_digest of the sendme_cell_t in 'inp', so that it will hold
 * the value 'elt'.
 */
int sendme_cell_set_data_v1_digest(sendme_cell_t *inp, size_t idx, uint8_t elt);
/** Return a pointer to the TRUNNEL_SENDME_V1_DIGEST_LEN-element array
 * field data_v1_digest of 'inp'.
 */
uint8_t * sendme_cell_getarray_data_v1_digest(sendme_cell_t *inp);
/** As sendme_cell_get_data_v1_digest, but take and return a const
 * pointer
 */
const uint8_t  * sendme_cell_getconstarray_data_v1_digest(const sendme_cell_t *inp);


#endif
