/* Copyright 2001-2004 Roger Dingledine.
 * Copyright (c) 2004-2006, Roger Dingledine, Nick Mathewson.
 * Copyright (c) 2007-2020, The Tor Project, Inc. */
/* See LICENSE for licensing information */

#include "orconfig.h"
#include "lib/version/git_revision.h"

/**
 * @file git_revision.c
 * @brief Strings to describe the current Git commit.
 **/

/** String describing which Tor Git repository version the source was
 * built from.  This string is generated by a bit of shell kludging in
 * src/core/include.am, and is usually right.
 */
const char tor_git_revision[] =
#ifndef COCCI
#ifndef _MSC_VER
#include "micro-revision.i"
#endif
#endif
  "";

/**
 * String appended to Tor bug messages describing the Tor version.
 *
 * It has the form "(on Tor 0.4.3.1-alpha)" or
 * "(on Tor 0.4.3.1-alpha git-b994397f1af193f8)"
 **/
const char tor_bug_suffix[] = " (on Tor " VERSION
#ifndef COCCI
#ifndef _MSC_VER
  " "
#include "micro-revision.i"
#endif
#endif /* !defined(COCCI) */
  ")";
