Previously, the `alias.term` and `alias.type` would fail if the source argument was hash-only, and there was no way to create an alias for a definition that didn't already have a name.  Also, the `replace.term` and `replace.type` _only_ worked on hashes, and they had to be _full_ hashes.

With this PR, the source of an alias can be a short hash (even of a definition that doesn't currently have a name in the namespace) along with a name or hash-qualified name from the current namespace as usual, and the arguments to `replace.term` and `replace.type` can be a short hash, a name, or a hash-qualified name.

Let's make some hash-only aliases, now that we can. :mad-with-power-emoji:

```ucm
.> alias.type ##Nat Cat
.> alias.term ##Nat.+ please_fix_763.+
```

And some functions that use them:
```unison
f = 3
g = 4
h = f + 1

> h
```

```ucm
.> add
```

We used to have to know the full hash for a definition to be able to use the `replace.*` commands, but now we don't:
```ucm
.> names g
.> replace.term f g
.> names g
.> view.patch
```

The value of `h` should have been updated too:
```unison
> h
```
