

```unison
toException : Either Failure a ->{Exception} a
toException = cases
  Left e -> raise e
  Right a -> a

putText : Handle -> Text ->{IO, Exception} ()
putText h t = putBytes h (toUtf8 t)

bugFail = cases
  Failure typ _ _ -> bug (Failure typ "problem" (Any ()))

Exception.unsafeRun! : '{Exception, g} a -> '{g} a
Exception.unsafeRun! e _ = 
    h : Request {Exception} a -> a 
    h = cases 
        {Exception.raise fail -> _ } -> 
            bugFail fail
        {a} -> a 
    handle !e with h 

hello : Text -> Text -> {IO, Exception} ()
hello host port = 
    socket = serverSocket (Some host) port
    msg = toUtf8 "Hello there" 
    socketSend socket msg
    closeSocket socket 

myServer = unsafeRun! '(hello "127.0.0.1" "0")

```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      Exception.unsafeRun! : '{g, Exception} a -> '{g} a
      bugFail              : Failure -> r
      hello                : Text -> Text ->{IO, Exception} ()
      myServer             : '{IO} ()
      putText              : Handle -> Text ->{IO, Exception} ()
      toException          : Either Failure a ->{Exception} a
        (also named Exception.reraise , base.Either.toException
        , and base.Exception.reraise)

```
```ucm
.> run myServer 

  💔💥
  
  I've encountered a call to builtin.bug with the following
  value:
  
    base.io.Failure.Failure
      (typeLink base.io.IOFailure) "problem" !base.Any.Any
  
  I'm sorry this message doesn't have more detail about the
  location of the failure. My makers plan to fix this in a
  future release. 😢

```
