##### This transcript reproduces the failure to unlink documentation

Step 1: code a term and documentation for it
```unison
x = 1
x.doc = [: I am the documentation for x:]
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      x     : Nat
      x.doc : Doc

```
Step 2: add term and documentation, link, and check the documentation
```ucm
.> add

  ⍟ I've added these definitions:
  
    x     : Nat
    x.doc : Doc

.> link x.doc x

  Updates:
  
    1. x : Nat
       + 2. doc : Doc

.> docs x

  I am the documentation for x

```
Step 3: Oops I don't like the doc, so I will re-code it!
```unison
x.doc = [: I am the documentation for x, and I now look better:]
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These names already exist. You can `update` them to your
      new definition:
    
      x.doc : Doc

```
Step 4: I add it and expect to see it
```ucm
.> update

  ⍟ I've updated these names to your new definition:
  
    x.doc : Doc

.> docs x

  I am the documentation for x, and I now look better

```
That works great. Let's relink the old doc too.

```ucm
.> link #v8f1hhvs57 x

  Updates:
  
    1. x : Nat
       + 2. #v8f1hhvs57 : Doc

```
Let's check that we see both docs:

```ucm
.> docs x

  I am the documentation for x, and I now look better

```
