```ucm:hide
.> builtins.mergeio
```

```unison
ability Exception where raise : Failure -> x

ex = unsafeRun! '(printLine "hello world")

printLine : Text ->{IO, Exception} ()
printLine t =
    putText stdOut t
    putText stdOut "\n"

stdOut : Handle
stdOut = stdHandle StdOut

compose2 : (c ->{𝕖} d) -> (a ->{𝕖} b ->{𝕖} c) -> a -> b ->{𝕖} d
compose2 f g x y = f (g x y)

putBytes : Handle -> Bytes ->{IO, Exception} ()
putBytes = compose2 toException putBytes.impl

toException : Either Failure a ->{Exception} a
toException = cases
  Left e -> raise e
  Right a -> a

putText : Handle -> Text ->{IO, Exception} ()
putText h t = putBytes h (toUtf8 t)

Exception.unsafeRun! : '{Exception, g} a -> '{g} a
Exception.unsafeRun! e _ = 
    h : Request {Exception} a -> a 
    h = cases 
        {Exception.raise fail -> _ } -> 
            bug fail 
        {a} -> a 
    handle !e with h 
```

```ucm 
.> run ex 
```