
```ucm:hide
.> builtins.merge
```

Add `List.zonk` to the codebase:

```unison
List.zonk : [a] -> [a]
List.zonk xs = xs

Text.zonk : Text -> Text
Text.zonk txt = txt ++ "!! "
```

```ucm:hide
.> add
```

Now, typecheck a file with a reference to `Blah.zonk` (which doesn't exist in the codebase). This should fail:

```unison:error
-- should not typecheck as there's no `Blah.zonk` in the codebase
> Blah.zonk [1,2,3]
```

Here's another example, just checking that TDNR works for definitions in the same file:

```unison
foo.bar.baz = 42

qux.baz = "hello"

ex = baz ++ ", world!"

> ex
```

Here's another example, checking that TDNR works when multiple codebase definitions have matching names:

```unison
ex = zonk "hi"

> ex
```

Last example, showing that TDNR works when there are multiple matching names in both the file and the codebase:

```unison
woot.zonk = "woot"
woot2.zonk = 9384

ex = zonk "hi" -- should resolve to Text.zonk, from the codebase
      ++ zonk   -- should resolve to the local `woot.zonk` from this file

> ex
```
