First we add some code:

```unison
x = 0
y = x + 1
z = y + 2
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      x : Nat
      y : Nat
      z : Nat

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    x : Nat
    y : Nat
    z : Nat

```
Now we edit `x` to be `7`, which should make `z` equal `10`:

```unison
x = 7
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These names already exist. You can `update` them to your
      new definition:
    
      x : Nat

```
```ucm
.> update

  ⍟ I've updated these names to your new definition:
  
    x : Nat

.> view x y z

  x : Nat
  x = 7
  
  y : Nat
  y =
    use Nat +
    x + 1
  
  z : Nat
  z =
    use Nat +
    y + 2

```
Uh oh! `z` is still referencing the old version. Just to confirm:

```unison
test> t1 = if z == 3 then [Fail "nooo!!!"] else [Ok "great"]
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      t1 : [Result]
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    1 | test> t1 = if z == 3 then [Fail "nooo!!!"] else [Ok "great"]
    
    ✅ Passed great

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    t1 : [Result]

.> test

  Cached test results (`help testcache` to learn more)
  
  ◉ t1   great
  
  ✅ 1 test(s) passing
  
  Tip: Use view t1 to view the source of a test.

```
