C----
C---- $Id: polyno.f,v 1.2 1995/11/10 14:16:24 hooft Exp $
C----
      SUBROUTINE POLYNOMIAL_FIT (X,Y,SY,N,CHI2,POLYGRADE)
      IMPLICIT NONE
C----
C---- B=SLOPE
C----
      INTEGER       MAXSVDDATA, MAXSVDPAR, N
      REAL          X(N), Y(N), SY(N)
      REAL          CHI2, PAR
      INTEGER       NPAR, POLYGRADE, I
      PARAMETER     (MAXSVDDATA=1000)
      PARAMETER     (MAXSVDPAR=50)
      COMMON /POLY/ NPAR,PAR(MAXSVDPAR)
      REAL          U(MAXSVDDATA,MAXSVDPAR), V(MAXSVDPAR,MAXSVDPAR),
     +              W(MAXSVDPAR)
      EXTERNAL      POLYNOME

      NPAR=POLYGRADE+1
      IF (N.GT.MAXSVDDATA) STOP 'Too many data for SVD fit.'
      IF (NPAR.GT.MAXSVDPAR) STOP 'Too many parameters for SVD fit.'
      CALL SVDFIT(X,Y,SY,N,PAR,NPAR,U,V,W,MAXSVDDATA,MAXSVDPAR,
     +     CHI2,POLYNOME)
      WRITE(*,*) 'Polynome fit :'
      DO I=1,NPAR
         WRITE(*,*) '  Parameter ',I-1,'=',PAR(I)
      END DO
      WRITE(*,*) '  CHI squared = ',CHI2
      RETURN
      END

      SUBROUTINE POLYNOME (X,AFUNC,MA)
      REAL AFUNC(*)
      F=1.0
      DO I=1,MA
         AFUNC(I)=F
         F=F*X
      END DO
      RETURN
      END

      REAL FUNCTION POLYNOME_VAL (X)
      IMPLICIT      NONE
      INTEGER       I, MAXSVDDATA, MAXSVDPAR, NPAR
      REAL          F, G, X, PAR
      PARAMETER     (MAXSVDDATA=1000)
      PARAMETER     (MAXSVDPAR=50)
      COMMON /POLY/ NPAR, PAR(MAXSVDPAR)
      F=1.0
      G=0.0
      DO I=1,NPAR
         G=G+PAR(I)*F
         F=F*X
      END DO
      POLYNOME_VAL=G
      RETURN
      END    
