/* 
 * $Id: support.c 6306 2008-05-27 12:22:15Z vriend $ 
 * Rob W.W. Hooft, 1994,5,6
 */ 
 
/* 
 * Symbols 
 */ 
 
#define _XOPEN_SOURCE

#if defined(sun) && defined(__svr4__) 
#if !defined(SOLARIS) 
#define SOLARIS 1 
#endif 
#endif 
 
#if defined(sgi) 
#if !defined(IRIX) 
#define IRIX 1 
#endif 
#endif 
 
#if !!defined(WINDOWS) 
#if !defined(UNIX) 
#define UNIX 1 
#endif 
#endif 
 
#if defined(UNIX) && !defined(WINDOWS) 
#include <sys/time.h> 
#include <time.h> 
#endif 
#if defined(WINDOWS) 
#include <time.h> 
#endif 
/* 
 * Includes 
 */ 
 
#include <sys/types.h> 
#if !defined(CROSS_COMPILE) 
#if !defined(WINDOWS) 
    #include <sys/times.h> 
#endif 
#if defined(WINDOWS) 
#include <sys/time.h> 
#endif  
    #include <sys/param.h> 
#endif 
#if defined(ESV) 
  #include "/usr/include/unistd.h" 
#else 
  #include <unistd.h> 
/*  #include <malloc.h> */
#endif 
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 
/* 
 * Other routines that might be needed 
 */ 
 
void coredump_ () 
{  
  abort();  
} 
 
#if !defined(CROSS_COMPILE) 
#if !defined(HZ) 
#define HZ 60 
#endif 
float irisec_ (dummy) 
float *dummy; 
{ 
    struct tms my_time; 
    return ((float)times(&my_time)/(float)HZ); 
} 
#endif 
 
#if defined(WINDOWS) 
  #define GETC 
  #include <windows.h> 
  #include <fcntl.h>	/*for _O_BINARY */ 
#include <sys/types.h> 
#include <stdio.h> 
 
#define _fopen fopen 
#define fopen(file,mode) _fopen(file,mode"O_BINARY") 
#define open(path,oflag)  _open(path,oflag|O_BINARY&(~O_CREAT),0,mode"O_BINARY") 
#define creat(path,mode) _open(path, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, mode"O_BINARY") 
 
#endif 
 
 
#if defined(UNIX) 
  #include <signal.h> 
  #include <stdio.h> 
  #include <errno.h> 
  #include <stdlib.h> 
 
static int interrupted=0; 
 
void cchandler() 
{ 
  interrupted++; 
  /*fprintf(stderr,"...Interrupt seen...\n"); fflush(stderr);*/ 
} 
 
void setcc_() 
{ 
#if !defined(CROSS_COMPILE) 
#if !defined(WINDOWS) 
  struct sigaction *act; 
  /*fprintf(stderr,"...Handler initialized...\n"); fflush(stderr);*/ 
  act=(struct sigaction *)malloc(sizeof(struct sigaction)); 
  if (!act) { 
    fprintf(stderr,"OOPS: No memory for Control-C handler?\n"); 
    exit(1); 
  } 
  act->sa_handler=cchandler; 
  sigprocmask(SIG_SETMASK,NULL,&act->sa_mask); 
  act->sa_flags=0; 
  if (sigaction(SIGINT,act,NULL)) { 
    perror("sigaction on SIGINT"); 
    exit(1); 
  } 
  interrupted=0; 
  free(act); 
#endif 
#endif 
} 
 
int getcc_() 
{ 
  return interrupted; 
} 
#endif 
 
#if defined(UNIX) 
#include <signal.h> 
#include <stdio.h> 
#include <errno.h> 
#include <stdlib.h> 
 
void usr1handler() 
{ 
  fprintf(stderr,"...USR1 caught...\n"); fflush(stderr); 
} 
 
int waitkill_() 
{ 
#if !defined(CROSS_COMPILE) 
#if !defined(WINDOWS) 
  struct sigaction *act; 
  fprintf(stderr,"...USR1 Handler initialized...\n"); fflush(stderr); 
  act=(struct sigaction *)malloc(sizeof(struct sigaction)); 
  if (!act) { 
    fprintf(stderr,"OOPS: No memory for USR1 handler?\n"); 
    exit(1); 
  } 
  act->sa_handler=usr1handler; 
  sigprocmask(SIG_SETMASK,NULL,&act->sa_mask); 
  act->sa_flags=0; 
  if (sigaction(SIGUSR1,act,NULL)) { 
    perror("sigaction on SIGUSR1"); 
    exit(1); 
  } 
  free(act); 
  /* sleep until we get a signal */ 
  pause(); 
#endif 
#endif 
  return 0; 
} 
#endif 
 
#if !defined(DONTUSEITIMER) && defined(UNIX) && !defined(WINDOWS) 
#include <sys/signal.h> 
#include <signal.h> 
#include <stdio.h> 
#include <unistd.h> 
 
void catchalarm() {} 
 
void myusleep(v) 
int v; 
{ 
  struct itimerval value,ovalue; 
  value.it_value.tv_sec=0; 
  value.it_value.tv_usec=v; 
  value.it_interval.tv_sec=0; 
  value.it_interval.tv_usec=0; 
  signal(SIGALRM,catchalarm); 
  setitimer(ITIMER_REAL,&value,&ovalue); 
  pause(); 
} 
#define usleep myusleep 
#endif 
 
#if defined (UNIX) 
void besocial_() 
{ 
#if defined(CROSS_COMPILE) && !defined(WINDOWS) 
  usleep(25000); 
#endif 
} 
 
void besocial__() { besocial_(); } 
#endif 
 
 
/* 
 * Another package.... 
 */ 
 
#if defined(CTEXT) 
/* 
   A faster replacement for the GET_TEXT routine from the international 
   version of WHAT IF 
 
   Rob Hooft, 16th April 1994 
*/ 
 
 
static FILE * messages = 0; 
static char keyword[11]; 
 
struct Loc { 
  char keyword[11]; 
  int pos; 
}; 
 
#define HASHBINS 233 
 
#if !__STDC__ 
static int hashval(p) 
char *p; 
#else 
static int hashval(char *p) 
#endif 
{ 
  unsigned int h=56487; 
  char *q=p; 
  while (*q) h=(h^*q++)<<2; 
  return h%HASHBINS; 
} 
 
static struct Loc *loc[HASHBINS]; 
static int alloccnt[HASHBINS] = {0}; 
static int cnt[HASHBINS] = {0}; 
static char lang = 'E'; /* Default language is English */ 
 
#if !__STDC__ 
static int findkey(key,s) 
char *key; 
struct Loc **s; 
#else 
static int findkey(char *key,struct Loc **s) 
#endif 
{ 
  int i; 
  int bin=hashval(key); 
  for (i=0;i<cnt[bin];i++) { 
    if (!strcmp(key,loc[bin][i].keyword)) { 
      *s= &loc[bin][i]; 
      return 1; 
    } 
  } 
  *s=NULL; 
  return 0; 
} 
 
#if !__STDC__ 
static int grabtext(lang,out,nlines,maxlines) 
char lang; 
char *out; 
int *nlines,maxlines; 
#else 
static int grabtext(char lang,char *out,int *nlines, int maxlines) 
#endif 
{ int state=0; 
  char buf[84]; 
  /* ALL THESE #ifdef CROSS_COMPILE ARE NEEDED TO WORK AROUND A BUG IN ftell/fseek */ 
#if defined(CROSS_COMPILE) 
  int i,j; 
#endif 
  *nlines=0; 
#if !defined(CROSS_COMPILE) 
  while (fgets(buf,83,messages)) { 
#else 
  while (1) 
  { i=0; 
    do 
    { j=fgetc(messages); 
      if (j==EOF) break; 
      if (j!='\r') buf[i++]=j; } 
    while (j!='\n'); 
    buf[i]='\0'; 
    if (j==EOF) break; 
#endif 
    if (buf[0]=='*') break; /* End of the message */ 
    if (buf[0]==lang) state++; 
    if (state) { 
      /* If we already have text, there is something on this line 
         and it does not start with a space or dot, we are done */ 
      if (buf[0]!='\n' && buf[0]!='\0' && buf[0]!=' ' && buf[0]!='.' && *nlines) { 
				return *nlines; 
      } 
      {  
        int i=0; 
        int l=strlen(buf); 
        if (*nlines>=maxlines) { 
           fprintf (stderr,"Too many lines\n"); 
      	   fprintf (stderr,"Offending '?' code : %s\n",keyword); 
           return *nlines; 
        } 
        if (l>4) { 
          for (i=0;buf[i+3]&&buf[i+3]!='\n'&&i<80;i++) { 
            out[80*(*nlines)+i]=buf[i+3]; 
          } 
        } 
        for (;i<80;i++) out[80*(*nlines)+i]=' '; 
        (*nlines)++; 
      } 
    } 
  } 
  return *nlines; 
} 
 
int textlang_ (inlang) 
char *inlang; 
{ 
  lang = *inlang; 
  return 0; 
} 
 
int inittext_ (innam,len) 
char *innam; 
int *len; 
{ 
  char *filnam=malloc(*len+1); 
  char buf[84]; 
  int i,j,bin; 
  struct Loc *dum; 
 
  for (i=0;i<*len;i++) filnam[i]=innam[i]; 
  filnam[*len]='\0'; 
 
/* ALL THESE #ifdef CROSS_COMPILE ARE NEEDED TO WORK AROUND A BUG IN ftell/fseek */ 
#if !defined(CROSS_COMPILE) 
  if ((messages=fopen(filnam,"r"))==0) { 
#else 
  if ((messages=fopen(filnam,"rb"))==0) { 
#endif 
    fprintf(stderr,"C-inittext could not open messages file: '%s'\n",filnam); 
    fprintf(stderr,"Possible configuration error in DO_WHATIF.COM, "); 
    fprintf(stderr,"WHATIF.FIG or CCONFI.FIG\n"); 
    fflush(stderr); 
    exit(3); 
  } 
  j=0; 
#if !defined(CROSS_COMPILE) 
  while (fgets(buf,83,messages)) { 
#else 
  while (1) 
  { i=0; 
    do 
    { j=fgetc(messages); 
      if (j==EOF) break; 
      if (j!='\r') buf[i++]=j; } 
    while (j!='\n'); 
    buf[i]='\0'; 
    if (j==EOF) break; 
#endif 
    /* Did we come across a new message identifier? */ 
    if (buf[0]=='*' && buf[1]!=' ' && buf[1]!='\n' && buf[1]!='\0') { 
    	/* Remove trailing spaces and newline. */ 
      int l=strlen(buf)-1; 
      for (;buf[l]==' '||buf[l]=='\n';l--) buf[l]='\0'; 
      /* See if we already have it */ 
      if (findkey(buf+1,&dum)) 
        fprintf(stderr,"Duplicate message identifier : '%s'\n",buf+1); 
      /* Store it */ 
      bin=hashval(buf+1); 
      if (cnt[bin]>=alloccnt[bin]) { 
        if (alloccnt[bin]==0) { 
    	    alloccnt[bin]=16; 
				  if ((loc[bin]=(struct Loc *)malloc(alloccnt[bin]*sizeof(struct Loc)))==0) { 
		    		fprintf(stderr,"No memory for allocation in inittext\n"); 
				    fflush(stderr); 
	  			  exit(3); 
			  	} 
				} else { 
				  alloccnt[bin]+=8; 
	  			if ((loc[bin]=(struct Loc *)realloc(loc[bin],alloccnt[bin]*sizeof(struct Loc)))==0) { 
				    fprintf(stderr,"No memory for reallocation in inittext\n"); 
	  			  fflush(stderr); 
			    	exit(3); 
		  		} 
				} 
      } 
      loc[bin][cnt[bin]].pos=ftell(messages); 
      for (i=0 ; i<10&&buf[i+1] ; i++) 
				loc[bin][cnt[bin]].keyword[i]=buf[i+1]; 
      loc[bin][cnt[bin]].keyword[i]='\0'; 
      /* 
      fprintf(stderr,"Stored '%s' at %d\n",loc[bin][cnt[bin]].keyword,loc[bin][cnt[bin]].pos); 
      fprintf(stderr,"New position:%d\n",(int)ftell(messages)); 
      i=fgetc(messages); 
      fprintf(stderr,"Char: %c\n",i); 
      fseek(messages,loc[bin][cnt[bin]].pos,SEEK_SET); 
      fprintf(stderr,"New position:%d\n",(int)ftell(messages)); 
      i=fgetc(messages); 
      fprintf(stderr,"Fseek result: %c\n",i); 
      */ 
      cnt[bin]++; 
    } 
    if (j==EOF) break; 
  } 
  /*for (i=0;i<HASHBINS;i++) fprintf(stderr,"%d messages in bin %d\n",cnt[i],i);*/ 
  free(filnam); 
  return 0; 
}  
 
#if __STDC__ 
void gvskila_(void); 
#endif 
 
int cgettext_(inkey,len,out,nlines,maxlines) 
char *inkey, *out; 
int *len,*nlines,*maxlines; 
{ 
  int i; 
  struct Loc *rec=NULL; 
 
  if (*len>11) { 
    fprintf (stderr,"Message identifier '%s' too long in cgettext\n",inkey); 
    gvskila_(); 
    fflush(stderr); 
    return 0; 
  } 
  *nlines = 0; 
 
/* Copy the keyword to a C-style string */ 
 
  for (i=0;i<*len;i++) keyword[i]=inkey[i]; 
  keyword[*len]='\0'; 
/* Verify correct call-order */ 
 
  if (!messages) { 
    fprintf (stderr,"gettext not initialized\n"); 
    fflush(stderr); 
    return 0; 
  } 
 
/* Look up the keyword in the array of message-ids */ 
 
  if (!findkey(keyword+1,&rec)) { 
    fprintf (stderr,"Message identifier '%s' not found in message file\n", 
	    keyword); 
    fflush(stderr); 
    gvskila_(); 
    return 0; 
  } 
/* Get the text in the language of choice */ 
 
  fseek(messages,rec->pos,SEEK_SET); 
  if (grabtext(lang,out,nlines,*maxlines)) return 0; 
 
/* If we have not found it, look for the english language version */ 
 
  fseek(messages,rec->pos,SEEK_SET); 
  if (grabtext('E',out,nlines,*maxlines)) return 0; 
 
  fprintf (stderr,"Message '%s' not available in the current language\nand also not in english\n",keyword); 
  fflush(stderr); 
  gvskila_(); 
  return 0; 
} 
#endif 
 
 
#if defined(linux) || defined(F2C) || !defined(WINDOWS) 
int sleep_(i) 
int *i; 
{ 
#if !defined(CROSS_COMPILE) 
  sleep(*i); 
#endif 
  return 0; 
} 
#endif 
 
#if defined(UNIX) 
#include <sys/time.h> 
#if defined(AIX) 
#include <time.h> 
#endif 
#if defined(linux) 
#include <time.h> 
#endif 
void ctimestr_(out,len,ftnlen)  
char *out; 
int *len; 
int ftnlen; 
{ 
   struct tm * ti; 
   time_t sec; 
   sec=time(NULL); 
   ti=localtime(&sec); 
   ti->tm_mon++; 
   ti->tm_year+= ((ti->tm_year<70)?2000:1900); 
 
   sprintf(out,"%02d:%02d:%02d", ti->tm_hour,ti->tm_min,ti->tm_sec); 
   *len=8; 
} 
 
#if defined(UNIX) 
#if defined(__STDC__) 
void gvsdelc_(char *s,int ftnlen) 
#else 
void gvsdelc_(s,ftnlen) 
char *s; 
int ftnlen; 
#endif 
{ 
  int i; 
  char *t=malloc(ftnlen+1); 
  strncpy(t,s,ftnlen); 
  t[ftnlen]='\0'; 
  for (i=ftnlen-1;i>0&&t[i]==' ';i--) t[i]='\0'; 
  if (!access(t,F_OK)) { 
    if (unlink(t)) { 
      fprintf(stderr,"Removal of file '%s' failed\n",t); 
      fflush(stderr); 
    } 
  } 
  free(t); 
} 
 
#include <sys/stat.h> 
 
#if defined(__STDC__) 
void gvsmex_(char *s,int ftnlen) 
#else 
void gvsmex_(s,ftnlen) 
char *s; 
int ftnlen; 
#endif 
{ 
#if !defined(CROSS_COMPILE) 
  int i; 
  mode_t u; 
  struct stat b; 
  char *t=malloc(ftnlen+1); 
  strncpy(t,s,ftnlen); 
  t[ftnlen]='\0'; 
  for (i=ftnlen-1;i>0&&t[i]==' ';i--) t[i]='\0'; 
  if (!access(t,F_OK)) { 
    if (access(t,X_OK)) { 
      stat(t,&b); 
      u=umask(0); 
      umask(u); 
#if !defined(WINDOWS) 
      chmod(t,(b.st_mode|S_IXUSR|S_IXGRP|S_IXOTH) & ~u); 
#endif 
      fprintf(stderr,"Made file '%s' executable\n",t); 
    } 
  } else { 
    fprintf(stderr,"File '%s' does not exist, cannot make executable\n",t); 
    fflush(stderr); 
  } 
#endif /* CROSS_COMPILE */ 
} 
#endif 
 
#if defined(UNIX) 
void gvssev_ (s,ftnlen) 
char *s; 
int ftnlen; 
{ 
  char *t=malloc(ftnlen+1); 
  strncpy(t,s,ftnlen); 
  t[ftnlen]='\0'; 
  putenv(t); 
} 
#endif 
 
void cdatestr_(out,len,ftnlen)  
char *out; 
int *len; 
int ftnlen; 
{ 
   struct tm * ti; 
   time_t sec; 
   sec=time(NULL); 
   ti=localtime(&sec); 
   ti->tm_mon++; 
   ti->tm_year+= ((ti->tm_year<70)?2000:1900); 
 
   sprintf(out,"%04d-%02d-%02d", ti->tm_year,ti->tm_mon,ti->tm_mday); 
   *len=10; 
} 
#endif 
 
#if defined(UNIX) && !defined(WINDOWS) 
 
#include <fcntl.h> 
#include <errno.h> 
/* Check whether WHAT IF is already running in this directory */ 
int wiflock_ ()  
{ 
  int fid,len,pid,status,i; 
  char buf[11]; 
  if (!isatty(0) || !isatty(1)) return 0; 
  fid=open(".wifpid", O_RDWR | O_CREAT , 0644); 
  if (fid<0) { 
    fprintf(stderr,"WHAT IF Error: cannot create simple file here....\n"); 
    perror(".wifpid"); 
    exit(1); 
  } 
  len=read(fid,buf,sizeof(buf)-1); 
  if (len>0) { 
    buf[len]='\0'; 
    for (i=0;i<len;i++) if (buf[i]=='\n') buf[i]='\0'; 
    pid=atoi(buf); 
    if (pid<2) { 
      fprintf(stderr,"WHAT IF Warning: Corrupt file .wifpid found!\n"); 
    } else { 
    #if !defined(CROSS_COMPILE) 
      status=kill(pid,0); 
      if (status<0 && errno==EPERM) status=0; 
    #else 
      status=1; 
    #endif 
      if (status>=0) { 
        fprintf(stderr,"WHAT IF Error: already running in this directory...\n"); 
        exit(1); 
      } 
    } 
  } 
  lseek(fid,0,SEEK_SET); 
#if defined(CROSS_COMPILE) 
  sprintf(buf,"12345678\n"); 
#else 
  sprintf(buf,"%ld\n",(long)getpid()); 
#endif 
  write(fid,buf,strlen(buf)); 
  close(fid); 
  return 0; 
} 
#endif 
 
#if defined(CROSS_COMPILE) || defined(TWINSETYSR)
/* Here we define all the functions that are not needed in a cross-compiled 
   console version of WHAT IF or when YASARA does the graphics */ 
int qtest_(void) { return(0); } 
int qread_ (short int *data) { return(0); } 
int getbut_ (int *button) { return(0); } 
void getmouse_ (float *x_mouse,float *y_mouse) { } 
int getval_ (int *dev) { return(0); } 
void tpon_ (void) {} 
void tpoff_ (void) {} 
void x11parm_ (int *parm, int *value) {} 
void color_ (int *c) {} 
void clear_ (void) {} 
void zclear_ (void) {} 
void double_ (void) {} 
void textpo_ (void) {} 
void textin_ (void) {} 
void zbuffe_ (void) {} 
void gconfi_ (void) {} 
void lookat_ (void) {} 
void bgnpol_ (void) {} 
void v3f_ (void) {} 
void endpol_ (void) {} 
void shadem_ (void) {} 
void qdevic_ (void) {} 
void pick_ (void) {} 
void swapbu_ (void) {} 
void x11_menu_ (void) {} 
void ortho_ (float *left, float *right, float *bottom, float *top, float *nrp, float *frp) {} 
void viewpo_ (void) {} 
void callob_ (int *i) {} 
void do2d_ (void) {} 
void charst_ (char *str, int *length) {} 
void cmov_ (float *x, float *y, float *z) {} 
void move_ (float *x, float *y, float *z) {} 
void draw_ (float *x, float *y, float *z) {} 
void mapcol_ (int *i, int *red, int *green, int *blue) {} 
void pnt_ (float *x, float *y, float *z) {} 
void makeob_ (register int *i, register int *vectors) {} 
void delobj_ (register int *i) {} 
void closeo_ (void) {} 
void do3d_ (void) {} 
void x11box_ (register float *xlow, register float *xhigh, 
          register float *ylow, register float *yhigh, 
          register float *xtxt, register float *ytxt, 
          char *str, int *len, int *colorbox, int *colortxt) {} 
void pushma_ (void) {} 
void popmat_ (void) {} 
void getmat_ (float *matt) {} 
void ginit_ (int *ierr) {*ierr=1;} 
void multma_ (float *matt) {} 
void x11slab_ (float *thick) {} 
void xyz2xy_ (void) {} 
void scale_ (float *x, float *y, float *z) {} 
void transl_ (float *x, float *y, float *z) {} 
void loadma_ (float *matt) {} 
void wscale_ (float *x, float *y, float *z) {}
void x11clip_ (register float *xtop, register float *ytop,
               register float *xbottom, register float *ybottom) {}
void x11fontpath_(char *path) {}
void x11label_(int start) {}
/* OpenGL functions */
void wifatom_(float *x, float *y, float *z,float  *radii,int *color,
              float *transparency,float  *shininess,float  *atom_type1,float *atom_type2) {}
void wifbond_(float *x0,float *y0,float *z0,float *x1, float *y1, float *z1,
              float *bond_thickness,int *color,float *transparency,
              float *shininess,float *bond_type1,float *bond_type2) {}
void wifpolygon_(float *coords,int *nsides,int *color,float *transparency,
                 float *shininess,float *type1, float *type2) {}
void wifrectangle_(float *coords, int *color,float *transparency, float *shininess,
                   float *type1, float *type2) {}
void wiftriangle_(float *coords, int *color,float *transparency, float *shininess,
                  float *type1, float *type2) {}
int gracmd_ (void) { return(0); }
void gracmdlin_ (char *str) {}
#if defined (WINDOWS) 
float irisec_ (float *dummy) { return(0.0); } 
#endif
#endif 

 
/* By Rolando
   just a new feature in support.c allowing for a more 
   friendly system() interface ..
*/
#include <ctype.h>
void QuoteCommand(char *src)
{
   
  char TempCommand[2048];
  int  count,tcount;
  int  lastPath,IsCommand;

	IsCommand=0;
	if (strstr(src,"cp ")!=NULL) IsCommand=1;
	if (strstr(src,"mv ")!=NULL) IsCommand=1;

	lastPath = (int)strrchr(src,'/'); 

	if (lastPath==0) return;	

	tcount=0;
	memset(TempCommand,'\0',2048);
	count=lastPath-(int)src;

	if (!IsCommand) 
	{
		strcpy((char *)&TempCommand,"cmd /c \"");
		strncat((char *)&TempCommand,src,count+1);
	}
	else 
	{
		strcpy((char *)&TempCommand,"cmd /c ");
		strncat((char *)&TempCommand,src,3);
		strcat((char *)&TempCommand,"\"");
		strncat((char *)&TempCommand,src+(3*sizeof(char)),count-2);
	}
	
	tcount=count++;
	while (isalpha(src[++tcount])||(src[tcount]=='.')) 
		strncat((char *)&TempCommand,&src[tcount],1);
	
	strcat((char *)&TempCommand,"\" ");
	++tcount;
	strncat((char *)&TempCommand,&src[tcount],(strlen(src)-tcount));	

	strncpy(src,(char *)&TempCommand,1023);

}

int systemx_(const char *Command, long int fstringLen)
{ 
   char MyCommand[1024];
   int WindowsOS;

   if (fstringLen>1023) fstringLen=1023;
   strncpy((char *)&MyCommand, Command, fstringLen);
   MyCommand[fstringLen]='\0';

   /* Check the environment to see if we are in Linux 
      or windows .. */
   WindowsOS=0;

   if (getenv("OS")!=NULL)
	if (
		(strcmp("Windows_NT",getenv("OS"))==0)&&
		(getenv("COMSPEC")!=NULL)&&
		(getenv("WINDIR")!=NULL)&&
		(getenv("HOMEPATH")!=NULL)&&
		(getenv("LOGONSERVER")!=NULL)
	   ) WindowsOS=1;

   /* Escape all the spaces and other funny stuff in Windows */
   //if (WindowsOS) QuoteCommand((char *)&MyCommand); 

   /* by Rolando, not needed now ..*/
   //printf("MyCommand: %s \n",MyCommand);fflush(NULL);

   system(MyCommand);
   return(0);
}

/* From local_passwd.c (C) Regents of Univ. of California blah blah */
static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

void to64(char* s, long v, int n)
{
    while (--n >= 0) {
        *s++ = itoa64[v&0x3f];
        v >>= 6;
    }
}

void cryptpassword_(char* pw, int ftnlen)
{
	char salt[3];
	static int inited = 0;
	if (inited == 0)
	{
	    (void)srand((int)time((time_t *)NULL));
	    inited = 1;
	}
	to64(salt, rand(), 2);
	
	if (ftnlen > 0)
	{
		char* t;
		char* e;
		const char* hash;
		int hash_length, i;		
		t = malloc(ftnlen + 1);
		memset(t, 0, ftnlen + 1);		
		e = pw + ftnlen - 1;
		while (e != pw && *(e - 1) == ' ')
			--e;
		*e = 0;

/* fprintf(stderr, "wachtwoord: '%.*s'\n", ftnlen, pw); */		
		hash = crypt(pw, salt);
/* fprintf(stderr, "hash: '%s'\n", hash); */
		hash_length = strlen(hash);		
		if (hash_length > ftnlen)
		{
			if (ftnlen > 4)
			{
				hash = "FOUT";
				hash_length = 4;
			}
		}		
		for (i = 0; i < hash_length; ++i)
			pw[i] = hash[i];
		
		for (; i < ftnlen; ++i)
			pw[i] = ' ';			
		free(t);
	}
}

