



      SUBROUTINE GVSAM1 (X,Y,Z,NUM,RMAT,TVEC)











      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          X(NUM), Y(NUM), Z(NUM), RMAT(3,3), TVEC(3),
     +              XCEN, YCEN, ZCEN, XT, YT, ZT







      IF (NUM.EQ.0) THEN
         CALL GVSTTE ('?TLSB01')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN
         CALL GVSTTI ('?TLSB02',NUM)
         GOTO 998
      END IF



      XCEN=0.0
      YCEN=0.0
      ZCEN=0.0



      DO 10 I=1,NUM
         XCEN=XCEN+X(I)
         YCEN=YCEN+Y(I)
         ZCEN=ZCEN+Z(I)
   10 CONTINUE
      XCEN=XCEN/FLOAT(NUM)
      YCEN=YCEN/FLOAT(NUM)
      ZCEN=ZCEN/FLOAT(NUM)



      DO 20 I=1,NUM
         X(I)=X(I)-XCEN
         Y(I)=Y(I)-YCEN
         Z(I)=Z(I)-ZCEN
   20 CONTINUE



      DO 30 I=1,NUM
         XT=X(I)
         YT=Y(I)
         ZT=Z(I)
         X(I)=RMAT(1,1)*XT+RMAT(1,2)*YT+RMAT(1,3)*ZT+XCEN+TVEC(1)
         Y(I)=RMAT(2,1)*YT+RMAT(2,2)*YT+RMAT(2,3)*ZT+YCEN+TVEC(2)
         Z(I)=RMAT(3,1)*ZT+RMAT(3,2)*YT+RMAT(3,3)*ZT+ZCEN+TVEC(3)
   30 CONTINUE



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCM1 (XYZROW,NUM)











      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), XCEN, YCEN, ZCEN





      IF (NUM.GT.0) THEN



         XCEN=0.0
         YCEN=0.0
         ZCEN=0.0
         DO 10 I=1,NUM
            XCEN=XCEN+XYZROW(1,I)
            YCEN=YCEN+XYZROW(2,I)
            ZCEN=ZCEN+XYZROW(3,I)
   10    CONTINUE
         XCEN=XCEN/FLOAT(NUM)
         YCEN=YCEN/FLOAT(NUM)
         ZCEN=ZCEN/FLOAT(NUM)
         DO 20 I=1,NUM
            XYZROW(1,I)=XYZROW(1,I)-XCEN
            XYZROW(2,I)=XYZROW(2,I)-YCEN
            XYZROW(3,I)=XYZROW(3,I)-ZCEN
   20    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB03')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB04',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCM2 (XYZROW,NUM,VECT)












      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), VECT(3)





      IF (NUM.GT.0) THEN



         CALL GVSRT0 (VECT,3)
         DO 10 I=1,NUM
            VECT(1)=VECT(1)+XYZROW(1,I)
            VECT(2)=VECT(2)+XYZROW(2,I)
            VECT(3)=VECT(3)+XYZROW(3,I)
   10    CONTINUE
         VECT(1)=(-VECT(1))/FLOAT(NUM)
         VECT(2)=(-VECT(2))/FLOAT(NUM)
         VECT(3)=(-VECT(3))/FLOAT(NUM)
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB05')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB06',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCM3 (XYZROW,NUM,VECT)












      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), VECT(3)





      IF (NUM.GT.0) THEN



         CALL GVSRT0 (VECT,3)
         DO 10 I=1,NUM
            VECT(1)=VECT(1)+XYZROW(1,I)
            VECT(2)=VECT(2)+XYZROW(2,I)
            VECT(3)=VECT(3)+XYZROW(3,I)
   10    CONTINUE
         VECT(1)=(-VECT(1))/FLOAT(NUM)
         VECT(2)=(-VECT(2))/FLOAT(NUM)
         VECT(3)=(-VECT(3))/FLOAT(NUM)
         DO 20 I=1,NUM
            XYZROW(1,I)=XYZROW(1,I)+VECT(1)
            XYZROW(2,I)=XYZROW(2,I)+VECT(2)
            XYZROW(3,I)=XYZROW(3,I)+VECT(3)
   20    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB07')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB08',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCM4 (XYZROW,NUM,VECT)










      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), VECT(3)





      IF (NUM.GT.0) THEN



         DO 10 I=1,NUM
            XYZROW(1,I)=XYZROW(1,I)-VECT(1)
            XYZROW(2,I)=XYZROW(2,I)-VECT(2)
            XYZROW(3,I)=XYZROW(3,I)-VECT(3)
   10    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB09')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB01',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCM5 (XYZROW,NUM,VECT)










      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), VECT(3)





      IF (NUM.GT.0) THEN



         DO 10 I=1,NUM
            XYZROW(1,I)=XYZROW(1,I)+VECT(1)
            XYZROW(2,I)=XYZROW(2,I)+VECT(2)
            XYZROW(3,I)=XYZROW(3,I)+VECT(3)
   10    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB11')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB12',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCMA (XYZROW,NUM,RMAT,VECT)












      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZROW(3,NUM), RMAT(3,3), VECT(3)





      IF (NUM.GT.0) THEN



         DO 10 I=1,NUM
            CALL GVSMPV (XYZROW(1,I),RMAT,VECT)
   10    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB13')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB14',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCMT (XYZROW,BROW,NUM)












      IMPLICIT      NONE
      INTEGER       NUM, I, NUMUSE
      REAL          XYZROW(3,NUM), XCEN, YCEN, ZCEN
      LOGICAL       BROW(NUM)





      IF (NUM.GT.0) THEN



         XCEN=0.0
         YCEN=0.0
         ZCEN=0.0
         NUMUSE=0
         DO 10 I=1,NUM
            IF (BROW(I)) THEN
               XCEN=XCEN+XYZROW(1,I)
               YCEN=YCEN+XYZROW(2,I)
               ZCEN=ZCEN+XYZROW(3,I)
               NUMUSE=NUMUSE+1
            END IF
   10    CONTINUE
         XCEN=XCEN/FLOAT(NUMUSE)
         YCEN=YCEN/FLOAT(NUMUSE)
         ZCEN=ZCEN/FLOAT(NUMUSE)
         DO 20 I=1,NUM
            XYZROW(1,I)=XYZROW(1,I)-XCEN
            XYZROW(2,I)=XYZROW(2,I)-YCEN
            XYZROW(3,I)=XYZROW(3,I)-ZCEN
   20    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB15')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB16',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSCMU (XYZROW,NUM,RMAT,VECT)













      IMPLICIT      NONE
      INTEGER       NUM, I, IERR
      REAL          XYZROW(3,NUM), RMAT(3,3), RINV(3,3), VECT(3)







      CALL GVSMI2 (RINV,RMAT,3,IERR)
      IF (IERR.NE.0) GOTO 998
      IF (NUM.GT.0) THEN



         DO 10 I=1,NUM
            CALL GVSSV3 (XYZROW(1,I),VECT)
            CALL GVSMVV (XYZROW(1,I),RINV)
   10    CONTINUE
         GOTO 998
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB17')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB18',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSRSP (XYZ1,XYZ2,NUM,DIFMAX,DIFAVE,DIFRMS)











      IMPLICIT      NONE
      INTEGER       NUM, I
      REAL          XYZ1(3,NUM), XYZ2(3,NUM), DIFMAX, DIFAVE,
     +              DIFRMS, GVFDV3, DIFF







      DIFMAX=0.0
      DIFAVE=0.0
      DIFRMS=0.0



      IF (NUM.GT.0) THEN



         DO 10 I=1,NUM
            DIFF=GVFDV3(XYZ1(1,I),XYZ2(1,I))
            DIFMAX=MAX(DIFMAX,DIFF)
            DIFAVE=DIFAVE+DIFF
            DIFRMS=DIFRMS+DIFF**2
   10    CONTINUE



         DIFAVE=DIFAVE/FLOAT(NUM)
         DIFRMS=SQRT(DIFRMS/FLOAT(NUM))
      ELSE IF (NUM.EQ.0) THEN



         CALL GVSTTE ('?TLSB19')
         GOTO 998
      ELSE IF (NUM.LT.0) THEN



         CALL GVSTTI ('?TLSB20',NUM)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSSNP (N,XA,XB,R,V,RMSE,EMAX)















      IMPLICIT      NONE
      INTEGER       I,J,K, N
      REAL          XA(3,N), XB(3,N), R(3,3), V(3), CMA(3), CMB(3),
     +              UMAT(3,3), RMSE, EMAX, XN, XASQ, XBSQ, XNI, T, D2







      RMSE=0.0
      EMAX=0.0
      XN=N
      XASQ=0.0
      XBSQ=0.0
      XNI=1.0/XN
      CALL GVSRT0 (CMA,3)
      CALL GVSRT0 (CMB,3)
      CALL GVSRT0 (UMAT,9)



      DO 125 I=1,3
         DO 120 J=1,N
            DO 110 K=1,3
               UMAT(I,K)=UMAT(I,K)+XA(I,J)*XB(K,J)
  110       CONTINUE
            T=XA(I,J)
            CMA(I)=CMA(I)+T
            XASQ=XASQ+T*T
            T=XB(I,J)
            CMB(I)=CMB(I)+T
            XBSQ=XBSQ+T*T
  120    CONTINUE
  125 CONTINUE



      DO 135 I=1,3
         XASQ=XASQ-CMA(I)*CMA(I)*XNI
         XBSQ=XBSQ-CMB(I)*CMB(I)*XNI
         DO 130 J=1,3
            UMAT(I,J)=(UMAT(I,J)-CMA(I)*CMB(J)*XNI)*XNI
  130    CONTINUE
  135 CONTINUE



      CALL GVSSP2 (UMAT,R)



      DO 150 I=1,3
         T=0.0
         DO 140 J=1,3
            T=T+R(I,J)*CMB(J)
  140    CONTINUE
         V(I)=( CMA(I)-T)*XNI
  150 CONTINUE



      DO 190 I=1,N
         DO 170 J=1,3
            CMB(J)=V(J)
            DO 160 K=1,3
               CMB(J)=CMB(J)+R(J,K)*XB(K,I)
  160       CONTINUE
  170    CONTINUE
         DO 180 J=1,3
            XB(J,I)=CMB(J)
  180    CONTINUE
  190 CONTINUE



      DO 200 I=1,N
         D2=(XA(1,I)-XB(1,I))**2+(XA(2,I)-XB(2,I))**2+
     +    (XA(3,I)-XB(3,I))**2
         RMSE=RMSE+D2
         EMAX=MAX(EMAX,SQRT(D2))
  200 CONTINUE
      RMSE=SQRT(RMSE/FLOAT(N))





      RETURN
      END
      SUBROUTINE GVSSP2 (UMAT,R)








      IMPLICIT      NONE
      INTEGER       ISIG, J
      REAL          UMAT(3,3) ,R(3,3) ,ROOT(3), B1, B2, A(3,3) ,
     +              B(3,3) ,UTR(6), T, B13, B23, B33, S
      EQUIVALENCE   (UTR(1), B(1,1))





      ISIG=1



      DO 10 J=1,3
         T=UMAT(1,1)*UMAT(1,J)+UMAT(2,1)*UMAT(2,J)+UMAT(3,1)*UMAT(3,J)
         UTR(1+(J*J-J)/2)=T
   10 CONTINUE
      DO 20 J=2,3
         T=UMAT(1,2)*UMAT(1,J)+UMAT(2,2)*UMAT(2,J)+UMAT(3,2)*UMAT(3,J)
         UTR(2+(J*J-J)/2)=T
   20 CONTINUE
      DO 30 J=3,3
         T=UMAT(1,3)*UMAT(1,J)+UMAT(2,3)*UMAT(2,J)+UMAT(3,3)*UMAT(3,J)
         UTR(3+(J*J-J)/2)=T
   30 CONTINUE



      CALL GVSSP3 (UTR,A)
      ROOT(1)=UTR(1)
      ROOT(2)=UTR(3)
      ROOT(3)=UTR(6)




      A(1,3)=A(2,1)*A(3,2)-A(3,1)*A(2,2)
      A(2,3)=A(3,1)*A(1,2)-A(1,1)*A(3,2)
      A(3,3)=A(1,1)*A(2,2)-A(2,1)*A(1,2)



      B(1,1)=UMAT(1,1)*A(1,1)+UMAT(1,2)*A(2,1)+UMAT(1,3)*A(3,1)
      B(2,1)=UMAT(2,1)*A(1,1)+UMAT(2,2)*A(2,1)+UMAT(2,3)*A(3,1)
      B(3,1)=UMAT(3,1)*A(1,1)+UMAT(3,2)*A(2,1)+UMAT(3,3)*A(3,1)
      B(1,2)=UMAT(1,1)*A(1,2)+UMAT(1,2)*A(2,2)+UMAT(1,3)*A(3,2)
      B(2,2)=UMAT(2,1)*A(1,2)+UMAT(2,2)*A(2,2)+UMAT(2,3)*A(3,2)
      B(3,2)=UMAT(3,1)*A(1,2)+UMAT(3,2)*A(2,2)+UMAT(3,3)*A(3,2)
      B(1,3)=UMAT(1,1)*A(1,3)+UMAT(1,2)*A(2,3)+UMAT(1,3)*A(3,3)
      B(2,3)=UMAT(2,1)*A(1,3)+UMAT(2,2)*A(2,3)+UMAT(2,3)*A(3,3)
      B(3,3)=UMAT(3,1)*A(1,3)+UMAT(3,2)*A(2,3)+UMAT(3,3)*A(3,3)



      B1=SQRT( B(1,1)*B(1,1)+B(2,1)*B(2,1)+B(3,1)*B(3,1))
      B2=SQRT( B(1,2)*B(1,2)+B(2,2)*B(2,2)+B(3,2)*B(3,2))
      IF (B1 .EQ. 0.0) THEN

         B1=1.0
      END IF
      IF (B2 .EQ. 0.0) THEN

         B2=1.0
      END IF

      B(1,1)=B(1,1)/B1
      B(1,2)=B(1,2)/B2
      B(2,1)=B(2,1)/B1
      B(2,2)=B(2,2)/B2
      B(3,1)=B(3,1)/B1
      B(3,2)=B(3,2)/B2



      B13=B(2,1)*B(3,2)-B(3,1)*B(2,2)
      B23=B(3,1)*B(1,2)-B(1,1)*B(3,2)
      B33=B(1,1)*B(2,2)-B(2,1)*B(1,2)
      S=B13*B(1,3)+B23*B(2,3)+B33*B(3,3)
      IF (S .LT. 0.0) ISIG=-1
      B(1,3)=B13
      B(2,3)=B23
      B(3,3)=B33



      R(1,1)=B(1,1)*A(1,1)+B(1,2)*A(1,2)+B(1,3)*A(1,3)
      R(1,2)=B(1,1)*A(2,1)+B(1,2)*A(2,2)+B(1,3)*A(2,3)
      R(1,3)=B(1,1)*A(3,1)+B(1,2)*A(3,2)+B(1,3)*A(3,3)
      R(2,1)=B(2,1)*A(1,1)+B(2,2)*A(1,2)+B(2,3)*A(1,3)
      R(2,2)=B(2,1)*A(2,1)+B(2,2)*A(2,2)+B(2,3)*A(2,3)
      R(2,3)=B(2,1)*A(3,1)+B(2,2)*A(3,2)+B(2,3)*A(3,3)
      R(3,1)=B(3,1)*A(1,1)+B(3,2)*A(1,2)+B(3,3)*A(1,3)
      R(3,2)=B(3,1)*A(2,1)+B(3,2)*A(2,2)+B(3,3)*A(2,3)
      R(3,3)=B(3,1)*A(3,1)+B(3,2)*A(3,2)+B(3,3)*A(3,3)



      ROOT(1)=SQRT( MAX(ROOT(1),0.0))
      ROOT(2)=SQRT( MAX(ROOT(2),0.0))
      ROOT(3)=SQRT( MAX(ROOT(3),0.0))



      IF (ISIG .LT. 0) ROOT(3)=-ROOT(3)





      RETURN
      END
      SUBROUTINE GVSSP3 (A,R)


























      IMPLICIT      NONE
      INTEGER       IQ, J, IA, I, IND, L, M, MQ, LQ, LM, ILQ, IMQ,
     +              IM, IL, LL, IJ, ILR, IMR, JQ, MM, EXITCNT
      REAL          A(6) ,R(9), ANORM, ANRMX, RANGE, THR, SINX,
     +              SINX2, COSX, COSX2, SINCS, X, Y, GVFSQR







      EXITCNT=0
      RANGE=1.0E-6
      IQ   =-3
      DO 10 J=1,3
         IQ=IQ+3
         IJ=IQ+1
         R(IJ)=0.0
         IF (1.EQ.J) R(IJ)=1.0
         IJ=IQ+2
         R(IJ)=0.0
         IF (2.EQ.J) R(IJ)=1.0
         IJ=IQ+3
         R(IJ)=0.0
         IF (3.EQ.J) R(IJ)=1.0
   10 CONTINUE



      ANORM=0.0
      DO 25 I=1,2
         DO 20 J=I+1,3
            IA=I+(J*J-J)/2
            ANORM=ANORM+A(IA)*A(IA)
   20    CONTINUE
   25 CONTINUE
      IF (ANORM.LE.0.0) GOTO 290
      ANORM=GVFSQR(2.0*ANORM)
      ANRMX=ANORM*RANGE/3.0



      IND=0
      THR=ANORM
  120 THR=THR/3.0
  130 L=1
  140 M=L+1



  150 MQ=(M*M-M)/2
      LQ=(L*L-L)/2
      LM=L+MQ
      IF (ABS(A(LM)).LT.THR) GOTO 220
      IND=1
      LL=L+LQ
      MM=M+MQ
      X=0.5*(A(LL)-A(MM))
      Y=-(A(LM)/GVFSQR(A(LM)*A(LM)+X*X))
      IF (X.LT.0.0) Y=-Y
      SINX=Y/GVFSQR(2.0*(1.0+(GVFSQR(1.0-Y*Y))))
      SINX2=SINX*SINX
      COSX=GVFSQR(1.0-SINX2)
      COSX2=COSX*COSX
      SINCS=SINX*COSX



      ILQ=3*(L-1)
      IMQ=3*(M-1)
      DO 210 I=1,3
         IQ=(I*I-I)/2
         IF (I.NE.L.AND.I.NE.M) THEN
            IF (I.LT.M) THEN
               IM=I+MQ
            ELSE
               IM=M+IQ
            ENDIF
            IF (I.LT.L) THEN
               IL=I+LQ
            ELSE
               IL=L+IQ
            END IF
            X=A(IL)*COSX-A(IM)*SINX
            A(IM)=A(IL)*SINX+A(IM)*COSX
            A(IL)=X
         END IF
         ILR=ILQ+I
         IMR=IMQ+I
         X=R(ILR)*COSX-R(IMR)*SINX
         R(IMR)=R(ILR)*SINX+R(IMR)*COSX
         R(ILR)=X
  210 CONTINUE
      X=2.0*A(LM)*SINCS
      Y=A(LL)*COSX2+A(MM)*SINX2-X
      X=A(LL)*SINX2+A(MM)*COSX2+X
      A(LM)=(A(LL)-A(MM))*SINCS+A(LM)*(COSX2-SINX2)
      A(LL)=Y
      A(MM)=X



  220 EXITCNT=EXITCNT+1
      IF (EXITCNT.GT.1000) GOTO 998
      IF (M.NE.3) THEN
         M=M+1
         GOTO 150
      END IF
      IF (L.NE.(3-1)) THEN
         L=L+1
         GOTO 140
      END IF
      IF (IND.EQ.1) THEN
         IND=0
         GOTO 130
      END IF



      IF (THR.GT.ANRMX) GOTO 120



  290 IQ=-3
      DO 320 I=1,3
         IQ=IQ+3
         LL=I+(I*I-I)/2
         JQ=3*(I-2)
         DO 310 J=I,3
            JQ=JQ+3
            MM=J+(J*J-J)/2
            IF (A(LL).LT.A(MM)) THEN
               X=A(LL)
               A(LL)=A(MM)
               A(MM)=X

               ILR=IQ+1
               IMR=JQ+1
               X=R(ILR)
               R(ILR)=R(IMR)
               R(IMR)=X

               ILR=IQ+2
               IMR=JQ+2
               X=R(ILR)
               R(ILR)=R(IMR)
               R(IMR)=X

               ILR=IQ+3
               IMR=JQ+3
               X=R(ILR)
               R(ILR)=R(IMR)
               R(IMR)=X
            END IF
  310    CONTINUE
  320 CONTINUE



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSSP4 (N,XA,XB,R,V,RMSE,WEIGHT)

















      IMPLICIT      NONE
      INTEGER       N, I, J, K
      REAL          XA(3,N) ,XB(3,N) ,R(3,3) ,V(3) ,CMA(3) ,CMB(3) ,
     +              UMAT(3,3) ,WEIGHT(N), RMSE, XN, XASQ, XBSQ, XNI,
     +              T, GVFDV3







      RMSE=0.0
      XN=FLOAT(N)
      XASQ=0.0
      XBSQ=0.0
      XNI=1.0/XN
      CALL GVSRT0 (CMA,3)
      CALL GVSRT0 (CMB,3)
      CALL GVSRT0 (UMAT,9)
      CALL GVSRT0 (V,3)
      CALL GVSRT0 (R,9)



      DO 125 I=1,3
         DO 120 J=1,N
            DO 110 K=1,3
               UMAT(I,K)=UMAT(I,K)+XA(I,J)*XB(K,J)
  110       CONTINUE
            T=XA(I,J)
            CMA(I)=CMA(I)+T
            XASQ=XASQ+T*T
            T=XB(I,J)
            CMB(I)=CMB(I)+T
            XBSQ=XBSQ+T*T
  120    CONTINUE
  125 CONTINUE



      DO 135 I=1,3
         XASQ=XASQ-CMA(I)*CMA(I)*XNI
         XBSQ=XBSQ-CMB(I)*CMB(I)*XNI
         DO 130 J=1,3
            UMAT(I,J)=(UMAT(I,J)-CMA(I)*CMB(J)*XNI)*XNI
  130    CONTINUE
  135 CONTINUE



      CALL GVSSP2 (UMAT,R)



      DO 150 I=1,3
         T=0.0
         DO 140 J=1,3
            T=T+R(I,J)*CMB(J)
  140    CONTINUE
         V(I)=( CMA(I)-T)*XNI
  150 CONTINUE



      DO 190 I=1,N
         DO 170 J=1,3
            CMB(J)=V(J)
            DO 160 K=1,3
               CMB(J)=CMB(J)+R(J,K)*XB(K,I)
  160       CONTINUE
  170    CONTINUE
         DO 180 J=1,3
            XB(J,I)=CMB(J)
  180    CONTINUE
  190 CONTINUE



      DO 200 I=1,N
         RMSE=RMSE+WEIGHT(I)*(GVFDV3(XA(1,I),XB(1,I))**2)
  200 CONTINUE
      RMSE=SQRT(RMSE/FLOAT(N))





      RETURN
      END
      SUBROUTINE GVSSP5 (MATRIX,EIGENV)










      IMPLICIT      NONE
      INTEGER       MAXEIG,I
      REAL          MATRIX (3,3), EIGENM(3,3), EIGENV(3), VALEIG







      CALL GVSRT0 (EIGENM,9)



      CALL GVSSP2 (MATRIX,EIGENM)



      MAXEIG=1
      VALEIG=MATRIX(1,1)
      IF (MATRIX(2,2).GT.VALEIG) THEN
         MAXEIG=2
         VALEIG=MATRIX(2,2)
      END IF
      IF (MATRIX(3,3).GT.VALEIG) MAXEIG=3



      DO 10 I=1,3
         EIGENV(I)=EIGENM(I,MAXEIG)
   10 CONTINUE





      RETURN
      END
      SUBROUTINE GVSSP6 (N,XA,XB,R,V,RMSE,WEIGHT)



















      IMPLICIT      NONE
      INTEGER       N, I, J, K
      REAL          XA(4,N) ,XB(3,N) ,R(3,3) ,V(3) ,CMA(3) ,CMB(3) ,
     +              UMAT(3,3) ,WEIGHT(N), RMSE, XN, XASQ, XBSQ, XNI,
     +              T, GVFDV3







      RMSE=0.0
      XN=N
      XASQ=0.0
      XBSQ=0.0
      XNI=1.0/XN
      CALL GVSRT0 (CMA,3)
      CALL GVSRT0 (CMB,3)
      CALL GVSRT0 (UMAT,9)



      DO 120 I=1,3
         DO 120 J=1,N
            DO 110 K=1,3
               UMAT(I,K)=UMAT(I,K)+XA(I,J)*XB(K,J)
  110       CONTINUE
            T=XA(I,J)
            CMA(I)=CMA(I)+T
            XASQ=XASQ+T*T
            T=XB(I,J)
            CMB(I)=CMB(I)+T
            XBSQ=XBSQ+T*T
  120 CONTINUE



      DO 135 I=1,3
         XASQ=XASQ-CMA(I)*CMA(I)*XNI
         XBSQ=XBSQ-CMB(I)*CMB(I)*XNI
         DO 130 J=1,3
            UMAT(I,J)=(UMAT(I,J)-CMA(I)*CMB(J)*XNI)*XNI
  130    CONTINUE
  135 CONTINUE



      CALL GVSSP2 (UMAT,R)



      DO 150 I=1,3
         T=0.0
         DO 140 J=1,3
            T=T+R(I,J)*CMB(J)
  140    CONTINUE
         V(I)=( CMA(I)-T)*XNI
  150 CONTINUE



      DO 190 I=1,N
         DO 170 J=1,3
            CMB(J)=V(J)
            DO 160 K=1,3
               CMB(J)=CMB(J)+R(J,K)*XB(K,I)
  160       CONTINUE
  170    CONTINUE
         DO 180 J=1,3
            XB(J,I)=CMB(J)
  180    CONTINUE
  190 CONTINUE



      DO 200 I=1,N
         RMSE=RMSE+WEIGHT(I)*(GVFDV3(XA(1,I),XB(1,I))**2)
  200 CONTINUE
      RMSE=SQRT(RMSE/FLOAT(N))





      RETURN
      END
      SUBROUTINE GVSSPN (N,XA,XB,R,V,RMSE,EMAX)















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       N, J, I
      REAL          XA(3,N) ,XB(3,N) ,R(3,3) ,V(3), CMA(3) ,CMB(3) ,
     +              UMAT(3,3), RMSE, EMAX, XN, XNI, XASQ, XBSQ, T,
     +              ERROR







      RMSE=0.0
      EMAX=0.0
      XN=N
      XNI=1.0/XN
      XASQ=0.0
      XBSQ=0.0
      CMA(1)=0.0
      CMA(2)=0.0
      CMA(3)=0.0
      CMB(1)=0.0
      CMB(2)=0.0
      CMB(3)=0.0
      UMAT(1,1)=0.0
      UMAT(2,1)=0.0
      UMAT(3,1)=0.0
      UMAT(1,2)=0.0
      UMAT(2,2)=0.0
      UMAT(3,2)=0.0
      UMAT(1,3)=0.0
      UMAT(2,3)=0.0
      UMAT(3,3)=0.0



      DO 21 J=1,N
         UMAT(1,1)=UMAT(1,1)+XA(1,J)*XB(1,J)
         UMAT(1,2)=UMAT(1,2)+XA(1,J)*XB(2,J)
         UMAT(1,3)=UMAT(1,3)+XA(1,J)*XB(3,J)
         CMA(1)=CMA(1)+XA(1,J)
         XASQ=XASQ+XA(1,J)**2
         CMB(1)=CMB(1)+XB(1,J)
         XBSQ=XBSQ+XB(1,J)**2
  21  CONTINUE
      DO 22 J=1,N
         UMAT(2,1)=UMAT(2,1)+XA(2,J)*XB(1,J)
         UMAT(2,2)=UMAT(2,2)+XA(2,J)*XB(2,J)
         UMAT(2,3)=UMAT(2,3)+XA(2,J)*XB(3,J)
         CMA(2)=CMA(2)+XA(2,J)
         XASQ=XASQ+XA(2,J)**2
         CMB(2)=CMB(2)+XB(2,J)
         XBSQ=XBSQ+XB(2,J)**2
  22  CONTINUE
      DO 23 J=1,N
         UMAT(3,1)=UMAT(3,1)+XA(3,J)*XB(1,J)
         UMAT(3,2)=UMAT(3,2)+XA(3,J)*XB(2,J)
         UMAT(3,3)=UMAT(3,3)+XA(3,J)*XB(3,J)
         CMA(3)=CMA(3)+XA(3,J)
         XASQ=XASQ+XA(3,J)**2
         CMB(3)=CMB(3)+XB(3,J)
         XBSQ=XBSQ+XB(3,J)**2
  23  CONTINUE



      XASQ=XASQ-CMA(1)*CMA(1)*XNI-CMA(2)*CMA(2)*XNI-CMA(3)*CMA(3)*XNI
      XBSQ=XBSQ-CMB(2)*CMB(2)*XNI-CMB(1)*CMB(1)*XNI-CMB(3)*CMB(3)*XNI

      UMAT(1,1)=(UMAT(1,1)-CMA(1)*CMB(1)*XNI)*XNI
      UMAT(1,2)=(UMAT(1,2)-CMA(1)*CMB(2)*XNI)*XNI
      UMAT(1,3)=(UMAT(1,3)-CMA(1)*CMB(3)*XNI)*XNI

      UMAT(2,1)=(UMAT(2,1)-CMA(2)*CMB(1)*XNI)*XNI
      UMAT(2,2)=(UMAT(2,2)-CMA(2)*CMB(2)*XNI)*XNI
      UMAT(2,3)=(UMAT(2,3)-CMA(2)*CMB(3)*XNI)*XNI

      UMAT(3,1)=(UMAT(3,1)-CMA(3)*CMB(1)*XNI)*XNI
      UMAT(3,2)=(UMAT(3,2)-CMA(3)*CMB(2)*XNI)*XNI
      UMAT(3,3)=(UMAT(3,3)-CMA(3)*CMB(3)*XNI)*XNI



      CALL GVSSP2 (UMAT,R)



      T=R(1,1)*CMB(1)+R(1,2)*CMB(2)+R(1,3)*CMB(3)
      V(1)=( CMA(1)-T)*XNI

      T=R(2,1)*CMB(1)+R(2,2)*CMB(2)+R(2,3)*CMB(3)
      V(2)=( CMA(2)-T)*XNI

      T=R(3,1)*CMB(1)+R(3,2)*CMB(2)+R(3,3)*CMB(3)
      V(3)=( CMA(3)-T)*XNI



      DO 190 I=1,N
         CMB(1)=V(1)+R(1,1)*XB(1,I)+R(1,2)*XB(2,I)+R(1,3)*XB(3,I)
         CMB(2)=V(2)+R(2,1)*XB(1,I)+R(2,2)*XB(2,I)+R(2,3)*XB(3,I)
         CMB(3)=V(3)+R(3,1)*XB(1,I)+R(3,2)*XB(2,I)+R(3,3)*XB(3,I)
         ERROR=(XA(1,I)-CMB(1))**2+
     +         (XA(2,I)-CMB(2))**2+
     +         (XA(3,I)-CMB(3))**2
         RMSE=RMSE+ERROR
         EMAX=MAX(EMAX,ERROR)
  190 CONTINUE
      RMSE=SQRT(RMSE/FLOAT(N))
      EMAX=SQRT(EMAX)



      IF (N.EQ.3.AND.RMSE.GT.0.25.AND.WIFPAR(453).EQ.0) THEN
         CALL GVSSPNS3 (XA,XB,R,V,RMSE,EMAX)
      END IF





      RETURN
      END
      SUBROUTINE GVSSUP (N,XA,XB,R,V,RMSE)















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       N, J, I
      REAL          XA(3,N) ,XB(3,N) ,R(3,3) ,V(3), CMA(3) ,CMB(3) ,
     +              UMAT(3,3), RMSE, XN, XNI, XASQ, XBSQ, T, GVFDV3, 
     +              EMAX







      IF (N.LT.3) THEN
         CALL GVSTTE ('?TLS<3A')
         CALL GVSKIL
         CALL GVSMTU (R,3)
         V(1)=0.0
         V(2)=0.0
         V(3)=0.0
         GOTO 998
      END IF



      RMSE=0.0
      XN=N
      XASQ=0.0
      XBSQ=0.0
      XNI=1.0/XN
      CMA(1)=0.0
      CMA(2)=0.0
      CMA(3)=0.0
      CMB(1)=0.0
      CMB(2)=0.0
      CMB(3)=0.0
      UMAT(1,1)=0.0
      UMAT(2,1)=0.0
      UMAT(3,1)=0.0
      UMAT(1,2)=0.0
      UMAT(2,2)=0.0
      UMAT(3,2)=0.0
      UMAT(1,3)=0.0
      UMAT(2,3)=0.0
      UMAT(3,3)=0.0



      DO 120 I=1,3
         DO 120 J=1,N
            UMAT(I,1)=UMAT(I,1)+XA(I,J)*XB(1,J)
            UMAT(I,2)=UMAT(I,2)+XA(I,J)*XB(2,J)
            UMAT(I,3)=UMAT(I,3)+XA(I,J)*XB(3,J)
            T=XA(I,J)
            CMA(I)=CMA(I)+T
            XASQ=XASQ+T*T
            T=XB(I,J)
            CMB(I)=CMB(I)+T
            XBSQ=XBSQ+T*T
  120 CONTINUE



      DO 135 I=1,3
         XASQ=XASQ-CMA(I)*CMA(I)*XNI
         XBSQ=XBSQ-CMB(I)*CMB(I)*XNI
         UMAT(I,1)=(UMAT(I,1)-CMA(I)*CMB(1)*XNI)*XNI
         UMAT(I,2)=(UMAT(I,2)-CMA(I)*CMB(2)*XNI)*XNI
         UMAT(I,3)=(UMAT(I,3)-CMA(I)*CMB(3)*XNI)*XNI
  135 CONTINUE



      CALL GVSSP2 (UMAT,R)



      DO 150 I=1,3
         T=R(I,1)*CMB(1)+R(I,2)*CMB(2)+R(I,3)*CMB(3)
         V(I)=(CMA(I)-T)*XNI
  150 CONTINUE



      DO 190 I=1,N
         DO 170 J=1,3
            CMB(J)=V(J)+R(J,1)*XB(1,I)+R(J,2)*XB(2,I)+R(J,3)*XB(3,I)
  170    CONTINUE
         XB(1,I)=CMB(1)
         XB(2,I)=CMB(2)
         XB(3,I)=CMB(3)
  190 CONTINUE



      DO 200 I=1,N
         RMSE=RMSE+GVFDV3(XA(1,I),XB(1,I))**2
  200 CONTINUE
      RMSE=SQRT(RMSE/FLOAT(N))



      IF (N.EQ.3.AND.RMSE.GT.0.25.AND.WIFPAR(453).EQ.0) THEN
         CALL GVSSPNS3 (XA,XB,R,V,RMSE,EMAX)
      END IF



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GVSTUP (N,XA,XB,BOOLS,R,V,RMSE)
















      IMPLICIT      NONE
      INTEGER       N, J, I, K
      REAL          XA(3,N) ,XB(3,N) ,R(3,3) ,V(3), CMA(3) ,CMB(3) ,
     +              UMAT(3,3), RMSE, XN, XNI, XASQ, XBSQ, T, GVFDV3
      LOGICAL       BOOLS(N)
      INTEGER       GVFCBT







      RMSE=0.0
      XN=GVFCBT(BOOLS,N)
      XASQ=0.0
      XBSQ=0.0
      XNI=1.0/XN
      CALL GVSRT0 (CMA,3)
      CALL GVSRT0 (CMB,3)
      CALL GVSRT0 (UMAT,9)



      DO 120 I=1,3
         DO 110 J=1,N
            IF (BOOLS(J)) THEN
               DO 100 K=1,3
                  UMAT(I,K)=UMAT(I,K)+XA(I,J)*XB(K,J)
  100          CONTINUE
               T=XA(I,J)
               CMA(I)=CMA(I)+T
               XASQ=XASQ+T*T
               T=XB(I,J)
               CMB(I)=CMB(I)+T
               XBSQ=XBSQ+T*T
            END IF
  110    CONTINUE
  120 CONTINUE



      DO 135 I=1,3
         XASQ=XASQ-CMA(I)*CMA(I)*XNI
         XBSQ=XBSQ-CMB(I)*CMB(I)*XNI
         DO 130 J=1,3
            UMAT(I,J)=(UMAT(I,J)-CMA(I)*CMB(J)*XNI)*XNI
  130    CONTINUE
  135 CONTINUE



      CALL GVSSP2 (UMAT,R)



      DO 150 I=1,3
         T=0.0
         DO 140 J=1,3
            T=T+R(I,J)*CMB(J)
  140    CONTINUE
         V(I)=( CMA(I)-T)*XNI
  150 CONTINUE



      DO 190 I=1,N
         IF (BOOLS(I)) THEN
            DO 170 J=1,3
               CMB(J)=V(J)
               DO 160 K=1,3
                  CMB(J)=CMB(J)+R(J,K)*XB(K,I)
  160          CONTINUE
  170       CONTINUE
            DO 180 J=1,3
               XB(J,I)=CMB(J)
  180       CONTINUE
         END IF
  190 CONTINUE



      DO 200 I=1,N
         IF (BOOLS(I)) RMSE=RMSE+GVFDV3(XA(1,I),XB(1,I))**2
  200 CONTINUE
      RMSE=SQRT(RMSE/XN)





      RETURN
      END
      SUBROUTINE GVSROR (NUM,X,Y,Z,DX,DY,DZ)




















      IMPLICIT      NONE
      INTEGER       I, NUM
      REAL          ANGLEZ, ZMAT(3,3), X(NUM), Y(NUM), Z(NUM), CV(3),
     +              ORG(3), RP(3), GVFRAN, DX, DY, DZ, GVFLNV
      LOGICAL       GVFRIN







      CALL GVSRT0 (ORG,3)



      DO 10 I=1,NUM
         ORG(1)=ORG(1)+X(I)
         ORG(2)=ORG(2)+Y(I)
         ORG(3)=ORG(3)+Z(I)
   10 CONTINUE
      CALL GVSVDI (ORG,NUM,3)



      ANGLEZ=GVFRAN(0.0,6.283)
      CALL GVSMZM (ZMAT,ANGLEZ)



      DO 20 I=1,NUM
         CV(1)=X(I)-ORG(1)
         CV(2)=Y(I)-ORG(2)
         CV(3)=Z(I)-ORG(3)
         CALL GVSMVV (CV,ZMAT)
         X(I)=CV(1)+ORG(1)
         Y(I)=CV(2)+ORG(2)
         Z(I)=CV(3)+ORG(3)
   20 CONTINUE



   30 RP(1)=GVFRAN(-1.0,1.0)
      RP(2)=GVFRAN(-1.0,1.0)
      RP(3)=GVFRAN(-1.0,1.0)
      IF (.NOT.GVFRIN(GVFLNV(RP),0.1,1.0)) GOTO 30



      CALL GVSNM3 (RP)
      RP(1)=RP(1)/2.0
      RP(2)=RP(2)/2.0
      RP(3)=(1.0+RP(3))/2.0



      CALL GVSMGM (ZMAT,RP,3.141592)



      DO 40 I=1,NUM
         CV(1)=X(I)-ORG(1)
         CV(2)=Y(I)-ORG(2)
         CV(3)=Z(I)-ORG(3)
         CALL GVSMVV (CV,ZMAT)
         X(I)=CV(1)+ORG(1)
         Y(I)=CV(2)+ORG(2)
         Z(I)=CV(3)+ORG(3)
   40 CONTINUE



      RP(1)=GVFRAN(-DX,DX)
      RP(2)=GVFRAN(-DY,DY)
      RP(3)=GVFRAN(-DZ,DZ)
      DO 50 I=1,NUM
         X(I)=X(I)+RP(1)
         Y(I)=Y(I)+RP(2)
         Z(I)=Z(I)+RP(3)
   50 CONTINUE




      
      RETURN
      END   
      SUBROUTINE GVSSPNS3 (XAIN,XBIN,RMAT,V,QRMS,EMAX)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       IV1, IV2, IV3, IA, STEP1, STEP2, STEP3, NSTEP
      REAL          XA(3,3), XB(3,3), RMAT(3,3), V(3), V2(3), ANG, QRMS, 
     +              EMAX, TMAT(3,3), BANG, FAC, RAC, QNOW, ENOW,
     +              XAIN(3,3), XBIN(3,3), XA0(3,3), XB0(3,3), GVFDTR,
     +              GVFRAN







      CALL GVSCPR (XA,XAIN,9)
      CALL GVSCPR (XB,XBIN,9)
      IF (WIFPAR(279).GE.1) THEN
         NSTEP=5
      ELSE
         NSTEP=10
      END IF



      V(1)=XA(1,2)-XB(1,2)
      V(2)=XA(2,2)-XB(2,2)
      V(3)=XA(3,2)-XB(3,2)
      XB(1,1)=XB(1,1)+V(1)-XA(1,2)
      XB(2,1)=XB(2,1)+V(2)-XA(2,2)
      XB(3,1)=XB(3,1)+V(3)-XA(3,2)
      XB(1,2)=XB(1,2)+V(1)-XA(1,2)
      XB(2,2)=XB(2,2)+V(2)-XA(2,2)
      XB(3,2)=XB(3,2)+V(3)-XA(3,2)
      XB(1,3)=XB(1,3)+V(1)-XA(1,2)
      XB(2,3)=XB(2,3)+V(2)-XA(2,2)
      XB(3,3)=XB(3,3)+V(3)-XA(3,2)
      XA(1,1)=XA(1,1)-XA(1,2)
      XA(2,1)=XA(2,1)-XA(2,2)
      XA(3,1)=XA(3,1)-XA(3,2)
      XA(1,3)=XA(1,3)-XA(1,2)
      XA(2,3)=XA(2,3)-XA(2,2)
      XA(3,3)=XA(3,3)-XA(3,2)
      XA(1,2)=XA(1,2)-XA(1,2)
      XA(2,2)=XA(2,2)-XA(2,2)
      XA(3,2)=XA(3,2)-XA(3,2)
      CALL GVSCPR (XA0,XA,9)
      CALL GVSCPR (XB0,XB,9)



      CALL GVSCPR (TMAT,RMAT,9)
      V(1)=1.0
      V(2)=0.0
      V(3)=0.0
      BANG=0.0
      QRMS=999.9
      FAC=1.0



      DO 120 STEP1=1,NSTEP
         FAC=FLOAT(STEP1)/FLOAT(NSTEP)
         DO 110 STEP2=1,NSTEP
            FAC=FAC*0.80
            DO 100 IV1=-NSTEP,NSTEP
               V2(1)=V(1)+FAC*FLOAT(IV1)/FLOAT(NSTEP)
               DO 90 IV2=-NSTEP,NSTEP
                  V2(2)=V(2)+FAC*FLOAT(IV2)/FLOAT(NSTEP)
                  DO 80 IV3=-NSTEP,NSTEP
                     V2(3)=V(3)+FAC*FLOAT(IV3)/FLOAT(NSTEP)
                     DO 60 IA=-180,180,10
                        ANG=BANG+GVFDTR(FAC*FLOAT(IA))
                        CALL GVSMGM (TMAT,V2,ANG)
                        CALL GVSSPNSS (XA0,XB0,TMAT,QNOW,ENOW)
                        IF (QNOW.LT.QRMS) THEN
                           QRMS=QNOW
                           EMAX=ENOW
                           CALL GVSCPR (RMAT,TMAT,9)
                           CALL GVSCPR (V,V2,3)
                           BANG=ANG
                           IF (WIFPAR(279).GE.1) THEN
                              IF (QRMS.LT.1.00) GOTO 121
                           ELSE
                              IF (QRMS.LT.0.25) GOTO 121
                           END IF
                           GOTO 110
                        END IF
 60                  CONTINUE
                     DO 70 STEP3=1,2*NSTEP
                        RAC=2.0*FAC/FLOAT(STEP3)
                        V2(1)=V(1)+GVFRAN((-1.0)*RAC,RAC)
                        V2(2)=V(2)+GVFRAN((-1.0)*RAC,RAC)
                        V2(3)=V(3)+GVFRAN((-1.0)*RAC,RAC)
                        ANG=BANG+GVFDTR(GVFRAN((-10.0)*RAC,10.0*RAC))
                        CALL GVSMGM (TMAT,V2,ANG)
                        CALL GVSSPNSS (XA0,XB0,TMAT,QNOW,ENOW)
                        IF (QNOW.LT.QRMS) THEN
                           QRMS=QNOW
                           EMAX=ENOW
                           CALL GVSCPR (RMAT,TMAT,9)
                           CALL GVSCPR (V,V2,3)
                           BANG=ANG
                           IF (QRMS.LT.0.25) THEN
                              GOTO 121
                           END IF
                           GOTO 110
                        END IF
 70                  CONTINUE
 80               CONTINUE
 90            CONTINUE
 100        CONTINUE
 110     CONTINUE
 120  CONTINUE
 121  CONTINUE



      FAC=10.0
      DO 210 STEP3=1,2*NSTEP
         FAC=(-0.77)*FAC
         DO 200 STEP1=1,4
            CALL GVSCPR (V2,V,3)
            ANG=BANG
 130        CONTINUE
            IF (STEP1.EQ.4) THEN
               ANG=ANG+FAC
            ELSE
               V2(STEP1)=V(STEP1)+0.05*FAC
            END IF
            CALL GVSMGM (TMAT,V2,ANG)
            CALL GVSSPNSS (XA0,XB0,TMAT,QNOW,ENOW)
            IF (QNOW.LT.QRMS) THEN
               QRMS=QNOW
               EMAX=ENOW
               CALL GVSCPR (RMAT,TMAT,9)
               CALL GVSCPR (V,V2,3)
               BANG=ANG
               IF (QRMS.LT.0.00001) GOTO 211
               GOTO 130
            END IF
 200     CONTINUE
         DO 205 STEP2=1,NSTEP
            V2(1)=V(1)+GVFRAN((-0.1)*FAC,0.1*FAC)
            V2(2)=V(2)+GVFRAN((-0.1)*FAC,0.1*FAC)
            V2(3)=V(3)+GVFRAN((-0.1)*FAC,0.1*FAC)
            ANG=BANG+GVFDTR(GVFRAN((-5.0)*FAC,5.0*FAC))
            CALL GVSMGM (TMAT,V2,ANG)
            CALL GVSSPNSS (XA0,XB0,TMAT,QNOW,ENOW)
            IF (QNOW.LT.QRMS) THEN
               QRMS=QNOW
               EMAX=ENOW
               CALL GVSCPR (RMAT,TMAT,9)
               CALL GVSCPR (V,V2,3)
               BANG=ANG
               IF (QRMS.LT.0.00001) GOTO 211
               GOTO 210
            END IF
 205     CONTINUE
 210  CONTINUE
 211  CONTINUE




            
      RETURN
      END   
      SUBROUTINE GVSSPNSS (XA,XBIN,RMAT,QRMS,EMAX)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      REAL          XA(3,3), XB(3,3), RMAT(3,3), XBIN(3,3), QRMS, EMAX







      CALL GVSMV3 (XB(1,1),RMAT,XBIN(1,1))
      CALL GVSMV3 (XB(1,2),RMAT,XBIN(1,2))
      CALL GVSMV3 (XB(1,3),RMAT,XBIN(1,3))



      QRMS=(XA(1,1)-XB(1,1))**2+(XA(2,1)-XB(2,1))**2+
     +     (XA(3,1)-XB(3,1))**2+(XA(1,3)-XB(1,3))**2+
     +     (XA(2,3)-XB(2,3))**2+(XA(3,3)-XB(3,3))**2
      QRMS=SQRT(QRMS)/3.0
      EMAX=SQRT(MAX((XA(1,1)-XB(1,1))**2+(XA(2,1)-XB(2,1))**2+
     +              (XA(3,1)-XB(3,1))**2,
     +              (XA(1,3)-XB(1,3))**2+(XA(2,3)-XB(2,3))**2+
     +              (XA(3,3)-XB(3,3))**2))





      RETURN
      END   
