// Standard WHAT IF header for PovRay 3.0 scenes.
// $Id: header.pov 965 1996-12-12 16:44:51Z hooft $
 
background { color rgb <0,0,0> }
 
#declare Center = <0,0,0>
#declare ObjSize = 26
#declare Distance = 0.5*ObjSize
 
#declare VPoint = Center+<0,0,-Distance>
#declare XLight = Center+<-Distance,Distance,-Distance>

sphere { Center, 3*ObjSize
  pigment {
    gradient y
    color_map {
      [0.000 0.002 color rgb <1.0, 0.2, 0.0> 
                   color rgb <1.0, 0.2, 0.0>]
      [0.002 0.200 color rgb <0.8, 0.1, 0.0> 
                   color rgb <0.2, 0.2, 0.3>]
    }
    scale 6*ObjSize
    translate 3*ObjSize
    rotate 50*x
  }
//  pigment {
//    bozo
//    turbulence 0.65
//    octaves 6
//    omega 0.7
//    lambda 2
//    color_map {
//        [0.0 0.1 color rgb <0.85, 0.85, 0.85> 
//                 color rgb <0.75, 0.75, 0.75>]
//        [0.1 0.5 color rgb <0.75, 0.75, 0.75> 
//                 color rgbt <1, 1, 1, 1>]
//        [0.5 1.0 color rgbt <1, 1, 1, 1> 
//                 color rgbt <1, 1, 1, 1>]
//    }
//    scale 0.3
//  }
}

//plane { y, 0
//  pigment { color rgb<0,1,0> }
//  finish { ambient .3 diffuse .7 }
//}
 
camera {
        location VPoint
        look_at  Center
        angle 120
        orthographic
        //aperture 100      // Enable these two lines to use a
        //blur_samples 3    // finite lens opening, with focal blur. DOESNT WORK
}
 
global_settings { ambient_light rgb<1,1,1>
                  assumed_gamma 1.0 }
 
// Enable next 4 lines to create "depth cueing to white".
 
//fog { fog_type 1
//      distance 3*ObjSize
//      colour rgb<0,0,0>
//}
 
// light_source { VPoint color rgb <1,1,1> }
light_source { XLight color rgb <1,1,1> shadowless }
 
#declare VDWfac = 0.3 // Multiply VDW radii with this factor
 
#declare BondRad = 0.25
#declare T_Bond = texture { pigment { color rgb <0.5,0.5,0.5> } }
 
#declare BondRadH = 0.15
#declare T_BondH = texture { T_Bond }
 
#declare HBondRad = 0.15
#declare T_HBond = texture { pigment { color rgb <0.3,0.9,0.2> } }
// Transparency of a HBOND if WHAT IF colors are used
#declare HBondTr = 0.5

#declare Sulphur = sphere {
        <0, 0, 0>, VDWfac*2.0
        texture {
                pigment { color rgb <1,1,0> }
        }
}
 
#declare Hydrogen = sphere {
        <0, 0, 0>, VDWfac*0.7
        texture {
                pigment { color rgb <0.7,0.7,0.7> }
        }
}
 
#declare Carbon = sphere {
        <0, 0, 0>, VDWfac*1.8
        texture {
                pigment { color rgb <0.3,0.3,0.3> }
        }
}
 
#declare Oxygen = sphere {
        <0, 0, 0>, VDWfac*1.4
        texture {
                pigment { color rgb <1,0,0> }
        }
}
 
#declare Nitrogen = sphere {
        <0, 0, 0>, VDWfac*1.7
        texture {
                pigment { color rgb <0,0,1> }
        }
}
 
#declare Metal = sphere {
        <0, 0, 0>, VDWfac*2.2
        texture {
                pigment { color rgb <1.0,0.2,1.0> }
        }
}
 
#declare GenAtom = sphere {
        <0, 0, 0>, VDWfac*2.2
        texture {
                pigment { color rgb <0.3,1.0,0.3> }
        }
}
 
// End of WHAT IF standard header. Molecular scene follows.
