



      SUBROUTINE GRTARR (XFROM,YFROM,ZFROM,XTO,YTO,ZTO,ICOL,IERR)



















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       I, ICOL, IERR, NMGOLD, IGRV
      REAL          ENDN(3), ENDC(3), RMAT(3,3), ANGLE, FACTOR,
     +              XFROM, YFROM, ZFROM, XTO, YTO, ZTO, 
     +              GVFDTR, GVFLNV, TVEC(3)







      IERR=0
      NMGOLD=NUMGRV+1



      ENDN(1)=XFROM
      ENDN(2)=YFROM
      ENDN(3)=ZFROM
      ENDC(1)=XTO
      ENDC(2)=YTO
      ENDC(3)=ZTO
      CALL GVSTV3 (XYZ,ENDC,ENDN)
      FACTOR=MIN(GVFLNV(XYZ)/7.0,0.7)
      CALL GVSCP3 (CV,ENDN,ENDC)
      CALL GVSNM3 (CV)
      CALL GVSVXC (CV,FACTOR,3)



      NUMGRV=NUMGRV+1
      CALL GVSCPR (XMOL(1,NUMGRV),CV,3)
      DO 10 I=1,18
         ANGLE=GVFDTR(20.0)*FLOAT(I)
         CALL GVSMGM (RMAT,XYZ,ANGLE)
         CALL GVSMV3 (TVEC,RMAT,CV)
         CALL GVSCPR (YMOL(1,NUMGRV),TVEC,3)
         IF (I.LT.18) THEN
            NUMGRV=NUMGRV+1
            CALL GVSCPR (XMOL(1,NUMGRV),TVEC,3)
            HUEVAL(NUMGRV)=ICOL
         END IF
   10 CONTINUE
      DO 20 I=1,9
         ANGLE=GVFDTR(40.0)*FLOAT(I)
         CALL GVSMGM (RMAT,XYZ,ANGLE)
         CALL GVSMV3 (TVEC,RMAT,CV)
         CALL GRTLIN (TVEC(1)/2.0,TVEC(2)/2.0,TVEC(3)/2.0,
     +    TVEC(1),TVEC(2),TVEC(3),ICOL,IERR)
   20 CONTINUE



      DO 30 I=1,18
         ANGLE=GVFDTR(20.0)*FLOAT(I)
         CALL GVSMGM (RMAT,XYZ,ANGLE)
         CALL GVSMV3 (TVEC,RMAT,CV)
         CALL GRTLIN (TVEC(1),TVEC(2),TVEC(3),TVEC(1)+0.9*XYZ(1),
     +    TVEC(2)+0.9*XYZ(2),TVEC(3)+0.9*XYZ(3),ICOL,IERR)
   30 CONTINUE



      DO 40 I=1,18
         ANGLE=GVFDTR(20.0)*FLOAT(I)
         CALL GVSMGM (RMAT,XYZ,ANGLE)
         CALL GVSMV3 (TVEC,RMAT,CV)
         CALL GRTLIN (TVEC(1)+0.9*XYZ(1),TVEC(2)+0.9*XYZ(2),
     +    TVEC(3)+0.9*XYZ(3),XYZ(1),XYZ(2),XYZ(3),ICOL,IERR)
   40 CONTINUE



      DO 50 IGRV=NMGOLD,NUMGRV
         CALL GVSAV3 (XMOL(1,IGRV),ENDN)
         CALL GVSAV3 (YMOL(1,IGRV),ENDN)
   50 CONTINUE





      RETURN
      END
      SUBROUTINE GRTBOX (LOW,HGH,MATRIX)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       I, IERR
      REAL          LOW(3), HGH(3), MATRIX(3,3), PNT(3,8)







      PNT(1,1)=LOW(1)
      PNT(2,1)=LOW(2)
      PNT(3,1)=LOW(3)
      PNT(1,2)=LOW(1)
      PNT(2,2)=LOW(2)
      PNT(3,2)=HGH(3)
      PNT(1,3)=LOW(1)
      PNT(2,3)=HGH(2)
      PNT(3,3)=HGH(3)
      PNT(1,4)=LOW(1)
      PNT(2,4)=HGH(2)
      PNT(3,4)=LOW(3)
      PNT(1,5)=HGH(1)
      PNT(2,5)=LOW(2)
      PNT(3,5)=LOW(3)
      PNT(1,6)=HGH(1)
      PNT(2,6)=LOW(2)
      PNT(3,6)=HGH(3)
      PNT(1,7)=HGH(1)
      PNT(2,7)=HGH(2)
      PNT(3,7)=HGH(3)
      PNT(1,8)=HGH(1)
      PNT(2,8)=HGH(2)
      PNT(3,8)=LOW(3)



      DO 10 I=1,8
         CALL GVSMVV (PNT(1,I),MATRIX)
 10   CONTINUE



      CALL GRTLIN (PNT(1,1),PNT(2,1),PNT(3,1), 
     + PNT(1,2),PNT(2,2),PNT(3,2), 120,IERR)
      CALL GRTLIN (PNT(1,2),PNT(2,2),PNT(3,2), 
     + PNT(1,3),PNT(2,3),PNT(3,3), 120,IERR)
      CALL GRTLIN (PNT(1,3),PNT(2,3),PNT(3,3), 
     + PNT(1,4),PNT(2,4),PNT(3,4), 120,IERR)
      CALL GRTLIN (PNT(1,4),PNT(2,4),PNT(3,4), 
     + PNT(1,1),PNT(2,1),PNT(3,1), 120,IERR)
      CALL GRTLIN (PNT(1,1),PNT(2,1),PNT(3,1), 
     + PNT(1,5),PNT(2,5),PNT(3,5), 120,IERR)
      CALL GRTLIN (PNT(1,2),PNT(2,2),PNT(3,2), 
     + PNT(1,6),PNT(2,6),PNT(3,6), 120,IERR)
      CALL GRTLIN (PNT(1,3),PNT(2,3),PNT(3,3), 
     + PNT(1,7),PNT(2,7),PNT(3,7), 120,IERR)
      CALL GRTLIN (PNT(1,4),PNT(2,4),PNT(3,4), 
     + PNT(1,8),PNT(2,8),PNT(3,8), 120,IERR)
      CALL GRTLIN (PNT(1,5),PNT(2,5),PNT(3,5), 
     + PNT(1,6),PNT(2,6),PNT(3,6), 120,IERR)
      CALL GRTLIN (PNT(1,6),PNT(2,6),PNT(3,6), 
     + PNT(1,7),PNT(2,7),PNT(3,7), 120,IERR)
      CALL GRTLIN (PNT(1,7),PNT(2,7),PNT(3,7), 
     + PNT(1,8),PNT(2,8),PNT(3,8), 120,IERR)
      CALL GRTLIN (PNT(1,8),PNT(2,8),PNT(3,8), 
     + PNT(1,5),PNT(2,5),PNT(3,5), 120,IERR)





      RETURN
      END   
      SUBROUTINE GRTCIR (XCEN,YCEN,ZCEN,XN,YN,ZN,RADIUS,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       I, ICOL, IERR
      REAL          RMAT(3,3), ANGLE, 
     +              XCEN, YCEN, ZCEN, XN, YN, ZN, RADIUS, SPOKE(3),
     +              GVFDTR, NORMAL(3), CENTR(3), TVEC(3)







      IERR=0
      NORMAL(1)=XN
      NORMAL(2)=YN
      NORMAL(3)=ZN
      CENTR(1)=XCEN
      CENTR(2)=YCEN
      CENTR(3)=ZCEN
      CALL GVSCP3 (SPOKE,NORMAL,CENTR)
      CALL GVSNM3 (SPOKE)
      CALL GVSVXC (SPOKE,RADIUS,3)



      NUMGRV=NUMGRV+1
      XMOL(1,NUMGRV)=XCEN+SPOKE(1)
      XMOL(2,NUMGRV)=YCEN+SPOKE(2)
      XMOL(3,NUMGRV)=ZCEN+SPOKE(3)



      DO 10 I=1,36
         ANGLE=GVFDTR(10.0)*FLOAT(I)
         CALL GVSMGM (RMAT,NORMAL,ANGLE)
         CALL GVSMV3 (TVEC,RMAT,SPOKE)
         CALL GVSAV3 (TVEC,CENTR)
         CALL GVSCPR (YMOL(1,NUMGRV),TVEC,3)
         HUEVAL(NUMGRV)=ICOL
         IF (I.LT.36) THEN
            NUMGRV=NUMGRV+1
            CALL GVSCPR (XMOL(1,NUMGRV),TVEC,3)
         END IF
   10 CONTINUE





      RETURN
      END
      SUBROUTINE GRTWHL (XCEN,YCEN,ZCEN,XN,YN,ZN,RAD1,RAD2,ICOL,IERR)

















      IMPLICIT      NONE
      INTEGER       I, ICOL, IERR
      REAL          XCEN, YCEN, ZCEN, XN, YN, ZN, RADIUS, RAD1, RAD2







      IF (RAD2.LT.RAD1) CALL GVSWAP (RAD1,RAD2)



      DO 10 I=0,10
         RADIUS=RAD1+FLOAT(I)*(RAD2-RAD1)/10.0
         CALL GRTCIR (XCEN,YCEN,ZCEN,XN,YN,ZN,RADIUS,ICOL,IERR)
   10 CONTINUE





      RETURN
      END
      SUBROUTINE GRTCEN (IERR)





















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR







      IERR=0



      TX=0.0
      TY=0.0
      TZ=0.0
      CENTRX=ACONVC(1)
      CENTRY=ACONVC(2)
      CENTRZ=ACONVC(3)





      RETURN
      END
      SUBROUTINE GRTCON (X1,Y1,Z1,X2,Y2,Z2,ANGLE,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, I
      REAL          X1, Y1, Z1, X2, Y2, Z2, ANGLE, GVFLNV, POINT(3),
     +              BLUNT(3), NORMAL(3), REALV(3), LENGTH, GVFDTR, 
     +              MAT36(3,3), MATCON(3,3)







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF
      IF (ANGLE.GT.80.0) THEN
         CALL GVSTTE ('?GRTB08')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      POINT(1)=X1
      POINT(2)=Y1
      POINT(3)=Z1
      BLUNT(1)=X2
      BLUNT(2)=Y2
      BLUNT(3)=Z2
      CALL GVSTV3 (REALV,BLUNT,POINT)
      LENGTH=GVFLNV(REALV)
      CALL GVSNM3 (REALV)
      CALL GVSVXC (REALV,LENGTH/COS(GVFDTR(ANGLE)),3)
      CALL GVSAOR (NORMAL,REALV,1.0)



      CALL GVSMGM (MAT36,REALV,GVFDTR(10.0))
      CALL GVSMGM (MATCON,NORMAL,GVFDTR(ANGLE))
      CALL GVSMVV (REALV,MATCON)



      DO 10 I=1,36



         IF (I.EQ.1) THEN
            CALL GRTLIN (POINT(1),POINT(2),POINT(3),REALV(1)+POINT(1),
     +       REALV(2)+POINT(2),REALV(3)+POINT(3),ICOL,IERR)
         ELSE
            CALL GVSCPR (NORMAL,YMOL(1,NUMGRV),3)
            CALL GRTLIN (POINT(1),POINT(2),POINT(3),NORMAL(1),
     +       NORMAL(2),NORMAL(3),ICOL,IERR)
         END IF



         CALL GVSCPR (NORMAL,YMOL(1,NUMGRV),3)
         CALL GVSMVV (REALV,MAT36)
         CALL GRTLIN (NORMAL(1),NORMAL(2),NORMAL(3),REALV(1)+POINT(1),
     +    REALV(2)+POINT(2),REALV(3)+POINT(3),ICOL,IERR)
   10 CONTINUE



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTCRS (XPOS,YPOS,ZPOS,SIZE,ICOL,IERR)


















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL
      REAL          XPOS, YPOS, ZPOS, SIZE







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      CALL GRTLIN (XPOS-SIZE,YPOS,ZPOS,XPOS+SIZE,YPOS,ZPOS,ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS-SIZE,ZPOS,XPOS,YPOS+SIZE,ZPOS,ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS,ZPOS-SIZE,XPOS,YPOS,ZPOS+SIZE,ICOL,IERR)



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTORS (XPOS,YPOS,ZPOS,SIZE,ICOL,IERR)


















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL
      REAL          XPOS, YPOS, ZPOS, SIZE, DIZE







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      CALL GRTLIN (XPOS-SIZE,YPOS,ZPOS,XPOS+SIZE,YPOS,ZPOS,ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS-SIZE,ZPOS,XPOS,YPOS+SIZE,ZPOS,ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS,ZPOS-SIZE,XPOS,YPOS,ZPOS+SIZE,ICOL,IERR)
      DIZE=0.577*SIZE
      CALL GRTLIN (XPOS+DIZE,YPOS+DIZE,ZPOS+DIZE,XPOS-SIZE,YPOS-DIZE,
     + ZPOS-DIZE,ICOL,IERR)
      CALL GRTLIN (XPOS-DIZE,YPOS+DIZE,ZPOS+DIZE,XPOS+SIZE,YPOS-DIZE,
     + ZPOS-DIZE,ICOL,IERR)
      CALL GRTLIN (XPOS+DIZE,YPOS+DIZE,ZPOS-DIZE,XPOS-SIZE,YPOS-DIZE,
     + ZPOS+DIZE,ICOL,IERR)
      CALL GRTLIN (XPOS-DIZE,YPOS+DIZE,ZPOS-DIZE,XPOS+SIZE,YPOS-DIZE,
     + ZPOS+DIZE,ICOL,IERR)



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTDRS (XPOS,YPOS,ZPOS,SIZE,ICOL,IERR)


















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL
      REAL          XPOS, YPOS, ZPOS, SIZE







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      CALL GRTLIN (XPOS-SIZE,YPOS-SIZE,ZPOS,XPOS+SIZE,YPOS+SIZE,ZPOS,
     + ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS-SIZE,ZPOS-SIZE,XPOS,YPOS+SIZE,ZPOS+SIZE,
     + ICOL,IERR)
      CALL GRTLIN (XPOS,YPOS-SIZE,ZPOS-SIZE,XPOS,YPOS+SIZE,ZPOS+SIZE,
     + ICOL,IERR)



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTPLS (XPOS,YPOS,ZPOS,ITYPE,INSIZE,ICOL,IERR)



















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, ITYPE
      REAL          XPOS, YPOS, ZPOS, SIZE, INSIZE







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      IF (ITYPE.EQ.1) THEN
         SIZE=INSIZE
         CALL GRTLIN (XPOS-SIZE,YPOS,ZPOS,XPOS+SIZE,YPOS,ZPOS,
     +    ICOL,IERR)
         CALL GRTLIN (XPOS,YPOS-SIZE,ZPOS,XPOS,YPOS+SIZE,ZPOS,
     +    ICOL,IERR)



      ELSE IF (ITYPE.EQ.2) THEN
         SIZE=0.707*INSIZE
         CALL GRTLIN (XPOS-SIZE,YPOS-SIZE,ZPOS,XPOS+SIZE,
     +    YPOS+SIZE,ZPOS,ICOL,IERR)
         CALL GRTLIN (XPOS+SIZE,YPOS-SIZE,ZPOS,XPOS-SIZE,
     +    YPOS+SIZE,ZPOS,ICOL,IERR)



      ELSE IF (ITYPE.EQ.3) THEN
         SIZE=0.707*INSIZE
         CALL GRTLIN (XPOS-SIZE,YPOS-SIZE,ZPOS,XPOS+SIZE,
     +    YPOS-SIZE,ZPOS,ICOL,IERR)
         CALL GRTLIN (XPOS+SIZE,YPOS-SIZE,ZPOS,XPOS+SIZE,
     +    YPOS+SIZE,ZPOS,ICOL,IERR)
         CALL GRTLIN (XPOS+SIZE,YPOS+SIZE,ZPOS,XPOS-SIZE,
     +    YPOS+SIZE,ZPOS,ICOL,IERR)
         CALL GRTLIN (XPOS-SIZE,YPOS+SIZE,ZPOS,XPOS-SIZE,
     +    YPOS-SIZE,ZPOS,ICOL,IERR)
      ELSE
         CALL GVSTTB ('?M1226')
      END IF



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTDOT (X1,Y1,Z1,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       ICOL, IERR, ICOLM
      REAL          X1, Y1, Z1







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0
      ICOLM=MOD(ICOL+36000,360)



      NUMGRV=NUMGRV+1
      XMOL(1,NUMGRV)=X1
      XMOL(2,NUMGRV)=Y1
      XMOL(3,NUMGRV)=Z1
      HUEVAL(NUMGRV)=ICOLM



  998 CONTINUE

      
      RETURN
      END
      SUBROUTINE GRTDSH (X1,Y1,Z1,X2,Y2,Z2,ICOL,ISTEP,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC' 
      INTEGER       IERR, ISTEP, ICOL, LOCSTP, IVEC
      REAL          VECTOR(3), X1, Y1, Z1, X2, Y2, Z2
      LOGICAL       GVFIBN







      IERR=0



      IF (NUMGRV.GE.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF
      IF (.NOT.GVFIBN(ISTEP,1,250)) THEN
         CALL GVSTTI ('?GRTB05',ISTEP)
         IERR=1
         GOTO 998
      END IF



      LOCSTP=ISTEP+1-MOD(ISTEP,4)



      VECTOR(1)=(X2-X1)/FLOAT(LOCSTP)
      VECTOR(2)=(Y2-Y1)/FLOAT(LOCSTP)
      VECTOR(3)=(Z2-Z1)/FLOAT(LOCSTP)



      DO 10 IVEC=1,LOCSTP,2
         CALL GRTLIN (X1+(IVEC-1)*VECTOR(1),Y1+(IVEC-1)*VECTOR(2),
     +    Z1+(IVEC-1)*VECTOR(3),X1+IVEC*VECTOR(1),
     +    Y1+IVEC*VECTOR(2),Z1+IVEC*VECTOR(3),ICOL,IERR)
   10 CONTINUE



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRT_H_DSH (V1,V2,ICOL,ISTEP)

















      IMPLICIT      NONE
      INTEGER       IVEC, ISTEP, LOCSTP, IERR, ICOL
      REAL          MID(3), VECTOR(3), V1(3), V2(3)







      LOCSTP=ISTEP+1-MOD(ISTEP,4)



      MID(1)=(V1(1)+V2(1))/2.0
      MID(2)=(V1(2)+V2(2))/2.0
      MID(3)=(V1(3)+V2(3))/2.0
      VECTOR(1)=(V2(1)-V1(1))/FLOAT(LOCSTP)
      VECTOR(2)=(V2(2)-V1(2))/FLOAT(LOCSTP)
      VECTOR(3)=(V2(3)-V1(3))/FLOAT(LOCSTP)



      DO 10 IVEC=1,LOCSTP/2,2
         CALL GRTLIN (V1(1)+(IVEC-1)*VECTOR(1),
     +                V1(2)+(IVEC-1)*VECTOR(2),
     +                V1(3)+(IVEC-1)*VECTOR(3),
     +                V1(1)+IVEC*VECTOR(1),
     +                V1(2)+IVEC*VECTOR(2),
     +                V1(3)+IVEC*VECTOR(3),ICOL,IERR)
   10 CONTINUE



      CALL GRTLIN (MID(1)-0.5*VECTOR(1),MID(2)-0.5*VECTOR(2),
     + MID(3)-0.5*VECTOR(3),MID(1),MID(2),MID(3),ICOL,IERR)





      RETURN
      END
      SUBROUTINE GRTDTS (XD,YD,ZD,RADIUS,ICOL,NUMDOT,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       NUMDOT, ICOL, IQA, IQB, IQC,
     +              JJ, K, KGRV, IERR, NKO, I
      REAL          XB, YB, PH, ST, CT, XD, YD, ZD, RADIUS, GVFMPI,
     +              GVFSQR
      LOGICAL       GVFIBN







      IF (.NOT.GVFIBN(NUMDOT,0,4)) THEN
         CALL GVSTTI ('?GRTB06',NUMDOT)
         GOTO 998
      END IF
      IF (NUMGRV.GE.MAXVEC) THEN
         CALL GVSTTE ('?GRTB07')
         GOTO 998
      END IF



      IERR=0









      NKO=10+NUMDOT
      IQA=0
      IQB=1
      DO 10 I=1,NKO
         IQC=IQA+IQB
         IQA=IQB
         IQB=IQC
   10 CONTINUE



      JJ=0
      DO 20 K=1,IQB
         KGRV=NUMGRV+K
         XB=FLOAT(K)/IQB
         JJ=JJ+IQA
         IF(JJ.GT.IQB)JJ=JJ-IQB
         YB=FLOAT(JJ)/IQB
         PH=GVFMPI(2.0*YB)
         CT=1.-2.*XB
         ST=GVFSQR(1.-CT*CT)
         IF (KGRV.LE.MAXVEC) THEN
            XMOL(1,KGRV)=RADIUS*ST*COS(PH)+XD
            XMOL(2,KGRV)=RADIUS*ST*SIN(PH)+YD
            XMOL(3,KGRV)=RADIUS*CT+ZD
            HUEVAL(KGRV)=ICOL
         ELSE
            CALL GVSTTE ('?GRTB07')
            GOTO 998
         END IF
   20 CONTINUE
      NUMGRV=NUMGRV+IQB



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTFRO (ROTMAT,IERR)

















      IMPLICIT      NONE
      INCLUDE       'MOVOBJ.INC'
      INTEGER       IERR
      REAL          ROTMAT(3,3), TMAT(3,3), ANGLES(3), GVFDTR







      IERR=0
      CALL GVSRT0 (ANGLES,3)
      CALL GVSRT0 (ROTMAT,9)



      CALL GVSMXM (ROTMAT,GVFDTR(DXFBRT))
      CALL GVSMYM (TMAT,GVFDTR(DYFBRT))
      CALL GVSNX3 (ROTMAT,TMAT)
      CALL GVSMZM (TMAT,GVFDTR(DZFBRT))
      CALL GVSNX3 (ROTMAT,TMAT)



      CALL GVSREN (ROTMAT)





      RETURN
      END
      SUBROUTINE GRTFTR (TRANS,IERR)

















      IMPLICIT      NONE
      INCLUDE       'MOVOBJ.INC'
      INTEGER       IERR
      REAL          TRANS(3)







      IERR=0



      TRANS(1)=TXFBRT
      TRANS(2)=TYFBRT
      TRANS(3)=TZFBRT





      RETURN
      END
      SUBROUTINE GRTGCE (CENTER,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          CENTER(3)







      IERR=0
      CENTER(1)=-CENTRX
      CENTER(2)=-CENTRY
      CENTER(3)=-CENTRZ





      RETURN
      END
      SUBROUTINE GRTGRO (ROTMAT,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          ROTMAT(3,3)







      IERR=0



      CALL GVSCPR (ROTMAT,PCMAT,9)





      RETURN
      END
      SUBROUTINE GRTGSC (SCALE,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          SCALE







      IERR=0
      SCALE=SCVAL





      RETURN
      END
      SUBROUTINE GRTSSC (SCALE,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          SCALE







      IERR=0
      SCVAL=SCALE





      RETURN
      END
      SUBROUTINE GRTGSL (SLAB,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          SLAB







      IERR=0
      SLAB=SLABIR





      RETURN
      END
      SUBROUTINE GRTGTR (TRANS,IERR)

















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR
      REAL          TRANS(3)







      IERR=0
      TRANS(1)=TX
      TRANS(2)=TY
      TRANS(3)=TZ





      RETURN
      END
      SUBROUTINE GRTTCN (C1,C2,C3,X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,
     + RADIUS,NUMDOT,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, IQA, IQB, JJ, K, I, NKO, IQC, NUMDOT
      REAL          X1, Y1, Z1, X2, Y2, Z2, GVFDP3, XB, 
     +              YB, PH, ST, CT, GVFMPI, C(3), P1(3), P2(3),
     +              P3(3), T1(3), T2(3), N1(3), N2(3), N3(3),
     +              C1, C2, C3, X3, Y3, Z3, RADIUS, DP, GVFSQR







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      C(1)=C1
      C(2)=C2
      C(3)=C3
      P1(1)=X1
      P1(2)=Y1
      P1(3)=Z1
      P2(1)=X2
      P2(2)=Y2
      P2(3)=Z2
      P3(1)=X3
      P3(2)=Y3
      P3(3)=Z3
      CALL GVSTV3 (T1,P1,C)
      CALL GVSTV3 (T2,P2,C)
      CALL GVSCP3 (N1,T1,T2)
      CALL GVSTV3 (T1,P2,C)
      CALL GVSTV3 (T2,P3,C)
      CALL GVSCP3 (N2,T1,T2)
      CALL GVSTV3 (T1,P3,C)
      CALL GVSTV3 (T2,P1,C)
      CALL GVSCP3 (N3,T1,T2)









      NKO=10+NUMDOT
      IQA=0
      IQB=1
      DO 10 I=1,NKO
         IQC=IQA+IQB
         IQA=IQB
         IQB=IQC
   10 CONTINUE



      JJ=0
      DO 20 K=1,IQB
         XB=FLOAT(K)/IQB
         JJ=JJ+IQA
         IF (JJ.GT.IQB) JJ=JJ-IQB
         YB=FLOAT(JJ)/IQB
         PH=GVFMPI(2.0*YB)
         CT=1.-2.*XB
         ST=GVFSQR(1.0-CT*CT)
         IF (NUMGRV.LE.MAXVEC-10) THEN
            T1(1)=RADIUS*ST*COS(PH)
            T1(2)=RADIUS*ST*SIN(PH)
            T1(3)=RADIUS*CT
            DP=GVFDP3(N1,T1)
            IF (DP.LT.0) GOTO 20
            DP=GVFDP3(N2,T1)
            IF (DP.LT.0) GOTO 20
            DP=GVFDP3(N3,T1)
            IF (DP.LT.0) GOTO 20
            CALL GRTDOT (T1(1)+C1,T1(2)+C2,T1(3)+C3,ICOL,IERR)
         ELSE
            CALL GVSTTE ('?GRTB07')
            IERR=1
            GOTO 999
         END IF
   20 CONTINUE
      GOTO 998



  999 CONTINUE
      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTVCN (C1,C2,C3,X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,
     + X4,Y4,Z4,RADIUS,NUMDOT,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, IQA, IQB, JJ, K, I, NKO, IQC, NUMDOT
      REAL          X1, Y1, Z1, X2, Y2, Z2, GVFDP3, XB, 
     +              YB, PH, ST, CT, GVFMPI, C(3), P1(3), P2(3),
     +              P3(3), P4(3), T1(3), T2(3), N1(3), N2(3), N3(3),
     +              N4(3), C1, C2, C3, X3, Y3, Z3, X4, Y4, Z4, 
     +              RADIUS, DP, GVFSQR







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      C(1)=C1
      C(2)=C2
      C(3)=C3
      P1(1)=X1
      P1(2)=Y1
      P1(3)=Z1
      P2(1)=X2
      P2(2)=Y2
      P2(3)=Z2
      P3(1)=X3
      P3(2)=Y3
      P3(3)=Z3
      P4(1)=X4
      P4(2)=Y4
      P4(3)=Z4



      CALL GVSTV3 (T1,P1,C)
      CALL GVSTV3 (T2,P2,C)
      CALL GVSCP3 (N1,T1,T2)

      CALL GVSTV3 (T1,P2,C)
      CALL GVSTV3 (T2,P3,C)
      CALL GVSCP3 (N2,T1,T2)

      CALL GVSTV3 (T1,P3,C)
      CALL GVSTV3 (T2,P4,C)
      CALL GVSCP3 (N3,T1,T2)

      CALL GVSTV3 (T1,P4,C)
      CALL GVSTV3 (T2,P1,C)
      CALL GVSCP3 (N4,T1,T2)









      NKO=10+NUMDOT
      IQA=0
      IQB=1
      DO 10 I=1,NKO
         IQC=IQA+IQB
         IQA=IQB
         IQB=IQC
   10 CONTINUE



      JJ=0
      DO 20 K=1,IQB
         XB=FLOAT(K)/IQB
         JJ=JJ+IQA
         IF (JJ.GT.IQB) JJ=JJ-IQB
         YB=FLOAT(JJ)/IQB
         PH=GVFMPI(2.0*YB)
         CT=1.0-2.0*XB
         ST=GVFSQR(1.0-CT*CT)
         IF (NUMGRV.LE.MAXVEC-10) THEN
            T1(1)=RADIUS*ST*COS(PH)
            T1(2)=RADIUS*ST*SIN(PH)
            T1(3)=RADIUS*CT
            DP=GVFDP3(N1,T1)
            IF (DP.LT.0) GOTO 20
            DP=GVFDP3(N2,T1)
            IF (DP.LT.0) GOTO 20
            DP=GVFDP3(N3,T1)
            IF (DP.LT.0) GOTO 20
            DP=GVFDP3(N4,T1)
            IF (DP.LT.0) GOTO 20
            CALL GRTDOT (T1(1)+C1,T1(2)+C2,T1(3)+C3,ICOL,IERR)
         ELSE
            CALL GVSTTE ('?GRTB07')
            IERR=1
            GOTO 999
         END IF
   20 CONTINUE
      GOTO 998



  999 CONTINUE
      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTHAT (X1,Y1,Z1,X2,Y2,Z2,ANGLE,NUMDOT,ICOL,IERR)


















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, IQA, IQB, JJ, K, I, NKO, IQC, NUMDOT
      REAL          X1, Y1, Z1, X2, Y2, Z2, ANGLE, GVFLNV, 
     +              NORMAL(3), LENGTH, GVFDTR, N4, GVFDP3, XB, 
     +              YB, PH, ST, CT, GVFMPI, GVFSQR







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF
      IF (ANGLE.GT.80.0) THEN
         CALL GVSTTE ('?GRTB08')
         IERR=1
         GOTO 998
      END IF



      IERR=0



      NORMAL(1)=X1-X2
      NORMAL(2)=Y1-Z2
      NORMAL(3)=Y1-Z2
      LENGTH=GVFLNV(NORMAL)/COS(GVFDTR(ANGLE))



      N4=NORMAL(1)*X2+NORMAL(2)*Y2+NORMAL(3)*Z2









      NKO=10+NUMDOT
      IQA=0
      IQB=1
      DO 10 I=1,NKO
         IQC=IQA+IQB
         IQA=IQB
         IQB=IQC
   10 CONTINUE



      JJ=0
      DO 20 K=1,IQB
         NUMGRV=NUMGRV+1
         XB=FLOAT(K)/IQB
         JJ=JJ+IQA
         IF (JJ.GT.IQB) JJ=JJ-IQB
         YB=FLOAT(JJ)/IQB
         PH=GVFMPI(2.0*YB)
         CT=1.-2.*XB
         ST=GVFSQR(1.0-CT*CT)
         IF (NUMGRV.LE.MAXVEC-10) THEN
            XMOL(1,NUMGRV)=LENGTH*ST*COS(PH)+X1
            XMOL(2,NUMGRV)=LENGTH*ST*SIN(PH)+Y1
            XMOL(3,NUMGRV)=LENGTH*CT+Z1
            HUEVAL(NUMGRV)=ICOL
            IF (GVFDP3(NORMAL,XMOL(1,NUMGRV)).GT.N4) 
     +       NUMGRV=NUMGRV-1
         ELSE
            CALL GVSTTE ('?GRTB07')
            IERR=1
            GOTO 999
         END IF
   20 CONTINUE
      GOTO 998



  999 CONTINUE
      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



  998 CONTINUE


      RETURN
      END

      SUBROUTINE GRTLIN (X1,Y1,Z1,X2,Y2,Z2,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       ICOL, IERR, ICOLM
      REAL          X1, Y1, Z1, X2, Y2, Z2







      IERR=0
      ICOLM=MOD(ICOL+36000,360)



      IF (NUMGRV.GE.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      NUMGRV=NUMGRV+1
      XMOL(1,NUMGRV)=X1
      XMOL(2,NUMGRV)=Y1
      XMOL(3,NUMGRV)=Z1
      YMOL(1,NUMGRV)=X2
      YMOL(2,NUMGRV)=Y2
      YMOL(3,NUMGRV)=Z2
      HUEVAL(NUMGRV)=ICOLM



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTLWI (INWIDTH)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'JUNIOR.INC'
      INTEGER       I, GVFFFI, ISAVE, INWIDTH
      LOGICAL       GRAPON


      RETURN
      END
      SUBROUTINE GRTMES (TEXT,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'IRIGRA.INC'
      CHARACTER*(*) TEXT
      CHARACTER*80  LOCLIN
      INTEGER       GVFLEN, LENTXT, I, IERR, LENTOP







      IERR=0
      CALL GVSCTB (LOCLIN,80)
      LENTXT=GVFLEN(TEXT)
      LENTXT=MAX(1,LENTXT)



      LENTOP=GVFLEN(TOPTXT)
      LENTOP=MAX(1,LENTOP)
      IF (LENTXT.EQ.LENTOP.AND.TEXT(1:LENTXT).EQ.TOPTXT(1:LENTOP))
     + GOTO 998



      CALL GVSCTB (LOCLIN,80)
      IF (GVFLEN(TEXT).GT.0) THEN
         DO 10 I=1,MIN(80,GVFLEN(TEXT))
            LOCLIN(I:I)=TEXT(I:I)
   10    CONTINUE
      END IF
      IF (LOCLIN(1:1).EQ.'?') CALL GETTEXT (LOCLIN)
      LENTXT=GVFLEN(LOCLIN)
      CALL GVSCTB (TOPTXT,22)
      IF (LENTXT.GT.0) CALL GVSSTX (TOPTXT(1:MIN(22,LENTXT)),
     + LOCLIN(1:MIN(22,LENTXT)))
      WIFPAR(62)=1
      CALL IRI000



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTMTR (TRANS,IERR)

















      IMPLICIT      NONE
      INCLUDE       'MOVOBJ.INC'
      REAL          TRANS(3)
      INTEGER       IERR







      IERR=0



      TRANS(1)=-TXFBRT
      TRANS(2)=-TYFBRT
      TRANS(3)=-TZFBRT





      RETURN
      END
      SUBROUTINE GRTOPW (WINTYP,ONOFF,IERR)


















      IMPLICIT      NONE
      CHARACTER*(*) WINTYP
      LOGICAL       ONOFF
      INTEGER       IERR







      IERR=0



      IF (WINTYP(1:3).EQ.'GRA'.OR.WINTYP(1:3).EQ.'gra') THEN
         IF (ONOFF) THEN

         ELSE



            CALL FULLSTOP
         END IF
      END IF





      RETURN
      END
      SUBROUTINE GRTFPF 


















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR












      CALL GVSODF (66,.TRUE.,'PICK2.IDX','UNKNOWN',8,'?PIC-OE',IERR)



      INDPCK2=0









      RETURN
      END
      SUBROUTINE GRTMPF (NUMUNT,NEWTYP)
































      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       NUMUNT, NEWTYP, IERR







      CALL GVSODF (NUMUNT,.TRUE.,'PICK.IDX','UNKNOWN',6,'?PIC-OE',IERR)



      INDPCK=0
      INDTYP=NEWTYP





      RETURN
      END
      SUBROUTINE GRTPPP (IP,JP,KP,XPOS,YPOS,ZPOS,IERR)


















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INTEGER       IERR, IP, JP, KP
      REAL          XPOS, YPOS, ZPOS
      LOGICAL       GVFFOP







      IERR=0



      IF (.NOT.GVFFOP(19)) GOTO 998



      INDPCK=INDPCK+1
      WRITE (19,REC=INDPCK,ERR=999) IP,JP,KP,XPOS,YPOS,ZPOS
      GOTO 998



  999 CONTINUE
      CALL GVSTTB ('?NEWB48')
      IERR=1
      CALL GVSCLF (19)



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTFPP (XPOS,YPOS,ZPOS,TEXT,IERR)


















      IMPLICIT      NONE
      INCLUDE       'IRIGRA.INC'
      INTEGER       IERR, GVFLEN
      REAL          XPOS, YPOS, ZPOS
      CHARACTER*(*) TEXT
      CHARACTER*20  LOCSTR
      LOGICAL       GVFFOP







      IERR=0
      CALL GVSCTB (LOCSTR,20)



      IF (.NOT.GVFFOP(66)) CALL GRTFPF



      INDPCK2=INDPCK2+1
      IF (GVFLEN(TEXT).GT.0) THEN
         WRITE (66,REC=INDPCK2,ERR=999) XPOS,YPOS,ZPOS,
     +    TEXT(1:MIN(20,GVFLEN(TEXT)))
      ELSE
         WRITE (66,REC=INDPCK2,ERR=999) XPOS,YPOS,ZPOS,LOCSTR
      END IF
      GOTO 998



  999 CONTINUE
      CALL GVSTTB ('?NEWB48')
      IERR=1
      CALL GVSCLF (66)



  998 CONTINUE


      RETURN
      END
      SUBROUTINE GRTPL4 (V1,V2,V3,V4,ISTEP,ICOL,IERR)
















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR, ICOL, ISTEP, I
      REAL          V1(3), V2(3), V3(3), V4(3), V5(3), V6(3),
     +              STEP1, STEP2, GVFDV3, F1, F2







      IF (NUMGRV.GT.MAXVEC) THEN
         CALL GVSTTE ('?GRTB02')
         IERR=1
         GOTO 998
      END IF



      IERR=0
      ISTEP=MAX(ISTEP,3)



      STEP1=GVFDV3(V1,V2)/FLOAT(ISTEP)
      STEP2=GVFDV3(V3,V4)/FLOAT(ISTEP)
      CALL GVSTV3 (V5,V2,V1)
      CALL GVSTV3 (V6,V3,V4)
      CALL GVSNM3 (V5)
      CALL GVSNM3 (V6)
      DO 10 I=0,ISTEP
         F1=STEP1*FLOAT(I)
         F2=STEP2*FLOAT(I)
         CALL GRTLIN (V1(1)+V5(1)*F1,V1(2)+V5(2)*F1,V1(3)+V5(3)*F1,
     +    V4(1)+V6(1)*F2,V4(2)+V6(2)*F2,V4(3)+V6(3)*F2,ICOL,IERR)
   10 CONTINUE



      STEP1=GVFDV3(V2,V3)/FLOAT(ISTEP)
      STEP2=GVFDV3(V4,V1)/FLOAT(ISTEP)
      CALL GVSTV3 (V5,V3,V2)
      CALL GVSTV3 (V6,V4,V1)
      CALL GVSNM3 (V5)
      CALL GVSNM3 (V6)
      DO 20 I=0,ISTEP
         F1=STEP1*FLOAT(I)
         F2=STEP2*FLOAT(I)
         CALL GRTLIN (V2(1)+V5(1)*F1,V2(2)+V5(2)*F1,V2(3)+V5(3)*F1,
     +    V1(1)+V6(1)*F2,V1(2)+V6(2)*F2,V1(3)+V6(3)*F2,ICOL,IERR)
   20 CONTINUE



      IF (IERR.NE.0) CALL GVSTTE ('?GRTB03')



 998  CONTINUE


      RETURN
      END
      SUBROUTINE GRTSCL (VEC_LOWIN,VEC_HGH_IN,ICOL,IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       VEC_LOWIN, VEC_HGH_IN, VEC_LOW, VEC_HGH, 
     +              IVEC, ICOL, IERR







      IF (VEC_LOWIN.LT.1) THEN
         VEC_LOW=1
      ELSE
         VEC_LOW=VEC_LOWIN
      END IF
      IF (VEC_HGH_IN.LT.1) THEN
         VEC_HGH=NUMGRV
      ELSE
         VEC_HGH=VEC_HGH_IN
      END IF




      IF (VEC_HGH.LT.VEC_LOW.OR.VEC_HGH.GT.MAXVEC.OR.VEC_HGH.LT.
     + 0.OR.VEC_LOW.GT.MAXVEC.OR.VEC_LOW.LT.0) GOTO 998



      IERR=0



      DO 10 IVEC=VEC_LOW,VEC_HGH
         HUEVAL(IVEC)=ICOL
   10 CONTINUE



  998 CONTINUE


      RETURN
      END   
      INTEGER FUNCTION GRTVGN(IERR)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'
      INTEGER       IERR







      IERR=0
      GRTVGN=NUMGRV





      RETURN
      END   
      SUBROUTINE GRTVIN

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'VECTOR.INC'







      NUMGRV=0







      RETURN
      END   
      SUBROUTINE GRTXY (ROW,NUM,SCRATCH,STEPS,ICOL,AXES)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'IRIGRA.INC'
      INTEGER       NUM, STEPS, IERR, I, INDX, ICOL
      REAL          ROW(NUM), MINVAL, MAXVAL, SCRATCH(STEPS), XOLD,
     +              YOLD, HISMAX, GVFMIN, GVFMAX
      LOGICAL       AXES, GVFIBN


      RETURN
      END   
      SUBROUTINE GRTXYP (ROW,NUM,ICOL)

















      IMPLICIT      NONE
      INCLUDE       'BIGINC.INC'
      INCLUDE       'IRIGRA.INC'
      INTEGER       NUM, IERR, I, ICOL
      REAL          ROW(NUM), GVFMAX, SCALX, SCALY







      IF (.NOT.USE300) GOTO 998
      IF (NUM.LE.1) GOTO 998



      SCALX=20.0/FLOAT(NUM)
      SCALY=10.0/GVFMAX(ROW,NUM)



      DO 10 I=2,NUM
         CALL GRTLIN (FLOAT(I-1)*SCALX-10.0,ROW(I-1)*SCALY,0.0,
     +                FLOAT(I)*SCALX-10.0,ROW(I)*SCALY,0.0,ICOL,IERR)
   10 CONTINUE



      CALL GRTLIN (-10.0,0.0,0.0, 10.0, 0.0,0.0,240,IERR)
      CALL GRTLIN (-10.0,0.0,0.0,-10.0,10.0,0.0,240,IERR)



  998 CONTINUE


      RETURN
      END   
