/*
 * support.c, Rob W.W. Hooft, 1995
 *
 * $Id: support.c,v 1.2 1995/11/10 14:16:29 hooft Exp $
 */

/*
 * Includes
 */

#include <sys/types.h>
#if !defined(PCDOS)
#include <sys/times.h>
#include <sys/param.h>
#endif
#if !defined(ESV)
#include <unistd.h>
#include <malloc.h>
#else
#include "/usr/include/unistd.h"
#endif

/*
 * Missing parameters
 */

#ifndef HZ
#  define HZ 60
#endif

/*
 * The "Dummy" segment..............
 */

#if defined (linux) || defined (F2C)
int sleep_(int *i)
{
  sleep(*i);
  return(0);
}
#endif

#include <sys/time.h>
#include <time.h>

void ctimestr_(out,len,ftnlen)  
char *out; 
int *len; 
int ftnlen; 
{ 
   struct tm * ti; 
   time_t sec; 
   sec=time(NULL); 
   ti=localtime(&sec); 
   ti->tm_mon++; 
   ti->tm_year+= ((ti->tm_year<70)?2000:1900); 
 
   sprintf(out,"%02d:%02d:%02d", ti->tm_hour,ti->tm_min,ti->tm_sec); 
   *len=8; 
} 

void cdatestr_(out,len,ftnlen)  
char *out; 
int *len; 
int ftnlen; 
{ 
   struct tm * ti; 
   time_t sec; 
   sec=time(NULL); 
   ti=localtime(&sec); 
   ti->tm_mon++; 
   ti->tm_year+= ((ti->tm_year<70)?2000:1900); 
 
   sprintf(out,"%04d-%02d-%02d", ti->tm_year,ti->tm_mon,ti->tm_mday); 
   *len=10; 
} 

#if defined (F2C) || defined (linux)
void getlog_(out,ftnlen)
char *out;
int ftnlen;
{
  static char *local=0;
  int i;
#if 0
  if (!local) {
    local=logname(void);
  }
  for (i=0;i<ftnlen&&local[i];i++) {
    out[i]=local[i];
  }
#endif
  for (i=0;i<ftnlen;i++) {
    out[i]=' ';
  }
}
#endif
