/////////////////////////////////////////////////////////////////////////////
// Name:        translations.h
// Purpose:     List of wxWidgets available translations
// Author:      wxWidgets team
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////


/**

@page page_translations Translations

@tableofcontents

wxWidgets uses a certain number of user-readable strings such as
<tt>"help"</tt> or <tt>"Load file"</tt> which should be translated to the users
language if it is different from English. wxWidgets has built in support for
internationalization (@e i18n from now on) which allows for this to happen
automatically if the translations to the current language are available.

You may find here the list of all existing translations with the addresses of
the official translators whom you should contact if you would like to submit
any corrections to the translations for your language.

Also, please see @ref page_translations_howtohelp if you would like to
translate wxWidgets to your language if it is not mentioned here (or to help
with one which already is - it is quite helpful to have several translators for
one language at least for proof reading).



@section page_translations_avail Available Translations

Below is the table containing the list of languages supported by wxWidgets.
The columns of this table have the obvious meaning: in each row you will see
the language, the official translator (if any) for it and the status of the
translations.

Please note that email addresses in the table below are intentionally invalid
to foil spam robots, remove one <tt>\@</tt> from them.

<table>

<tr>
    <th>Language</th>
    <th>Status</th>
    <th>Translator(s)</th>
</tr>

<tr>
    <td>Afrikaans</td>
    <td class="orange">71%</td>
    <td><a href="mailto:rkwjpj@@puk.ac.za">Petri Jooste</a></td>
</tr>

<tr>
    <td>Albanian</td>
    <td class="orange">79%</td>
    <td><a href="mailto:besnik@@programeshqip.org">Besnik Bleta</a></td>
</tr>

<tr>
    <td>Basque</td>
    <td class="red">18%</td>
    <td><a href="mailto:3arrano@@euskalerria.org">3ARRANO Euskalgintza Taldea</a></td>
</tr>

<tr>
    <td>Catalan</td>
    <td class="orange">67%</td>
    <td><a href="mailto:paubcrespo@@hotmail.com">Pau Bosch i Crespo</a></td>
</tr>

<tr>
    <td>Chinese (simplified)</td>
    <td class="green">80%</td>
    <td><a href="mailto:mrfx@@fm365.com">mrfx</a></td>
</tr>

<tr>
    <td>Chinese (traditional)</td>
    <td class="green">80%</td>
    <td><a href="mailto:pal.tw@@yahoo.com.tw">pal.tw</a></td>
</tr>

<tr>
    <td>Czech</td>
    <td class="orange">68%</td>
    <td>
        <a href="mailto:v.slavik@@volny.cz">Vaclav Slavik</a>,
        <a href="mailto:deirdre_skye@@web.de">Herbert Breunung</a>
    </td>
</tr>

<tr>
    <td>Danish</td>
    <td class="orange">78%</td>
    <td>
        <a href="mailto:leif@@danmos.dk">Leif Jensen</a>,
        <a href="mailto:Henrik@@fangorn.dk">Henrik Ræder Clausen</a>,
        <a href="mailto:mulrich15@@yahoo.dk">Morten Råbjerg Ulrich</a>
    </td>
</tr>

<tr>
    <td>Dutch</td>
    <td class="green">92%</td>
    <td><a href="mailto:phubers@@solve-i-t.com">Patrick Hubers</a></td>
</tr>

<tr>
    <td>English (UK)</td>
    <td class="green">100%</td>
    <td>N/A</td>
</tr>

<tr>
    <td>Finnish</td>
    <td class="green">88%</td>
    <td>
        <a href="mailto:kgb@@compart.fi">Kaj G Backas</a>,
        <a href="mailto:lanurmi@@iki.fi">Lauri Nurmi</a>,
        <a href="mailto:jmsalli79@@hotmail.com">Jaakko Salli</a>,
        <a href="mailto:elias.julkunen@gmail.com">Elias Julkunen</a>
    </td>
</tr>

<tr>
    <td>French (standard)</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:Stephane.Junique@@optics.kth.se">Stephane Junique</a>,
        <a href="mailto:lionel.allorge@@lunerouge.com">Lionel Allorge</a>,
        <a href="mailto:Gilles.Guyot@@Krypton.be">Gilles Guyot</a>
    </td>
</tr>

<tr>
    <td>Galician</td>
    <td class="green">80%</td>
    <td>
        <a href="mailto:leandro.regueiro@@gmail.com">Leandro Regueiro</a>,
        <a href="mailto:correoadrian82@@hotmail.com">Adrián González Alba</a>
    </td>
</tr>

<tr>
    <td>German</td>
    <td class="green">81%</td>
    <td>
        <a href="mailto:DanR@@gmx.de">Daniel Reith</a>,
        <a href="mailto:sparhawk@@aon.at">Gerhard Gruber</a>,
        <a href="mailto:stefan@@hedemann.de">Stefan Hedemann</a>,
        <a href="mailto:D.Reymann@@geisenheim.mnd.fh-wiesbaden.de">Dr. Detlev Reymann</a>,
        Mark Johnson,
        <a href="mailto:martinnost@@users.sf.net">Martin Jost</a>,
        <a href="mailto:deirdre_skye@@web.de">Herbert Breunung</a>,
        <a href="mailto:chbuck@@gmail.com">Ch. Buck</a>
    </td>
</tr>

<tr>
    <td>Greek</td>
    <td class="orange">76%</td>
    <td>
        <a href="mailto:tsolako1@@otenet.gr">Tsolakos Stavros</a>,
        <a href="mailto:nassosy@@compulink.gr">Nassos Yiannopoulos</a>
    </td>
</tr>

<tr>
    <td>Hindi</td>
    <td class="green">92%</td>
    <td>
        <a href="mailto:dysxhi@@yahoo.co.in">Dhananjaya Sharma</a>,
        <a href="mailto:priyank.bolia@@gmail.com">Priyank Bolia</a>
    </td>
</tr>

<tr>
    <td>Hungarian</td>
    <td class="green">80%</td>
    <td>
        <a href="mailto:Janos_Vegh@@users.sourceforge.net">Végh János Dr.</a>
    </td>
</tr>

<tr>
    <td>Indonesian</td>
    <td class="orange">73%</td>
    <td>
        <a href="mailto:bambang@@3wsi.com">Bambang Purnomosidi D. P.</a>
    </td>
</tr>

<tr>
    <td>Italian</td>
    <td class="green">91%</td>
    <td>
        <a href="mailto:mbarbon@@cpan.org">Mattia Barbon</a>,
        <a href="mailto:m.cavallini@@koansoftware.com">Marco Cavallini</a>
        (<a href="http://www.koansoftware.com">Koan Software</a>)
    </td>
</tr>

<tr>
    <td>Japanese</td>
    <td class="green">81%</td>
    <td>
        <a href="mailto:james.bishop1@@tiscali.co.uk">James Bishop</a>,
        <a href="mailto:saito@@inetrt.skcapi.co.jp">Hiroshi Saito</a>,
        <a href="mailto:suzumizaki@@free.japandesign.ne.jp">Suzumizaki-Kimitaka</a>
    </td>
</tr>

<tr>
    <td>Latvian</td>
    <td class="red">21%</td>
    <td>
        <a href="mailto:lauris@@nix.lv">Lauris Bukshis</a>
    </td>
</tr>

<tr>
    <td>Malay</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:mahrazi@@gmail.com">Mahrazi Mohd Kamal</a>
    </td>
</tr>

<tr>
    <td>Norwegian Bokmal</td>
    <td class="orange">78%</td>
    <td>
        <a href="mailto:hans@@nordhaug.priv.no">Hans F. Nordhaug</a>
    </td>
</tr>

<tr>
    <td>Polish</td>
    <td class="green">81%</td>
    <td>
        <a href="mailto:matiso@@hoga.pl">Piotr Mackowiak</a>,
        <a href="mailto:jpiw@@go2.pl">Janusz Piwowarski</a>,
        <a href="mailto:abx@@abx.art.pl">ABX</a>
    </td>
</tr>

<tr>
    <td>Portuguese (pt)</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:bernardosw@@terra.com.br">Bernardo Santos Wernesback</a>,
        <a href="mailto:marionrpereira76@@hotmail.com">Mario Pereira</a>,
        <a href="mailto:digiplan.pt@@gmail.com">Antonio Cardoso Martins</a>,
        <a href="mailto:mail@@cgoncalves.info">Carlos Gonçalves</a>
    </td>
</tr>

<tr>
    <td>Portuguese (pt_BR)</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:e.a.tacao@@terra.com.br">E.A. Tacao</a>,
        <a href="mailto:jecdiniz@@yahoo.com.br">José Eduardo de Carvalho Diniz</a>,
        <a href="mailto:adiel@@inf.ufsc.br">Adiel Mittmann</a>
    </td>
</tr>

<tr>
    <td>Russian</td>
    <td class="orange">78%</td>
    <td>
        <a href="mailto:wolfsoft@@mail.ru">Dennis Prochko</a>,
        <a href="mailto:rolinsky@@mema.ucl.ac.be">Roman Rolinsky</a>,
        <a href="mailto:vadim@@wxwidgets.org">Vadim Zeitlin</a>,
        <a href="mailto:kai@@cmail.ru">Andrew V. Samoilov</a>
    </td>
</tr>

<tr>
    <td>Slovak</td>
    <td class="orange">77%</td>
    <td><a href="mailto:helix84@@centrum.sk">Ivan Masar</a></td>
</tr>

<tr>
    <td>Slovenian</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:roman.plevel@@iskratr.si">Roman Plevel</a>,
        <a href="mailto:miles@@filmsi.net">Martin Srebotnjak</a>
    </td>
</tr>

<tr>
    <td>Spanish</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:guille@@iies.es">Guillermo Rodriguez Garcia</a>,
        <a href="mailto:jsj666@@hotmail.com">JSJ</a>,
        <a href="mailto:francisco.vila@@hispalinux.es">Francisco Vila</a>,
        <a href="mailto:correoadrian82@@hotmail.com">Adrián González Alba</a>
    </td>
</tr>

<tr>
    <td>Swedish</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:jor@@mindless.com">Jonas Rydberg</a>,
        <a href="mailto:kgb@@compart.fi">Kaj G Backas</a>
    </td>
</tr>

<tr>
    <td>Turkish</td>
    <td class="green">92%</td>
    <td><a href="mailto:dogusanh@@dynaset.org">Hakki Dogusan</a></td>
</tr>

<tr>
    <td>Ukrainian</td>
    <td class="green">95%</td>
    <td>
        <a href="mailto:manko@@salingshot.co.nz">Eugene Manko</a>,
        <a href="mailto:yurchor@@ukr.net">Yuri Chornoivan</a>,
        <a href="mailto:k_ilya@@ukr.net">Ylia K</a>
    </td>
</tr>

<tr>
    <td>Valencian (ca\@valencia)</td>
    <td class="orange">67%</td>
    <td><a href="mailto:rmh@@aybabtu.com">Robert Millan</a></td>
</tr>

<tr>
    <td>Vietnamese</td>
    <td class="green">100%</td>
    <td><a href="mailto:vnwildman@gmail.com">Tran Ngoc Quan</a></td>
</tr>

</table>
<br>



@section page_translations_howtohelp How to Help

wxWidgets uses the standard <a href="http://www.gnu.org/software/gettext/">GNU
gettext</a> tools for i18n so if you are already familiar with them you
shouldn't have any problems with working on wxWidgets translations.

Here are the steps you should follow:

-# Get the latest version of the file <tt>locale/wxstd.pot</tt> from the
   wxWidgets source tree: if you're using
   <a href="http://www.wxwidgets.org/develop/svn.htm">Subversion</a>
   or the <a href="http://wxwindows.sourceforge.net/snapshots/">daily snapshots</a>
   you should already have it.
   Otherwise you can always retrieve it directly from the Subversion repository via the
   <a href="http://svn.wxwidgets.org/viewvc/wx/wxWidgets/trunk/locale/wxstd.pot?view=co">Web interface</a>.
-# Rename it to <tt>XY.po</tt> where <tt>"XY"</tt> is the 2 letter
   <a href="http://www.loc.gov/standards/iso639-2/php/English_list.php">ISO 639-2 language code</a>
   for your language.
-# Translate the strings in this file using either your favourite text
   editor or a specialized tool such as Vaclav Slavik's excellent
   <a href="http://www.poedit.net/">poEdit</a> utility.
-# Verify that your translations can at least be compiled (even if they
   are yet incomplete) by running <tt>msgfmt -v XY.po</tt> command:
   please note that you <i>must</i> use the <tt>-v</tt> option. In
   particular, please fill the header fields because @c msgfmt doesn't
   accept the default values for them.
-# Send the finished translation to <a href="mailto:vadim@wxwidgets.org">Vadim Zeitlin</a>
   and it will be added to the next wxWidgets release or snapshot.

In addition, please consider subscribing to the very low volume
<a href="http://lists.wxwidgets.org/mailman/listinfo/wx-translators">
wxWidgets translators</a> mailing list on which the news especially important
for the translators are announced.

Thank you in advance for your help!

*/
