/*
 *  Copyright (C) 2006-2025, Thomas Maier-Komor
 *
 *  This is the source code of xjobs.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef COLORTTY_H
#define COLORTTY_H

typedef enum {
	invalid_color = -1, black = 0, red = 1, green = 2, yellow = 3, blue = 4,
	magenta = 5, cyan = 6, white = 7, noattr = 8
} color_t;

typedef enum {
	tty_none = 0, tty_ansi = 1, tty_auto = 2, tty_pipe = 3,
} ttymode_t;

extern ttymode_t TtyMode;

extern color_t ColorStart, ColorInfo, ColorDebug, ColorWarn, ColorError
	, ColorFail, ColorDone, ColorOut;
extern const char *TiSave, *TiRestore, *TiCursorLL, *TiClrEol, *TiNoAttr
	, *TiBlack, *TiBlue, *TiCyan, *TiGreen, *TiGrey, *TiMagenta
	, *TiRed, *TiWhite, *TiYellow;

extern char *PfxStart, *PfxDone, *PfxFail, *PfxDebug, *PfxInfo, *PfxWarn
	, *PfxError, *PfxOut;

extern int HaveTty, PgPid;
extern unsigned TiNoAttrL, TiClrEolL;
extern char StatusEnd;

color_t str2color(const char *str);
const char *colorstr(color_t c);
void init_terminal();

#endif
