/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/lib/timer.c,v 1.3 2002/03/19 06:14:22 bboy Exp $
	timer.c: A simple stopwatch-style timer.

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#include "misc.h"

static struct timeval _stop_watch;									// Our stopwatch


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	TIMER_RESET
	Resets the timer.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void
timer_reset(struct timeval *tv)
{
	gettimeofday(tv ? tv : &_stop_watch, NULL);
}
/*--- timer_reset() -----------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	TIMER_ELAPSED
	Returns the amount of time elapsed.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
float
timer_elapsed(struct timeval *tv)
{
	struct timeval now;
	struct timeval *s = tv ? tv : &_stop_watch;

   gettimeofday(&now, NULL);
   return ((float)((now.tv_sec + now.tv_usec / 1000000.0) - (s->tv_sec + s->tv_usec / 1000000.0)));
}
/*--- timer_elapsed() ---------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	TVDIFF
	Returns the amount of time elapsed between two timevals.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
float
tvdiff(struct timeval *start, struct timeval *stop)
{
   return ((float)((stop->tv_sec + stop->tv_usec / 1000000.0) - (start->tv_sec + start->tv_usec / 1000000.0)));
}
/*--- tvdiff() ----------------------------------------------------------------------------------*/

/* vi:set ts=3: */
