/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import us.fatehi.utility.CompareUtility;
import us.fatehi.utility.string.StringFormat;

abstract class AbstractTableReference
extends MutableTableConstraint
implements TableReference {
    private static final long serialVersionUID = -5164664131926303038L;
    private static final Logger LOGGER = Logger.getLogger(AbstractTableReference.class.getName());
    private final Table pkTable;
    private final SortedSet<ColumnReference> columnReferences;

    public AbstractTableReference(String name, ColumnReference columnReference) {
        super((Table)Objects.requireNonNull(columnReference, "No column reference provided").getForeignKeyColumn().getParent(), name);
        this.pkTable = (Table)columnReference.getPrimaryKeyColumn().getParent();
        this.columnReferences = new TreeSet<ColumnReference>();
        this.addColumnReference(columnReference);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof TableReference) {
            TableReference other = (TableReference)obj;
            List<ColumnReference> thisColumnReferences = this.getColumnReferences();
            List<ColumnReference> otherColumnReferences = other.getColumnReferences();
            return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
        }
        if (obj instanceof NamedObject) {
            NamedObject other = obj;
            return super.compareTo(other);
        }
        return -1;
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return new ArrayList<ColumnReference>(this.columnReferences);
    }

    @Override
    public Table getForeignKeyTable() {
        return (Table)this.getParent();
    }

    @Override
    public Table getPrimaryKeyTable() {
        return this.pkTable;
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.columnReferences.iterator();
    }

    boolean addColumnReference(ColumnReference columnReference) {
        if (columnReference == null) {
            return false;
        }
        Table fkTable = (Table)this.getParent();
        if (this.pkTable.equals(columnReference.getPrimaryKeyColumn().getParent()) && fkTable.equals(columnReference.getForeignKeyColumn().getParent())) {
            this.columnReferences.add(columnReference);
            this.addTableConstraintColumn(columnReference);
            return true;
        }
        LOGGER.log(Level.CONFIG, new StringFormat("Column reference <%s> not added, since it is not consistent with <%s --> %s>", columnReference, fkTable, this.pkTable));
        return false;
    }

    private void addTableConstraintColumn(ColumnReference columnReference) {
        Column fkColumn = columnReference.getForeignKeyColumn();
        MutableTableConstraintColumn tableConstraintColumn = new MutableTableConstraintColumn(this, fkColumn);
        tableConstraintColumn.setKeyOrdinalPosition(columnReference.getKeySequence());
        this.addColumn(tableConstraintColumn);
    }
}

