/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.ioresource.InputResource;

abstract class BaseInputResource
implements InputResource {
    private static final Logger LOGGER = Logger.getLogger(BaseInputResource.class.getName());

    BaseInputResource() {
    }

    @Override
    public final BufferedReader openNewInputReader(Charset charset) throws IOException {
        Objects.requireNonNull(charset, "No input charset provided");
        InputStream inputStream = this.openNewInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        LOGGER.log(Level.FINE, String.format("Opened resource <%s> for reading", this.getDescription()));
        return reader;
    }
}

