﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/DatabaseMigrationServiceRequest.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DatabaseMigrationService {
namespace Model {

/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTaskMessage">AWS
 * API Reference</a></p>
 */
class MoveReplicationTaskRequest : public DatabaseMigrationServiceRequest {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API MoveReplicationTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "MoveReplicationTask"; }

  AWS_DATABASEMIGRATIONSERVICE_API Aws::String SerializePayload() const override;

  AWS_DATABASEMIGRATIONSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
   */
  inline const Aws::String& GetReplicationTaskArn() const { return m_replicationTaskArn; }
  inline bool ReplicationTaskArnHasBeenSet() const { return m_replicationTaskArnHasBeenSet; }
  template <typename ReplicationTaskArnT = Aws::String>
  void SetReplicationTaskArn(ReplicationTaskArnT&& value) {
    m_replicationTaskArnHasBeenSet = true;
    m_replicationTaskArn = std::forward<ReplicationTaskArnT>(value);
  }
  template <typename ReplicationTaskArnT = Aws::String>
  MoveReplicationTaskRequest& WithReplicationTaskArn(ReplicationTaskArnT&& value) {
    SetReplicationTaskArn(std::forward<ReplicationTaskArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the replication instance where you want to move the task to.</p>
   */
  inline const Aws::String& GetTargetReplicationInstanceArn() const { return m_targetReplicationInstanceArn; }
  inline bool TargetReplicationInstanceArnHasBeenSet() const { return m_targetReplicationInstanceArnHasBeenSet; }
  template <typename TargetReplicationInstanceArnT = Aws::String>
  void SetTargetReplicationInstanceArn(TargetReplicationInstanceArnT&& value) {
    m_targetReplicationInstanceArnHasBeenSet = true;
    m_targetReplicationInstanceArn = std::forward<TargetReplicationInstanceArnT>(value);
  }
  template <typename TargetReplicationInstanceArnT = Aws::String>
  MoveReplicationTaskRequest& WithTargetReplicationInstanceArn(TargetReplicationInstanceArnT&& value) {
    SetTargetReplicationInstanceArn(std::forward<TargetReplicationInstanceArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_replicationTaskArn;

  Aws::String m_targetReplicationInstanceArn;
  bool m_replicationTaskArnHasBeenSet = false;
  bool m_targetReplicationInstanceArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
