﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/SafetyLever.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {
class GetSafetyLeverResult {
 public:
  AWS_FIS_API GetSafetyLeverResult() = default;
  AWS_FIS_API GetSafetyLeverResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FIS_API GetSafetyLeverResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> Information about the safety lever. </p>
   */
  inline const SafetyLever& GetSafetyLever() const { return m_safetyLever; }
  template <typename SafetyLeverT = SafetyLever>
  void SetSafetyLever(SafetyLeverT&& value) {
    m_safetyLeverHasBeenSet = true;
    m_safetyLever = std::forward<SafetyLeverT>(value);
  }
  template <typename SafetyLeverT = SafetyLever>
  GetSafetyLeverResult& WithSafetyLever(SafetyLeverT&& value) {
    SetSafetyLever(std::forward<SafetyLeverT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetSafetyLeverResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  SafetyLever m_safetyLever;

  Aws::String m_requestId;
  bool m_safetyLeverHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
