/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.file.CaseSensitivity;
import net.rubygrapefruit.platform.file.FileSystemInfo;
import net.rubygrapefruit.platform.internal.DefaultFileSystemInfo;

public class FileSystemList {
    public final List<FileSystemInfo> fileSystems = new ArrayList<FileSystemInfo>();

    public void add(String mountPoint, String fileSystemType, String deviceName, boolean remote, boolean caseSensitive, boolean casePreserving) {
        this.fileSystems.add(new DefaultFileSystemInfo(new File(mountPoint), fileSystemType, deviceName, remote, new DefaultCaseSensitivity(caseSensitive, casePreserving)));
    }

    public void addForUnknownCaseSensitivity(String mountPoint, @Nullable String fileSystemType, String deviceName, boolean remote) {
        this.fileSystems.add(new DefaultFileSystemInfo(new File(mountPoint), fileSystemType == null ? "unknown" : fileSystemType, deviceName, remote, null));
    }

    private static class DefaultCaseSensitivity
    implements CaseSensitivity {
        private final boolean caseSensitive;
        private final boolean casePreserving;

        public DefaultCaseSensitivity(boolean caseSensitive, boolean casePreserving) {
            this.caseSensitive = caseSensitive;
            this.casePreserving = casePreserving;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean isCasePreserving() {
            return this.casePreserving;
        }

        public String toString() {
            return "CaseSensitivity{caseSensitive=" + this.caseSensitive + ", casePreserving=" + this.casePreserving + '}';
        }
    }
}

