/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.graph.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class StreamStreamJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, V1, V2, VR> {
    private final String thisWindowedStreamProcessorName;
    private final String otherWindowedStreamProcessorName;
    private final ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters;
    private boolean isSelfJoin;

    private StreamStreamJoinNode(String nodeName, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters, ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters, ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters, ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters, String thisWindowedStreamProcessorName, String otherWindowedStreamProcessorName) {
        super(nodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessParameters, joinMergeProcessorParameters, null, null);
        this.thisWindowedStreamProcessorName = thisWindowedStreamProcessorName;
        this.otherWindowedStreamProcessorName = otherWindowedStreamProcessorName;
        this.selfJoinProcessorParameters = selfJoinProcessorParameters;
    }

    @Override
    public String toString() {
        return "StreamStreamJoinNode{thisWindowedStreamProcessorName=" + this.thisWindowedStreamProcessorName + ", otherWindowedStreamProcessorName=" + this.otherWindowedStreamProcessorName + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String thisProcessorName = this.thisProcessorParameters().processorName();
        String otherProcessorName = this.otherProcessorParameters().processorName();
        if (this.isSelfJoin) {
            this.selfJoinProcessorParameters.addProcessorTo(topologyBuilder, this.thisWindowedStreamProcessorName);
        } else {
            this.thisProcessorParameters().addProcessorTo(topologyBuilder, this.thisWindowedStreamProcessorName);
            this.otherProcessorParameters().addProcessorTo(topologyBuilder, this.otherWindowedStreamProcessorName);
            this.mergeProcessorParameters().addProcessorTo(topologyBuilder, thisProcessorName, otherProcessorName);
        }
    }

    public void setSelfJoin() {
        this.isSelfJoin = true;
    }

    public boolean getSelfJoin() {
        return this.isSelfJoin;
    }

    public String thisWindowedStreamProcessorName() {
        return this.thisWindowedStreamProcessorName;
    }

    public String otherWindowedStreamProcessorName() {
        return this.otherWindowedStreamProcessorName;
    }

    public static <K, V1, V2, VR> StreamStreamJoinNodeBuilder<K, V1, V2, VR> streamStreamJoinNodeBuilder() {
        return new StreamStreamJoinNodeBuilder();
    }

    public static final class StreamStreamJoinNodeBuilder<K, V1, V2, VR> {
        private String nodeName;
        private ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner;
        private ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters;
        private ProcessorParameters<K, V2, ?, ?> joinOtherProcessorParameters;
        private ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters;
        private ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters;
        private String thisWindowedStreamProcessorName;
        private String otherWindowedStreamProcessorName;

        private StreamStreamJoinNodeBuilder() {
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withSelfJoinProcessorParameters(ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters) {
            this.selfJoinProcessorParameters = selfJoinProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowedStreamProcessorName(String thisWindowedStreamProcessorName) {
            this.thisWindowedStreamProcessorName = thisWindowedStreamProcessorName;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowedStreamProcessorName(String otherWindowedStreamProcessorName) {
            this.otherWindowedStreamProcessorName = otherWindowedStreamProcessorName;
            return this;
        }

        public StreamStreamJoinNode<K, V1, V2, VR> build() {
            return new StreamStreamJoinNode<K, V1, V2, VR>(this.nodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.selfJoinProcessorParameters, this.thisWindowedStreamProcessorName, this.otherWindowedStreamProcessorName);
        }
    }
}

