/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.health;

import io.smallrye.health.api.AsyncHealthCheck;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import org.eclipse.microprofile.health.Readiness;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.services.health.KeycloakClusterReadyHealthCheck;

@ApplicationScoped
public class KeycloakClusterReadyHealthCheckProducer {
    @Produces
    @Readiness
    @Dependent
    public AsyncHealthCheck createHealthCheck() {
        QuarkusKeycloakSessionFactory sessionFactory = QuarkusKeycloakSessionFactory.getInstance();
        InfinispanConnectionProviderFactory factory = (InfinispanConnectionProviderFactory)sessionFactory.getProviderFactory(InfinispanConnectionProvider.class);
        if (factory.isClusterHealthSupported()) {
            return new KeycloakClusterReadyHealthCheck();
        }
        return null;
    }
}

