/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.EntityNameResolver;
import org.hibernate.Interceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class CoordinatingEntityNameResolver
implements EntityNameResolver {
    private final SessionFactoryImplementor sessionFactory;
    private final Interceptor interceptor;

    public CoordinatingEntityNameResolver(SessionFactoryImplementor sessionFactory, Interceptor interceptor) {
        this.sessionFactory = sessionFactory;
        this.interceptor = interceptor;
    }

    @Override
    public String resolveEntityName(Object entity) {
        String entityName = this.interceptor.getEntityName(entity);
        if (entityName != null) {
            return entityName;
        }
        for (EntityNameResolver resolver : this.sessionFactory.getSessionFactoryOptions().getEntityNameResolvers()) {
            entityName = resolver.resolveEntityName(entity);
            if (entityName == null) continue;
            return entityName;
        }
        for (EntityNameResolver resolver : this.sessionFactory.getMappingMetamodel().getEntityNameResolvers()) {
            entityName = resolver.resolveEntityName(entity);
            if (entityName == null) continue;
            return entityName;
        }
        return entity.getClass().getName();
    }
}

