/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.TreatedNavigablePath;

@Incubating
public class NavigablePath
implements DotIdentifierSequence,
Serializable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final @Nullable NavigablePath parent;
    private final String localName;
    private final @Nullable String alias;
    private final String identifierForTableGroup;
    private final int hashCode;

    public NavigablePath(String localName) {
        this(localName, null);
    }

    public NavigablePath(String rootName, @Nullable String alias) {
        this.parent = null;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        this.localName = rootName;
        this.identifierForTableGroup = rootName;
        this.hashCode = this.localName.hashCode() + (alias == null ? 0 : alias.hashCode());
    }

    public NavigablePath(NavigablePath parent, String navigableName) {
        this(parent, navigableName, null);
    }

    public NavigablePath(NavigablePath parent, String localName, @Nullable String alias) {
        assert (parent != null);
        this.parent = parent;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        String aliasedLocalName = alias == null ? localName : localName + "(" + alias + ")";
        this.hashCode = parent.hashCode() + aliasedLocalName.hashCode();
        if (IDENTIFIER_MAPPER_PROPERTY.equals(localName)) {
            this.localName = "";
            this.identifierForTableGroup = parent.getFullPath();
        } else {
            this.localName = localName;
            String parentFullPath = parent.getFullPath();
            this.identifierForTableGroup = StringHelper.isEmpty(parentFullPath) ? aliasedLocalName : parentFullPath + "." + localName;
        }
    }

    public NavigablePath(@Nullable NavigablePath parent, String localName, @Nullable String alias, String identifierForTableGroup, int hashCode) {
        this.parent = parent;
        this.localName = localName;
        this.hashCode = hashCode;
        this.alias = StringHelper.nullIfEmpty(alias);
        this.identifierForTableGroup = identifierForTableGroup;
    }

    @Override
    public @Nullable NavigablePath getParent() {
        return this.parent instanceof TreatedNavigablePath ? this.parent.getParent() : this.parent;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public @Nullable String getAlias() {
        return this.alias;
    }

    public boolean isAliased() {
        return this.alias != null;
    }

    public String getIdentifierForTableGroup() {
        return this.identifierForTableGroup;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DotIdentifierSequence)) {
            return false;
        }
        DotIdentifierSequence otherPath = (DotIdentifierSequence)other;
        if (!this.localNamesMatch(otherPath)) {
            return false;
        }
        if (otherPath instanceof NavigablePath) {
            NavigablePath otherNavigablePath = (NavigablePath)otherPath;
            return Objects.equals(this.getAlias(), otherNavigablePath.getAlias()) && Objects.equals(this.getRealParent(), otherNavigablePath.getRealParent());
        }
        return Objects.equals(this.getParent(), otherPath.getParent());
    }

    protected boolean localNamesMatch(DotIdentifierSequence other) {
        boolean bl;
        if (other instanceof EntityIdentifierNavigablePath) {
            EntityIdentifierNavigablePath entityIdentifierNavigablePath = (EntityIdentifierNavigablePath)other;
            bl = this.localNamesMatch(entityIdentifierNavigablePath);
        } else {
            bl = Objects.equals(this.getLocalName(), other.getLocalName());
        }
        return bl;
    }

    protected boolean localNamesMatch(EntityIdentifierNavigablePath other) {
        return Objects.equals(this.getLocalName(), other.getLocalName()) || Objects.equals(this.getLocalName(), other.getIdentifierAttributeName());
    }

    @Override
    public NavigablePath append(String property) {
        return new NavigablePath(this, property);
    }

    public NavigablePath append(String property, String alias) {
        return new NavigablePath(this, property, alias);
    }

    public NavigablePath treatAs(String entityName) {
        return new TreatedNavigablePath(this, entityName);
    }

    public NavigablePath treatAs(String entityName, String alias) {
        return new TreatedNavigablePath(this, entityName, alias);
    }

    public @Nullable NavigablePath getRealParent() {
        return this.parent;
    }

    public boolean isParent(@Nullable NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath.getParent())) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public boolean isSuffix(@Nullable DotIdentifierSequence dotIdentifierSequence) {
        if (dotIdentifierSequence == null) {
            return true;
        }
        if (!this.localNamesMatch(dotIdentifierSequence)) {
            return false;
        }
        NavigablePath parent = this.getParent();
        return parent != null && parent.isSuffix(dotIdentifierSequence.getParent());
    }

    public @Nullable NavigablePath trimSuffix(@Nullable DotIdentifierSequence suffix) {
        if (suffix == null) {
            return this;
        }
        if (!this.getLocalName().equals(suffix.getLocalName())) {
            return null;
        }
        NavigablePath parent = this.getParent();
        return parent != null ? parent.trimSuffix(suffix.getParent()) : null;
    }

    public boolean isParentOrEqual(@Nullable NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath)) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public boolean pathsMatch(@Nullable NavigablePath path) {
        return this == path || path != null && this.localName.equals(path.localName) && (this.parent == null ? path.parent == null && Objects.equals(this.alias, path.alias) : this.parent.pathsMatch(path.parent));
    }

    public @Nullable String relativize(NavigablePath base) {
        RelativePathCollector pathCollector = new RelativePathCollector();
        this.relativize(base, pathCollector);
        return pathCollector.resolve();
    }

    protected void relativize(NavigablePath base, RelativePathCollector collector) {
        if (this.equals(base)) {
            collector.matchedBase = true;
        } else {
            if (!collector.matchedBase && this.parent != null) {
                this.parent.relativize(base, collector);
            }
            collector.collectPath(this.getLocalName());
        }
    }

    @Override
    public String getFullPath() {
        return this.alias == null ? this.identifierForTableGroup : this.identifierForTableGroup + "(" + this.alias + ")";
    }

    public String toString() {
        return this.getFullPath();
    }

    protected static class RelativePathCollector {
        private boolean matchedBase;
        private StringBuilder buffer;

        protected RelativePathCollector() {
        }

        public void collectPath(String path) {
            if (this.matchedBase) {
                if (this.buffer == null) {
                    this.buffer = new StringBuilder();
                } else {
                    this.buffer.append('.');
                }
                this.buffer.append(path);
            }
        }

        public @Nullable String resolve() {
            if (this.buffer == null) {
                return this.matchedBase ? "" : null;
            }
            return this.buffer.toString();
        }
    }
}

