/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.util;

import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class SAMLParserUtil {
    private static final PicketLinkLogger LOGGER = PicketLinkLoggerFactory.getLogger();

    public static NameIDType parseNameIDType(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement nameIDElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        NameIDType nameID = new NameIDType();
        nameID.setFormat(StaxParserUtil.getUriAttributeValue(nameIDElement, SAMLAssertionQNames.ATTR_FORMAT));
        nameID.setNameQualifier(StaxParserUtil.getAttributeValue(nameIDElement, SAMLAssertionQNames.ATTR_NAME_QUALIFIER));
        nameID.setSPProvidedID(StaxParserUtil.getAttributeValue(nameIDElement, SAMLAssertionQNames.ATTR_SP_PROVIDED_ID));
        nameID.setSPNameQualifier(StaxParserUtil.getAttributeValue(nameIDElement, SAMLAssertionQNames.ATTR_SP_NAME_QUALIFIER));
        String nameIDValue = StaxParserUtil.getElementText(xmlEventReader);
        nameID.setValue(nameIDValue);
        return nameID;
    }

    public static void validateAttributeValue(StartElement element, HasQName attributeName, String expectedValue) throws ParsingException {
        String value = StaxParserUtil.getRequiredAttributeValue(element, attributeName);
        if (!Objects.equals(expectedValue, value)) {
            throw LOGGER.parserException(new RuntimeException(String.format("%s %s required to be \"%s\"", element.getName(), attributeName.getQName(), expectedValue)));
        }
    }
}

