/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.server.core.RuntimeExceptionMapper;

public class ExceptionMappersSupplier
implements Supplier<List<Entry>> {
    @Override
    public List<Entry> get() {
        Map mappers = RuntimeExceptionMapper.getMappers();
        ArrayList<Entry> result = new ArrayList<Entry>(mappers.size());
        for (Map.Entry entry : mappers.entrySet()) {
            result.add(new Entry(((Class)entry.getKey()).getName(), ((ResourceExceptionMapper)entry.getValue()).getClassName(), ((ResourceExceptionMapper)entry.getValue()).getPriority()));
        }
        return result;
    }

    public static class Entry {
        private final String exceptionClassName;
        private final String mapperClassName;
        private final Integer priority;

        public Entry(String exceptionClassName, String mapperClassName, Integer priority) {
            this.exceptionClassName = exceptionClassName;
            this.mapperClassName = mapperClassName;
            this.priority = priority;
        }

        public String getExceptionClassName() {
            return this.exceptionClassName;
        }

        public String getMapperClassName() {
            return this.mapperClassName;
        }

        public Integer getPriority() {
            return this.priority;
        }
    }
}

