/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.tr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Orta Afrika Saati",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskova Standart Saati",
               "MST",
               "Moskova Yaz Saati",
               "MST",
               "Moskova Saati",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japonya Standart Saati",
               "JST",
               "Japonya Yaz Saati",
               "JDT",
               "Japonya Saati",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standart Saati",
               "PST",
               "Pakistan Yaz Saati",
               "PST",
               "Pakistan Saati",
               "PT",
            };
        final String[] Taipei = new String[] {
               "Taipei Standart Saati",
               "TST",
               "Taipei Yaz Saati",
               "TDT",
               "Taipei Saati",
               "TT",
            };
        final String[] Hovd = new String[] {
               "Kobdo Standart Saati",
               "HST",
               "Kobdo Yaz Saati",
               "HST",
               "Hovd Saati",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadan Standart Saati",
               "MST",
               "Magadan Yaz Saati",
               "MST",
               "Magadan Saati",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0130\u00e7bat\u0131 Avustralya Standart Saati",
               "ACWST",
               "\u0130\u00e7bat\u0131 Avustralya Yaz Saati",
               "ACWDT",
               "\u0130\u00e7bat\u0131 Avustralya Saati",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Orta Avrupa Standart Saati",
               "CEST",
               "Orta Avrupa Yaz Saati",
               "CEST",
               "Orta Avrupa Saati",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Standart Saati",
               "SST",
               "Sakhalin Yaz Saati",
               "SST",
               "Sakhalin Saati",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standart Saati",
               "PST",
               "Paraguay Yaz Saati",
               "PST",
               "Paraguay Saati",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "Malezya Saati",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "Do\u011fu Standart Saati",
               "EST",
               "Do\u011fu Yaz Saati",
               "EDT",
               "Do\u011fu Saati",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standart Saati",
               "LHST",
               "Lord Howe Yaz Saati",
               "LHDT",
               "Lord Howe Saati",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Yeni Zelanda Standart Saati",
               "NZST",
               "Yeni Zelanda Yaz Saati",
               "NZDT",
               "Yeni Zelanda Saati",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hint Okyanusu Saati",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standart Saati",
               "YST",
               "Yakutsk Yaz Saati",
               "YST",
               "Yakutsk Saati",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius Standart Saati",
               "MST",
               "Mauritius Yaz Saati",
               "MST",
               "Mauritius Saati",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "Do\u011fu Afrika Saati",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Do\u011fu Timor Saati",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "Solomon Adalar\u0131 Saati",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Saati",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Adalar\u0131 Saati",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Do\u011fu Avrupa Standart Saati",
               "EEST",
               "Do\u011fu Avrupa Yaz Saati",
               "EEST",
               "Do\u011fu Avrupa Saati",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standart Saati",
               "NST",
               "Newfoundland Yaz Saati",
               "NDT",
               "Newfoundland Saati",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan Saati",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standart Saati",
               "HKST",
               "Hong Kong Yaz Saati",
               "HKST",
               "Hong Kong Saati",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Bat\u0131 Arjantin Standart Saati",
               "WAST",
               "Bat\u0131 Arjantin Yaz Saati",
               "WAST",
               "Bat\u0131 Arjantin Saati",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Standart Saati",
               "AST",
               "Atlantik Yaz Saati",
               "ADT",
               "Atlantik Saati",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape Saati",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "Bolivya Saati",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre ve Miquelon Standart Saati",
               "PMST",
               "Pierre ve Miquelon Yaz Saati",
               "PMDT",
               "Pierre ve Miquelon Saati",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u00c7inhindi Saati",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standart Saati",
               "YST",
               "Yekaterinburg Yaz Saati",
               "YST",
               "Yekaterinburg Saati",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Maldivler Saati",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Saati",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "\u0130srail Standart Saati",
               "IST",
               "\u0130srail Yaz Saati",
               "IDT",
               "\u0130srail Saati",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Orta Endonezya Saati",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "Wallis ve Futuna Saati",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "G\u00fcney Afrika Standart Saati",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Showa Saati",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "Line Adalar\u0131 Saati",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "\u00d6zbekistan Standart Saati",
               "UST",
               "\u00d6zbekistan Yaz Saati",
               "UST",
               "\u00d6zbekistan Saati",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Omsk Standart Saati",
               "OST",
               "Omsk Yaz Saati",
               "OST",
               "Omsk Saati",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Sey\u015fel Adalar\u0131 Saati",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standart Saati",
               "UST",
               "Uruguay Yaz Saati",
               "UST",
               "Uruguay Saati",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Nepal Saati",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batur Standart Saati",
               "UBST",
               "Ulan Batur Yaz Saati",
               "UBST",
               "Ulan Batur Saati",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Merkezi Standart Saati",
               "CST",
               "Merkezi Yaz Saati",
               "CDT",
               "Merkezi Saat",
               "CT",
            };
        final String[] Truk = new String[] {
               "Truk Saati",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niue Saati",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "Wake Adas\u0131 Saati",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "Falkland Adalar\u0131 Standart Saati",
               "FIST",
               "Falkland Adalar\u0131 Yaz Saati",
               "FIST",
               "Falkland Adalar\u0131 Saati",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standart Saati",
               "VST",
               "Vanuatu Yaz Saati",
               "VST",
               "Vanuatu Saati",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standart Saati",
               "NST",
               "Novosibirsk Yaz Saati",
               "NST",
               "Novosibirsk Saati",
               "NT",
            };
        final String[] Singapore = new String[] {
               "Singapur Standart Saati",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "Azor Adalar\u0131 Standart Saati",
               "AST",
               "Azor Adalar\u0131 Yaz Saati",
               "AST",
               "Azor Adalar\u0131 Saati",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Saati",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Surinam Saati",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "Nauru Saati",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standart Saati",
               "KST",
               "Krasnoyarsk Yaz Saati",
               "KST",
               "Krasnoyarsk Saati",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Bat\u0131 Kazakistan Saati",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Saati",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "Christmas Adas\u0131 Saati",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazon Standart Saati",
               "AST",
               "Amazon Yaz Saati",
               "AST",
               "Amazon Saati",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Do\u011fu Kazakistan Saati",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Fiji Standart Saati",
               "FST",
               "Fiji Yaz Saati",
               "FST",
               "Fiji Saati",
               "FT",
            };
        final String[] Reunion = new String[] {
               "Reunion Saati",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Cocos Adalar\u0131 Saati",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "Chatham Standart Saati",
               "CST",
               "Chatham Yaz Saati",
               "CDT",
               "Chatham Saati",
               "CT",
            };
        final String[] Vostok = new String[] {
               "Vostok Saati",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Arjantin Standart Saati",
               "AST",
               "Arjantin Yaz Saati",
               "AST",
               "Arjantin Saati",
               "AT",
            };
        final String[] Gambier = new String[] {
               "Gambier Saati",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Saati",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Saati",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Saati",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Saati",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Standart Saati",
               "HAST",
               "Hawaii-Aleutian Yaz Saati",
               "HADT",
               "Hawaii Aleutian Saati",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Orta Avustralya Standart Saati",
               "ACST",
               "Orta Avustralya Yaz Saati",
               "ACDT",
               "Orta Avustralya Saati",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Pasifik Standart Saati",
               "PST",
               "Pasifik Yaz Saati",
               "PDT",
               "Pasifik Saati",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Adalar\u0131 Saati",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmenistan Standart Saati",
               "TST",
               "T\u00fcrkmenistan Yaz Saati",
               "TST",
               "T\u00fcrkmenistan Saati",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "Bat\u0131 Avrupa Standart Saati",
               "WEST",
               "Bat\u0131 Avrupa Yaz Saati",
               "WEST",
               "Bat\u0131 Avrupa Saati",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standart Saati",
               "CVST",
               "Cape Verde Yaz Saati",
               "CVST",
               "Cape Verde Saati",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Adas\u0131 Saati",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "Guyana Saati",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Saati",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera Saati",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "Samoa Standart Saati",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau Saati",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaycan Standart Saati",
               "AST",
               "Azerbaycan Yaz Saati",
               "AST",
               "Azerbaycan Saati",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Mawson Saati",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis Saati",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "K\u00fcba Standart Saati",
               "CST",
               "K\u00fcba Yaz Saati",
               "CDT",
               "K\u00fcba Saati",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Bat\u0131 Afrika Standart Saati",
               "WAST",
               "Bat\u0131 Afrika Yaz Saati",
               "WAST",
               "Bat\u0131 Afrika Saati",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwich Merkez Saati",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "Filipinler Standart Saati",
               "PST",
               "Filipinler Yaz Saati",
               "PST",
               "Filipinler Saati",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u0131z G\u00fcney ve Antarktika Saati",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "G\u00fcney Georgia Saati",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Yeni Kaledonya Standart Saati",
               "NCST",
               "Yeni Kaledonya Yaz Saati",
               "NCST",
               "Yeni Kaledonya Saati",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Standart Saati",
               "VST",
               "Volgograd Yaz Saati",
               "VST",
               "Volgograd Saati",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Bruney Sultanl\u0131\u011f\u0131 Saati",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "\u0130ran Standart Saati",
               "IST",
               "\u0130ran Yaz Saati",
               "IDT",
               "\u0130ran Saati",
               "IT",
            };
        final String[] Easter = new String[] {
               "Easter Adas\u0131 Standart Saati",
               "EIST",
               "Easter Adas\u0131 Yaz Saati",
               "EIST",
               "Easter Adas\u0131 Saati",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urville Saati",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "Tacikistan Saati",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "Tonga Standart Saati",
               "TST",
               "Tonga Yaz Saati",
               "TST",
               "Tonga Saati",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u015f Standart Saati",
               "BST",
               "Banglade\u015f Yaz Saati",
               "BST",
               "Banglade\u015f Saati",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peru Standart Saati",
               "PST",
               "Peru Yaz Saati",
               "PST",
               "Peru Saati",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "Bat\u0131 Gr\u00f6nland Standart Saati",
               "WGST",
               "Bat\u0131 Gr\u00f6nland Yaz Saati",
               "WGST",
               "Bat\u0131 Gr\u00f6nland Saati",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador Saati",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "Do\u011fu Gr\u00f6nland Standart Saati",
               "EGST",
               "Do\u011fu Gr\u00f6nland Yaz Saati",
               "EGST",
               "Do\u011fu Gr\u00f6nland Saati",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "K\u00f6rfez Standart Saati",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Do\u011fu Endonezya Saati",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Kore Standart Saati",
               "KST",
               "Kore Yaz Saati",
               "KDT",
               "Kore Saati",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Bat\u0131 Avustralya Standart Saati",
               "AWST",
               "Bat\u0131 Avustralya Yaz Saati",
               "AWDT",
               "Bat\u0131 Avustralya Saati",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "K\u0131rg\u0131zistan Saati",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "Bat\u0131 Endonezya Saati",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Do\u011fu Avustralya Standart Saati",
               "AEST",
               "Do\u011fu Avustralya Yaz Saati",
               "AEDT",
               "Do\u011fu Avustralya Saati",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u0131z Guyanas\u0131 Saati",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Kolombiya Standart Saati",
               "CST",
               "Kolombiya Yaz Saati",
               "CST",
               "Kolombiya Saati",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u015eili Standart Saati",
               "CST",
               "\u015eili Yaz Saati",
               "CST",
               "\u015eili Saati",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Adalar\u0131 Saati",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "ABD S\u0131rada\u011flar Standart Saati",
               "MST",
               "ABD S\u0131rada\u011flar Yaz Saati",
               "MDT",
               "ABD S\u0131rada\u011flar Saati",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markiz Adalar\u0131 Saati",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Arabistan Standart Saati",
               "AST",
               "Arabistan Yaz Saati",
               "ADT",
               "Arabistan Saati",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska Standart Saati",
               "AKST",
               "Alaska Yaz Saati",
               "AKDT",
               "Alaska Saati",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standart Saati",
               "VST",
               "Vladivostok Yaz Saati",
               "VST",
               "Vladivostok Saati",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Standart Saati",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "\u0130rkutsk Standart Saati",
               "IST",
               "\u0130rkutsk Yaz Saati",
               "IST",
               "Irkutsk Saati",
               "IT",
            };
        final String[] Georgia = new String[] {
               "G\u00fcrcistan Standart Saati",
               "GST",
               "G\u00fcrcistan Yaz Saati",
               "GST",
               "G\u00fcrcistan Saati",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Saati",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Yeni Gine Saati",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standart Saati",
               "FNST",
               "Fernando de Noronha Yaz Saati",
               "FNST",
               "Fernando de Noronha Saati",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u00c7oybalsan Standart Saati",
               "CST",
               "\u00c7oybalsan Yaz Saati",
               "CST",
               "Choibalsan Saati",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standart Saati",
               "BST",
               "Brasilia Yaz Saati",
               "BST",
               "Brasilia Saati",
               "BT",
            };
        final String[] China = new String[] {
               "\u00c7in Standart Saati",
               "CST",
               "\u00c7in Yaz Saati",
               "CDT",
               "\u00c7in Saati",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ermenistan Standart Saati",
               "AST",
               "Ermenistan Yaz Saati",
               "AST",
               "Ermenistan Saati",
               "AT",
            };
        final String[] India = new String[] {
               "Hindistan Standart Saati",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cook Adalar\u0131 Standart Saati",
               "CIST",
               "Cook Adalar\u0131 Yar\u0131 Yaz Saati",
               "CIHST",
               "Cook Adalar\u0131 Saati",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
