/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.golem;

import net.sourceforge.plantuml.golem.TileGeometry;

public class Position {
    private final int xmin;
    private final int ymin;
    private final int xmax;
    private final int ymax;

    public Position(int xmin, int ymin, int xmax, int ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    public boolean equals(Object o) {
        Position other = (Position)o;
        return this.xmin == other.xmin && this.xmax == other.xmax && this.ymin == other.ymin && this.ymax == other.ymax;
    }

    public int hashCode() {
        return this.xmin + (this.ymin << 8) + (this.xmax << 16) + (this.ymax << 24);
    }

    public String toString() {
        return "(" + this.xmin + "," + this.ymin + ")-(" + this.xmax + "," + this.ymax + ")";
    }

    public Position move(TileGeometry position, int sizeMove) {
        if (position == null || position == TileGeometry.CENTER) {
            throw new IllegalArgumentException();
        }
        switch (position) {
            case NORTH: {
                return new Position(this.xmin, this.ymin - sizeMove, this.xmax, this.ymax - sizeMove);
            }
            case SOUTH: {
                return new Position(this.xmin, this.ymin + sizeMove, this.xmax, this.ymax + sizeMove);
            }
            case WEST: {
                return new Position(this.xmin - sizeMove, this.ymin, this.xmax - sizeMove, this.ymax);
            }
            case EAST: {
                return new Position(this.xmin + sizeMove, this.ymin, this.xmax + sizeMove, this.ymax);
            }
        }
        throw new IllegalStateException();
    }

    public int getXmin() {
        return this.xmin;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getYmin() {
        return this.ymin;
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getCenterX() {
        if ((this.xmin + this.xmax + 1) % 2 != 0) {
            throw new IllegalStateException();
        }
        return (this.xmin + this.xmax + 1) / 2;
    }

    public int getCenterY() {
        if ((this.ymin + this.ymax + 1) % 2 != 0) {
            throw new IllegalStateException();
        }
        return (this.ymin + this.ymax + 1) / 2;
    }
}

