/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyObjectRichCompareNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryOp;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerAndFloatTypes;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateUncached
@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
public abstract class PyObjectRichCompare
extends Node {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, RichCmpOp var5);

    public static Object executeUncached(Object a, Object b, RichCmpOp op) {
        return PyObjectRichCompareNodeGen.getUncached().execute(null, null, a, b, op);
    }

    @Specialization
    static boolean doInts(int a, int b, RichCmpOp op) {
        return op.compare(a, b);
    }

    @Specialization
    static boolean doDoubles(double a, double b, RichCmpOp op) {
        return op.compare(a, b);
    }

    @Specialization
    static boolean doLongs(long a, long b, RichCmpOp op) {
        return op.compare(a, b);
    }

    @Specialization(guards={"op.isEqOrNe()"})
    static boolean doStrings(TruffleString a, TruffleString b, RichCmpOp op, @Cached TruffleString.EqualNode equalNode) {
        return equalNode.execute((AbstractTruffleString)a, (AbstractTruffleString)b, PythonUtils.TS_ENCODING) == op.isEq();
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static Object doIt(VirtualFrame frame, Object v, Object w, RichCmpOp op, @Cached(inline=false) GenericRichCompare richCompare) {
        return richCompare.execute(frame, v, w, op);
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class GenericRichCompare
    extends Node {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, RichCmpOp var4);

        @Specialization
        static Object doIt(VirtualFrame frame, Object v, Object w, RichCmpOp op, @Bind Node inliningTarget, @Cached GetClassNode getVClass, @Cached GetClassNode getWClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached InlinedConditionProfile checkRevOpProfile, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached IsSubtypeNode isSubtypeNode, @Cached TpSlotRichCompare.CallSlotRichCmpNode callRichCmpSwapped, @Cached TpSlotRichCompare.CallSlotRichCmpNode callRichCmp, @Cached IsNode isNode, @Cached InlinedConditionProfile notImplemented1Profile, @Cached InlinedConditionProfile notImplemented2Profile, @Cached InlinedConditionProfile notImplemented3Profile, @Cached PRaiseNode raiseNode) {
            Object result;
            TpSlots vSlots;
            Object vClass = getVClass.execute(inliningTarget, v);
            Object wClass = getWClass.execute(inliningTarget, w);
            TpSlots wSlots = getWSlots.execute(inliningTarget, wClass);
            boolean checkedReverseOp = false;
            if (checkRevOpProfile.profile(inliningTarget, wSlots.tp_richcmp() != null && !isSameTypeNode.execute(inliningTarget, vClass, wClass) && isSubtypeNode.execute(wClass, vClass))) {
                checkedReverseOp = true;
                Object result2 = callRichCmpSwapped.execute(frame, inliningTarget, wSlots.tp_richcmp(), w, v, op.getSwapped());
                if (notImplemented1Profile.profile(inliningTarget, result2 != PNotImplemented.NOT_IMPLEMENTED)) {
                    return result2;
                }
            }
            if ((vSlots = getVSlots.execute(inliningTarget, vClass)).tp_richcmp() != null && notImplemented2Profile.profile(inliningTarget, (result = callRichCmp.execute(frame, inliningTarget, vSlots.tp_richcmp(), v, w, op)) != PNotImplemented.NOT_IMPLEMENTED)) {
                return result;
            }
            if (wSlots.tp_richcmp() != null && !checkedReverseOp && notImplemented3Profile.profile(inliningTarget, (result = callRichCmpSwapped.execute(frame, inliningTarget, wSlots.tp_richcmp(), w, v, op.getSwapped())) != PNotImplemented.NOT_IMPLEMENTED)) {
                return result;
            }
            return switch (op) {
                case RichCmpOp.Py_EQ, RichCmpOp.Py_NE -> {
                    if (isNode.execute(v, w) == op.isEq()) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, op.getOpName(), v, w);
            };
        }
    }

    @GenerateInline(value=false)
    public static abstract class RichCompareBinaryOp
    extends Node
    implements BinaryOp {
        private final RichCmpOp op;

        protected RichCompareBinaryOp(RichCmpOp op) {
            this.op = op;
        }

        public static RichCompareBinaryOp create(RichCmpOp op) {
            return PyObjectRichCompareNodeGen.RichCompareBinaryOpNodeGen.create(op);
        }

        @Specialization
        final Object doIt(VirtualFrame frame, Object left, Object right, @Cached PyObjectRichCompare richCmpNode) {
            return richCmpNode.execute(frame, this, left, right, this.op);
        }
    }
}

