/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;
    private boolean isFreed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    public OracleSerialBlob(byte[] bytes) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$12, null, new Object[]{bytes});
            }
            this.isFreed = false;
            if (bytes == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$12, null, sQLException);
                }
                throw sQLException;
            }
            this.length = bytes.length;
            this.buffer = new byte[(int)this.length];
            int i2 = 0;
            while ((long)i2 < this.length) {
                this.buffer[i2] = bytes[i2];
                ++i2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSerialBlob(Blob blob) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, blob);
            }
            this.isFreed = false;
            if (blob == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, sQLException);
                }
                throw sQLException;
            }
            this.length = blob.length();
            this.buffer = new byte[(int)this.length];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
            try {
                int bytesRead = 0;
                int offset = 0;
                do {
                    if (bl) {
                        this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "OracleSerialBlob.OracleSerialBlob(Blob), inside do-while loop, bytesRead=" + bytesRead + ", offset=" + offset);
                    }
                    bytesRead = bufferedInputStream.read(this.buffer, offset, (int)(this.length - (long)offset));
                    offset += bytesRead;
                } while (bytesRead > 0);
            }
            catch (IOException ioexception) {
                try {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 346, ioexception.getMessage()).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException ioexception2) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 346, ioexception2.getMessage()).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, sQLException);
                        }
                        throw sQLException;
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException ioexception) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 346, ioexception.getMessage()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$13, null, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$0, this, byteArrayInputStream);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$0, this, null);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, l2, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleSerialBlob.getBytes(" + (long)pos + ", " + (int)len + "), length=" + this.length);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            byte[] b2 = null;
            if (--pos < 0L || (long)len > this.length || pos + (long)len > this.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            b2 = new byte[len];
            System.arraycopy(this.buffer, (int)pos, b2, 0, (int)len);
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long length() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            long l2 = this.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$2, this, l2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$2, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ac2;
            void l3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, byArray, l2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleSerialBlob.position(ac, l): length=" + this.length);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (l3 < 1L) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 68, "position()").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (l3 > this.length || l3 + (long)((void)ac2).length - 1L > this.length) {
                long l4 = -1L;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, l4);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, null);
                }
                return -1L;
            }
            int i2 = (int)(l3 - 1L);
            boolean flag = false;
            long l22 = ((void)ac2).length;
            while ((long)i2 < this.length) {
                int j2 = 0;
                long l1 = i2 + 1;
                int k2 = i2;
                while ((long)j2 < l22 && (long)k2 < this.length && ac2[j2] == this.buffer[k2]) {
                    ++k2;
                    if ((long)(++j2) != l22) continue;
                    long l5 = l1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, l5);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, null);
                    }
                    return l5;
                }
                ++i2;
            }
            long l6 = -1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, l6);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, null);
            }
            return -1L;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position(Blob blob, long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l3;
            void blob2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$4, this, blob, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            long l4 = this.position(blob2.getBytes(1L, (int)blob2.length()), (long)l3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$4, this, l4);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$4, this, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$5, this, l2, byArray);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$5, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$6, this, l2, byArray, n2, n3);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$6, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$7, this, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$7, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void truncate(long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$8, this, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$8, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void free() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (this.isFreed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this, null);
                }
                return;
            }
            this.isFreed = true;
            this.buffer = null;
            this.length = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _len;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, l2, l3);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            if (--pos < 0L || pos + 1L > this.length || _len > this.length || pos > Integer.MAX_VALUE || this.length > Integer.MAX_VALUE || pos + _len > this.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer, (int)pos, (int)_len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, byteArrayInputStream);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, null);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$11, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$11, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$11, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSerialBlob.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$13 = OracleSerialBlob.class.getDeclaredConstructor(Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleSerialBlob.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleSerialBlob.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleSerialBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleSerialBlob.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleSerialBlob.class.getDeclaredMethod("truncate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleSerialBlob.class.getDeclaredMethod("setBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleSerialBlob.class.getDeclaredMethod("setBytes", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleSerialBlob.class.getDeclaredMethod("setBytes", Long.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleSerialBlob.class.getDeclaredMethod("position", Blob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleSerialBlob.class.getDeclaredMethod("position", byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleSerialBlob.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleSerialBlob.class.getDeclaredMethod("getBytes", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleSerialBlob.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

