/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxProtocol;
import com.informix.util.IfxErrMsg;
import com.informix.util.stringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;

public class IfxLocator {
    public static final int IFX_LOCATOR_SIZE = 72;
    private static final String IFX_LO_INCREFCOUNT = "function informix.ifx_lo_increfcount(blob)";
    private static final String IFX_LO_DECREFCOUNT = "function informix.ifx_lo_decrefcount(blob)";
    private byte[] rawLocator = null;
    private final IfxConnection conn;
    private final IfxProtocol prot;

    public IfxLocator() {
        this.rawLocator = new byte[72];
        this.prot = null;
        this.conn = null;
    }

    public IfxLocator(IfxLocator loc) {
        this.rawLocator = loc.rawLocator;
        this.conn = loc.conn;
        this.prot = this.conn.createProto();
    }

    public IfxLocator(Connection conn) {
        this.rawLocator = new byte[72];
        this.conn = (IfxConnection)conn;
        this.prot = this.conn.getProto();
    }

    public IfxLocator(byte[] byteBuf) throws SQLException {
        if (byteBuf == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.IfxLocator(byte[]) : byteBuf is null", Locale.getDefault());
        }
        this.rawLocator = byteBuf;
        this.prot = null;
        this.conn = null;
    }

    public IfxLocator(byte[] lo_ptr, Connection conn) {
        this.rawLocator = new byte[72];
        System.arraycopy(lo_ptr, 0, this.rawLocator, 0, 72);
        this.conn = (IfxConnection)conn;
        this.prot = this.conn.getProto();
    }

    void setRawLocator(byte[] lo) throws SQLException {
        if (lo == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.setRawLocator() : lo is null", this.conn);
        }
        this.rawLocator = lo;
    }

    public int incRefCount() throws SQLException {
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.incRefCount()", this.conn);
        }
        return this.prot.incRefCount(this.toBytes());
    }

    public int decRefCount() throws SQLException {
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.decRefCount()", this.conn);
        }
        return this.prot.decRefCount(this.toBytes());
    }

    public String toString() {
        return stringUtil.toHexString(this.rawLocator);
    }

    public byte[] toBytes() {
        return this.rawLocator;
    }

    public void free() {
        if (this.rawLocator != null) {
            this.rawLocator = null;
        }
    }
}

