/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.internal.Loggable;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class DebugFirstFailureClioSupport {
    public static void exiting(Logger logger, Level level, Class<Object> cls, Executable method, Object receiver, Throwable exception) {
        SecuredLogger securedLogger;
        if (exception != null && receiver instanceof Loggable && DebugFirstFailureClioSupport.isExitingTheDriverCodebase(Thread.currentThread().getStackTrace()) && (securedLogger = ((Loggable)receiver).getLogger()) != null) {
            securedLogger.dumpLog();
        }
    }

    private static boolean isExitingTheDriverCodebase(StackTraceElement[] stackFrames) {
        if (stackFrames.length < 3) {
            return true;
        }
        for (int i2 = 3; i2 < stackFrames.length; ++i2) {
            if (!stackFrames[i2].getClassName().startsWith("oracle.jdbc.")) continue;
            return false;
        }
        return true;
    }

    public static void entering(Logger logger, Level level, Class<Object> cls, Executable method, Object receiver, Object ... args) {
    }

    public static void throwing(Logger logger, Level level, Class<Object> cls, Executable method, Object receiver, Throwable thrown) {
    }

    public static boolean publicEnter() {
        return true;
    }

    public static void publicExit() {
    }

    public static void returning(Logger logger, Level level, Class<Object> cls, Executable method, Object receiver) {
    }

    public static void returning(Logger logger, Level level, Class<Object> cls, Executable method, Object receiver, Object value) {
    }
}

