/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.nio.file.Path;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.rest.RestManager;
import org.apache.solr.update.UpdateHandler;

public class SyntheticSolrCore
extends SolrCore {
    public SyntheticSolrCore(CoreContainer coreContainer, CoreDescriptor cd, ConfigSet configSet) {
        this(coreContainer, cd, configSet, null, null, null, null, false);
    }

    public SyntheticSolrCore(CoreContainer coreContainer, CoreDescriptor coreDescriptor, ConfigSet configSet, String dataDir, UpdateHandler updateHandler, IndexDeletionPolicyWrapper delPolicy, SolrCore prev, boolean reload) {
        super(coreContainer, coreDescriptor, configSet, dataDir, updateHandler, delPolicy, prev, reload);
    }

    public static SyntheticSolrCore createAndRegisterCore(CoreContainer coreContainer, String syntheticCoreName, String configSetName) {
        Map<String, String> coreProps = Map.of("collection", syntheticCoreName);
        CoreDescriptor syntheticCoreDescriptor = new CoreDescriptor(syntheticCoreName, Path.of(coreContainer.getSolrHome(), syntheticCoreName), coreProps, coreContainer.getContainerProperties(), coreContainer.getZkController());
        syntheticCoreDescriptor.setConfigSet(configSetName);
        ConfigSet coreConfig = coreContainer.getConfigSetService().loadConfigSet(syntheticCoreDescriptor);
        syntheticCoreDescriptor.setConfigSetTrusted(coreConfig.isTrusted());
        SyntheticSolrCore syntheticCore = new SyntheticSolrCore(coreContainer, syntheticCoreDescriptor, coreConfig);
        coreContainer.registerCore(syntheticCoreDescriptor, syntheticCore, false, false);
        return syntheticCore;
    }

    @Override
    protected void bufferUpdatesIfConstructing(CoreDescriptor coreDescriptor) {
    }

    @Override
    protected RestManager initRestManager() throws SolrException {
        return new RestManager();
    }

    @Override
    protected SyntheticSolrCore cloneForReloadCore(CoreDescriptor newCoreDescriptor, ConfigSet newCoreConfig, boolean cloneCurrentState) {
        return new SyntheticSolrCore(this.getCoreContainer(), newCoreDescriptor, newCoreConfig, this.getDataDir(), this.getUpdateHandler(), this.getDeletionPolicy(), cloneCurrentState ? this : null, true);
    }
}

