/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.jsyntaxpane;

import de.sciss.syntaxpane.DefaultSyntaxKit;
import de.sciss.syntaxpane.syntaxkits.GroovySyntaxKit;
import de.sciss.syntaxpane.syntaxkits.JavaSyntaxKit;
import de.sciss.syntaxpane.syntaxkits.LaTeXSyntaxKit;
import de.sciss.syntaxpane.util.Configuration;
import de.sciss.syntaxpane.util.JarServiceProvider;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(final BundleContext context) throws Exception {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"MindMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController, CommandLineOptions options) {
                if (!GraphicsEnvironment.isHeadless()) {
                    Activator.this.initJSyntaxPane(context);
                }
            }
        }, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJSyntaxPane(BundleContext context) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultSyntaxKit.class.getClassLoader());
            DefaultSyntaxKit.initKit();
            DefaultSyntaxKit.registerContentType((String)"text/latex", (String)LaTeXSyntaxKit.class.getName());
            Configuration defaultConfig = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class);
            defaultConfig.put("EnableWordWrap", "true");
            if (this.hasDarkBackground()) {
                this.configureDarkTheme(defaultConfig);
            }
            Configuration javaSyntaxKitConfig = DefaultSyntaxKit.getConfig(JavaSyntaxKit.class);
            Color selectionColor = new JTextField().getSelectionColor();
            if (selectionColor != null) {
                javaSyntaxKitConfig.put("SelectionColor", ColorUtils.colorToString((Color)selectionColor));
            }
            Stream.of("Action.insert-date", "Action.insert-date.Function", "Script.insert-date.URL").forEach(arg_0 -> ((Configuration)javaSyntaxKitConfig).remove(arg_0));
            String components = "de.sciss.syntaxpane.components.PairsMarker, de.sciss.syntaxpane.components.LineNumbersRuler, de.sciss.syntaxpane.components.TokenMarker, org.freeplane.plugin.jsyntaxpane.NodeIdHighLighter";
            DefaultSyntaxKit.getConfig(GroovySyntaxKit.class).put("Components", "de.sciss.syntaxpane.components.PairsMarker, de.sciss.syntaxpane.components.LineNumbersRuler, de.sciss.syntaxpane.components.TokenMarker, org.freeplane.plugin.jsyntaxpane.NodeIdHighLighter");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void configureDarkTheme(Configuration config) {
        String url = DefaultSyntaxKit.class.getName().replace(".", "/") + "/dark";
        Properties p = JarServiceProvider.readProperties((String)url);
        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x, y) -> config.put((String)x, (String)y)));
    }

    private boolean hasDarkBackground() {
        Color background = new JEditorPane().getBackground();
        return !UITools.isLight((Color)background);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

