/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.AnalysisUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.SavedRegisterMap;
import ghidra.app.plugin.core.debug.stack.UnwindAnalysis;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.app.plugin.core.debug.stack.UnwindInfo;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class StackUnwinder {
    public static final CategoryPath FRAMES_PATH = new CategoryPath("/Frames");
    public static final int PC_OP_INDEX = -1;
    public static final int BASE_OP_INDEX = 0;
    private final PluginTool tool;
    private final DebuggerStaticMappingService mappings;
    final TracePlatform platform;
    final Trace trace;
    final Register pc;
    final AddressSpace codeSpace;
    private final Register sp;
    private final AddressSpace stackSpace;

    private static DebuggerStaticMappingService getMappings(PluginTool tool) {
        return (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
    }

    private static DebuggerPcodeUtils.WatchValuePcodeExecutorState getState(PluginTool tool, DebuggerCoordinates coordinates) {
        return DebuggerPcodeUtils.buildWatchState((ServiceProvider)tool, coordinates);
    }

    public StackUnwinder(PluginTool tool, TracePlatform platform) {
        this.tool = tool;
        this.mappings = StackUnwinder.getMappings(tool);
        this.platform = platform;
        this.trace = platform.getTrace();
        this.pc = Objects.requireNonNull(platform.getLanguage().getProgramCounter(), "Platform must have a program counter");
        this.codeSpace = platform.getLanguage().getDefaultSpace();
        CompilerSpec compiler = platform.getCompilerSpec();
        this.sp = Objects.requireNonNull(compiler.getStackPointer(), "Platform must have a stack pointer");
        this.stackSpace = compiler.getStackBaseSpace();
    }

    public AnalysisUnwoundFrame<DebuggerPcodeUtils.WatchValue> start(DebuggerCoordinates coordinates, TaskMonitor monitor) throws CancelledException {
        if (coordinates.getPlatform() != this.platform) {
            throw new IllegalArgumentException("Not same platform");
        }
        return this.start(coordinates, StackUnwinder.getState(this.tool, coordinates), monitor);
    }

    public <T> AnalysisUnwoundFrame<T> start(DebuggerCoordinates coordinates, PcodeExecutorState<T> state, TaskMonitor monitor) throws CancelledException {
        return this.start(coordinates, coordinates.getFrame(), state, monitor);
    }

    protected <T> AnalysisUnwoundFrame<T> start(DebuggerCoordinates coordinates, int level, PcodeExecutorState<T> state, TaskMonitor monitor) throws CancelledException {
        Address pcVal = null;
        TraceThread thread = coordinates.getThread();
        long viewSnap = coordinates.getViewSnap();
        try {
            TraceStackFrame frame;
            TraceStack stack = this.trace.getStackManager().getLatestStack(thread, viewSnap);
            if (stack != null && (frame = stack.getFrame(viewSnap, level, false)) != null) {
                pcVal = frame.getProgramCounter(viewSnap);
            }
        }
        catch (IllegalStateException stack) {
            // empty catch block
        }
        TraceMemorySpace regs = Objects.requireNonNull(this.trace.getMemoryManager().getMemoryRegisterSpace(thread, level, false), "Frame must have a register bank");
        if (pcVal == null) {
            if (TraceMemoryState.KNOWN != regs.getState(this.platform, viewSnap, this.pc)) {
                throw new UnwindException("Frame must have KNOWN " + String.valueOf(this.pc) + " value");
            }
            pcVal = this.codeSpace.getAddress(regs.getValue(this.platform, viewSnap, this.pc).getUnsignedValue().longValue());
        }
        if (TraceMemoryState.KNOWN != regs.getState(this.platform, viewSnap, this.sp)) {
            throw new UnwindException("Frame must have KNOWN " + String.valueOf(this.sp) + " value");
        }
        Address spVal = this.stackSpace.getAddress(regs.getValue(this.platform, viewSnap, this.sp).getUnsignedValue().longValue());
        return this.unwind(coordinates, level, pcVal, spVal, state, new SavedRegisterMap(), monitor);
    }

    public StaticAndUnwind computeUnwindInfo(long snap, int level, Address pcVal, TaskMonitor monitor) throws CancelledException {
        ProgramLocation staticPcLoc;
        ProgramLocation programLocation = staticPcLoc = this.mappings == null ? null : this.mappings.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.trace, null, Lifespan.at((long)snap), pcVal));
        if (staticPcLoc == null) {
            throw new UnwindException("Cannot find static program for frame " + level + " (" + String.valueOf(this.pc) + "=" + String.valueOf(pcVal) + ")");
        }
        Program program = staticPcLoc.getProgram();
        Address staticPc = staticPcLoc.getAddress();
        try {
            UnwindAnalysis ua = new UnwindAnalysis(program);
            return new StaticAndUnwind(staticPc, ua.computeUnwindInfo(staticPc, monitor));
        }
        catch (Exception e) {
            return new StaticAndUnwind(staticPc, UnwindInfo.errorOnly(e));
        }
    }

    <T> AnalysisUnwoundFrame<T> unwind(DebuggerCoordinates coordinates, int level, Address pcVal, Address spVal, PcodeExecutorState<T> state, SavedRegisterMap registerMap, TaskMonitor monitor) throws CancelledException {
        try {
            StaticAndUnwind sau = this.computeUnwindInfo(coordinates.getSnap(), level, pcVal, monitor);
            return new AnalysisUnwoundFrame<T>(this.tool, coordinates, this, state, level, pcVal, spVal, sau.staticPc, sau.info, registerMap);
        }
        catch (Exception e) {
            return new AnalysisUnwoundFrame<T>(this.tool, coordinates, this, state, level, pcVal, spVal, null, UnwindInfo.errorOnly(e), registerMap);
        }
    }

    public <T> Iterable<AnalysisUnwoundFrame<T>> frames(final DebuggerCoordinates coordinates, final PcodeExecutorState<T> state, final TaskMonitor monitor) {
        return new Iterable<AnalysisUnwoundFrame<T>>(){

            @Override
            public Iterator<AnalysisUnwoundFrame<T>> iterator() {
                return new Iterator<AnalysisUnwoundFrame<T>>(){
                    AnalysisUnwoundFrame<T> next = this.tryStart();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public AnalysisUnwoundFrame<T> next() {
                        AnalysisUnwoundFrame cur = this.next;
                        this.next = this.tryNext();
                        return cur;
                    }

                    private AnalysisUnwoundFrame<T> tryStart() {
                        try {
                            return StackUnwinder.this.start(coordinates, state, monitor);
                        }
                        catch (UnwindException | CancelledException e) {
                            return null;
                        }
                    }

                    private AnalysisUnwoundFrame<T> tryNext() {
                        try {
                            return this.next.unwindNext(monitor);
                        }
                        catch (UnwindException | CancelledException | NoSuchElementException e) {
                            return null;
                        }
                    }
                };
            }
        };
    }

    public Iterable<AnalysisUnwoundFrame<DebuggerPcodeUtils.WatchValue>> frames(DebuggerCoordinates coordinates, TaskMonitor monitor) {
        return this.frames(coordinates, StackUnwinder.getState(this.tool, coordinates), monitor);
    }

    record StaticAndUnwind(Address staticPc, UnwindInfo info) {
    }
}

