/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.cmd;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import java.util.ArrayList;

public class CompoundCmd<T extends DomainObject>
implements Command<T> {
    private ArrayList<Command<T>> cmds = new ArrayList();
    private String statusMsg;
    private String name;

    public CompoundCmd(String name) {
        this.name = name;
    }

    @Override
    public boolean applyTo(T obj) {
        for (Command<T> cmd : this.cmds) {
            if (cmd.applyTo(obj)) continue;
            this.statusMsg = cmd.getStatusMsg();
            return false;
        }
        return true;
    }

    @Override
    public String getStatusMsg() {
        return this.statusMsg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(Command<T> cmd) {
        this.cmds.add(cmd);
    }

    public int size() {
        return this.cmds.size();
    }
}

