/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class VTAbstractProgramCorrelator
implements VTProgramCorrelator {
    private final Program sourceProgram;
    private final AddressSetView sourceAddressSet;
    private final Program destinationProgram;
    private final AddressSetView destinationAddressSet;
    private final ToolOptions options;

    public VTAbstractProgramCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options) {
        this.sourceProgram = sourceProgram;
        this.sourceAddressSet = sourceAddressSet;
        this.destinationProgram = destinationProgram;
        this.destinationAddressSet = destinationAddressSet;
        this.options = options;
    }

    @Override
    public final VTMatchSet correlate(VTSession session, TaskMonitor monitor) throws CancelledException {
        VTMatchSet matchSet = session.createMatchSet(this);
        this.doCorrelate(matchSet, monitor);
        return matchSet;
    }

    protected abstract void doCorrelate(VTMatchSet var1, TaskMonitor var2) throws CancelledException;

    @Override
    public ToolOptions getOptions() {
        return this.options.copy();
    }

    @Override
    public AddressSetView getSourceAddressSet() {
        return this.sourceAddressSet;
    }

    @Override
    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    @Override
    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    @Override
    public AddressSetView getDestinationAddressSet() {
        return this.destinationAddressSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sourceProgram.hashCode();
        result = 31 * result + this.destinationProgram.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VTAbstractProgramCorrelator other = (VTAbstractProgramCorrelator)obj;
        if (!this.destinationProgram.equals((Object)other.destinationProgram)) {
            return false;
        }
        if (!this.sourceProgram.equals((Object)other.sourceProgram)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.destinationAddressSet, (Object)other.destinationAddressSet)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.sourceAddressSet, (Object)other.sourceAddressSet)) {
            return false;
        }
        return this.options.equals((Object)other.options);
    }

    public String toString() {
        return this.getName();
    }
}

