/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import ghidra.program.model.symbol.SourceType;
import java.util.HashSet;
import java.util.Set;

public class ClearOptions {
    private Set<ClearType> typesToClearSet = new HashSet<ClearType>();

    public ClearOptions() {
        this(true);
    }

    public ClearOptions(boolean defaultClearState) {
        if (defaultClearState) {
            for (ClearType type : ClearType.values()) {
                this.typesToClearSet.add(type);
            }
        }
    }

    public void setShouldClear(ClearType type, boolean shouldClear) {
        if (shouldClear) {
            this.typesToClearSet.add(type);
        } else {
            this.typesToClearSet.remove((Object)type);
        }
    }

    public boolean shouldClear(ClearType type) {
        return this.typesToClearSet.contains((Object)type);
    }

    Set<SourceType> getReferenceSourceTypesToClear() {
        HashSet<SourceType> sourceTypesToClear = new HashSet<SourceType>();
        if (this.shouldClear(ClearType.USER_REFERENCES)) {
            sourceTypesToClear.add(SourceType.USER_DEFINED);
        }
        if (this.shouldClear(ClearType.DEFAULT_REFERENCES)) {
            sourceTypesToClear.add(SourceType.DEFAULT);
        }
        if (this.shouldClear(ClearType.IMPORT_REFERENCES)) {
            sourceTypesToClear.add(SourceType.IMPORTED);
        }
        if (this.shouldClear(ClearType.ANALYSIS_REFERENCES)) {
            sourceTypesToClear.add(SourceType.ANALYSIS);
        }
        return sourceTypesToClear;
    }

    boolean clearAny() {
        return !this.typesToClearSet.isEmpty();
    }

    public static enum ClearType {
        INSTRUCTIONS,
        DATA,
        SYMBOLS,
        COMMENTS,
        PROPERTIES,
        FUNCTIONS,
        REGISTERS,
        EQUATES,
        USER_REFERENCES,
        ANALYSIS_REFERENCES,
        IMPORT_REFERENCES,
        DEFAULT_REFERENCES,
        BOOKMARKS;

    }
}

