/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.VarnodeType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;

class VarnodeInfo {
    private VarnodeType type;
    private Address address;
    private Integer size;
    private Register register;
    private final Program program;

    VarnodeInfo(Program program, VarnodeType type) {
        this.program = program;
        this.type = type;
    }

    VarnodeInfo(Program program, Varnode varnode) {
        this.program = program;
        this.setVarnode(varnode);
    }

    public VarnodeType getType() {
        return this.type;
    }

    public Address getAddress() {
        return this.address;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setVarnodeType(VarnodeType type) {
        this.type = type;
        this.address = null;
        this.register = null;
        if (type == VarnodeType.Register) {
            this.size = null;
        }
    }

    public void setVarnode(Address address, Integer size) {
        this.address = address;
        this.size = size;
        this.register = VarnodeInfo.getRegister(this.program, address, size);
        if (address == null) {
            return;
        }
        if (address.isRegisterAddress() || this.register != null) {
            this.type = VarnodeType.Register;
        } else if (address.isStackAddress()) {
            this.type = VarnodeType.Stack;
        } else if (address.isMemoryAddress()) {
            this.type = VarnodeType.Memory;
        } else {
            throw new IllegalArgumentException("Illegal varnode address type");
        }
    }

    public void setVarnode(Varnode varnode) {
        this.setVarnode(varnode.getAddress(), varnode.getSize());
    }

    public Register getRegister() {
        return this.register;
    }

    public static Register getRegister(Program program, Address address, Integer size) {
        if (address == null) {
            return null;
        }
        if (!address.isRegisterAddress() && !address.getAddressSpace().hasMappedRegisters()) {
            return null;
        }
        if (size == null) {
            return program.getRegister(address);
        }
        Register register = program.getRegister(address, size.intValue());
        if (register == null) {
            register = program.getRegister(address);
        }
        return register;
    }
}

