/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import generic.json.Json;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import java.util.ArrayList;
import java.util.List;

public class LocationReferenceContextBuilder {
    private List<LocationReferenceContext.Part> parts = new ArrayList<LocationReferenceContext.Part>();

    public LocationReferenceContextBuilder append(String text) {
        if (text == null) {
            text = "";
        }
        this.parts.add(new LocationReferenceContext.BasicPart(text));
        return this;
    }

    public LocationReferenceContextBuilder appendMatch(String text) {
        if (text == null) {
            throw new NullPointerException("Match text cannot be null");
        }
        this.parts.add(new LocationReferenceContext.MatchPart(text));
        return this;
    }

    public LocationReferenceContextBuilder newline() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("Cannot add a newline without first appending text");
        }
        LocationReferenceContext.Part last = this.parts.get(this.parts.size() - 1);
        last.text = last.text + "\n";
        return this;
    }

    public LocationReferenceContext build() {
        return new LocationReferenceContext(this.parts);
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public String toString() {
        return Json.toString((Object)this);
    }
}

